/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io;

import de.cismet.cismap.commons.Crs;
import de.cismet.commons.cismap.io.AddGeometriesToMapEnterDataVisualPanel;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.commons.converter.Converter;
import de.cismet.commons.gui.wizard.AbstractWizardPanel;
import de.cismet.commons.gui.wizard.converter.ConverterPreselectionMode;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public final class AddGeometriesToMapEnterDataWizardPanel
extends AbstractWizardPanel
implements WizardDescriptor.FinishablePanel {
    private static final transient Logger LOG = Logger.getLogger(AddGeometriesToMapEnterDataWizardPanel.class);
    public static final String PROP_COORDINATE_DATA = "__prop_coordinate_data__";
    private final transient ExecutorService dispatcher;
    private final transient ThreadFactory threadFactory = CismetConcurrency.getInstance((String)"cismap-commons").createThreadFactory("AddGeometriesToMapEnterDataWizardPanel-threadfactory");
    private final transient PropertyChangeSupport propCSupport;
    private transient File inputFile;
    private transient String coordinateData;
    private transient String crsName;
    private transient Converter selectedConverter;
    private transient ConverterPreselectionMode converterPreselectionMode;
    private transient List<Converter> availableConverters;
    private transient ScheduledExecutorService detectorExecutor;
    private transient ScheduledFuture<?> currentDetectorTask;

    public AddGeometriesToMapEnterDataWizardPanel() {
        this.dispatcher = CismetExecutors.newSingleThreadExecutor((ThreadFactory)this.threadFactory);
        this.propCSupport = new PropertyChangeSupport((Object)this);
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        File oldData = this.inputFile;
        this.inputFile = inputFile;
        this.changeSupport.fireChange();
        this.propCSupport.firePropertyChange("inputFile", oldData, this.inputFile);
        this.processInputFile(inputFile);
    }

    private void processInputFile(final File inputFile) {
        this.dispatcher.execute(new SwingWorker<String, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected String doInBackground() throws Exception {
                Thread.currentThread().setName("AddGeometriesToMapEnterDataWizardPanel processInputFile()");
                if (inputFile != null && inputFile.isFile() && inputFile.canRead()) {
                    BufferedReader fileReader = null;
                    try {
                        String line;
                        fileReader = new BufferedReader(new FileReader(inputFile));
                        StringBuilder sb = new StringBuilder();
                        while ((line = fileReader.readLine()) != null) {
                            sb.append(line).append('\n');
                        }
                        if (sb.length() > 0) {
                            sb.deleteCharAt(sb.length() - 1);
                        }
                        String string = sb.toString();
                        return string;
                    }
                    catch (FileNotFoundException ex) {
                        throw new IllegalStateException("file was present and readable, but now is not anymore: " + inputFile, ex);
                    }
                    catch (IOException ex) {
                        LOG.warn((Object)"cannot read input file", (Throwable)ex);
                    }
                    finally {
                        if (fileReader != null) {
                            try {
                                fileReader.close();
                            }
                            catch (IOException ex) {
                                LOG.warn((Object)("cannot close input file: " + inputFile), (Throwable)ex);
                            }
                        }
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    String fileData = (String)this.get(300L, TimeUnit.MILLISECONDS);
                    if (fileData != null) {
                        AddGeometriesToMapEnterDataWizardPanel.this.setCoordinateData(fileData);
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"cannot fetch result data from worker", (Throwable)ex);
                }
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propCSupport.addPropertyChangeListener(pcl);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener pcl) {
        this.propCSupport.addPropertyChangeListener(property, pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.propCSupport.removePropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener pcl) {
        this.propCSupport.removePropertyChangeListener(property, pcl);
    }

    public String getCoordinateData() {
        return this.coordinateData;
    }

    public void setCoordinateData(String coordinateData) {
        String oldData = this.coordinateData;
        this.coordinateData = coordinateData;
        this.changeSupport.fireChange();
        this.propCSupport.firePropertyChange("coordinateData", oldData, this.coordinateData);
        if (ConverterPreselectionMode.AUTO_DETECT == this.converterPreselectionMode) {
            this.detectFormat();
        }
    }

    public String getCrsName() {
        return this.crsName;
    }

    public void setCrsName(String crsName) {
        String oldData = this.crsName;
        this.crsName = crsName;
        this.changeSupport.fireChange();
        this.propCSupport.firePropertyChange("crsName", oldData, this.crsName);
    }

    public Converter getSelectedConverter() {
        return this.selectedConverter;
    }

    public void setSelectedConverter(Converter selectedConverter) {
        Converter oldData = this.selectedConverter;
        this.selectedConverter = selectedConverter;
        this.changeSupport.fireChange();
        this.propCSupport.firePropertyChange("selectedConverter", oldData, this.selectedConverter);
    }

    public ConverterPreselectionMode getConverterPreselectionMode() {
        return this.converterPreselectionMode;
    }

    public void setConverterPreselectionMode(ConverterPreselectionMode converterPreselectionMode) {
        ConverterPreselectionMode oldData = this.converterPreselectionMode;
        this.converterPreselectionMode = converterPreselectionMode;
        this.changeSupport.fireChange();
        this.propCSupport.firePropertyChange("converterPreselectionMode", oldData, this.converterPreselectionMode);
    }

    public boolean isValid() {
        if (this.coordinateData == null || this.coordinateData.isEmpty()) {
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddGeometriesToMapEnterDataWizardPanel.class, (String)"AddGeometriesToMapEnterDataWizardPanel.isValid().infoMessage.enterCoordinateData"));
            return false;
        }
        this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddGeometriesToMapEnterDataWizardPanel.class, (String)"AddGeometriesToMapEnterDataWizardPanel.isValid().infoMessage.proceed"));
        return true;
    }

    private void detectFormat() {
        if (this.currentDetectorTask != null) {
            this.currentDetectorTask.cancel(true);
        }
        DetectConverterTask task = new DetectConverterTask();
        this.currentDetectorTask = this.detectorExecutor.schedule(task, 300L, TimeUnit.MILLISECONDS);
    }

    protected Component createComponent() {
        return new AddGeometriesToMapEnterDataVisualPanel(this);
    }

    protected void read(WizardDescriptor wizard) {
        this.setConverterPreselectionMode((ConverterPreselectionMode)wizard.getProperty("__prop_converter_preselect_mode__"));
        if (ConverterPreselectionMode.AUTO_DETECT == this.converterPreselectionMode) {
            this.availableConverters = (List)wizard.getProperty("__prop_available_converters__");
            this.detectorExecutor = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        }
        this.setCoordinateData((String)wizard.getProperty(PROP_COORDINATE_DATA));
        this.setInputFile((File)wizard.getProperty("__prop_input_file__"));
        this.setCrsName(((Crs)wizard.getProperty("__prop_current_epsg_code__")).getShortname());
        this.setSelectedConverter((Converter)wizard.getProperty("__prop_converter__"));
    }

    protected void store(WizardDescriptor wizard) {
        wizard.putProperty(PROP_COORDINATE_DATA, (Object)this.coordinateData);
        wizard.putProperty("__prop_converter__", (Object)this.selectedConverter);
        wizard.putProperty("__prop_input_file__", null);
        this.availableConverters = null;
        if (this.detectorExecutor != null) {
            this.detectorExecutor.shutdownNow();
            this.detectorExecutor = null;
        }
    }

    public boolean isFinishPanel() {
        return this.selectedConverter != null;
    }

    private final class DetectConverterTask
    implements Runnable {
        private DetectConverterTask() {
        }

        @Override
        public void run() {
            Converter highScoreConverter = null;
            int highScoreConverterRating = 0;
            for (Converter converter : AddGeometriesToMapEnterDataWizardPanel.this.availableConverters) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (!(converter instanceof Converter.MatchRating)) continue;
                Converter.MatchRating matchRating = (Converter.MatchRating)converter;
                int converterRating = matchRating.rate((Object)AddGeometriesToMapEnterDataWizardPanel.this.getCoordinateData(), new String[]{((Crs)AddGeometriesToMapEnterDataWizardPanel.this.wizard.getProperty("__prop_current_epsg_code__")).getCode()});
                if (converterRating <= highScoreConverterRating) continue;
                highScoreConverterRating = converterRating;
                highScoreConverter = converter;
            }
            final Converter detectedConverter = highScoreConverter;
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddGeometriesToMapEnterDataWizardPanel.this.setSelectedConverter(detectedConverter);
                }
            });
        }
    }
}

