/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io;

import com.vividsolutions.jts.geom.GeometryCollection;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.commons.cismap.io.AddGeometriesToMapPreviewWizardPanel;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.commons.gui.progress.BusyStatusPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class AddGeometriesToMapPreviewVisualPanel
extends JPanel {
    private static final transient Logger LOG = Logger.getLogger(AddGeometriesToMapPreviewVisualPanel.class);
    private final transient AddGeometriesToMapPreviewWizardPanel model;
    private final transient ChangeListener modelChangeL;
    private final transient JPanel pnlPreview = new JPanel();
    private final transient BusyStatusPanel pnlStatus = new BusyStatusPanel();
    private final transient MappingComponent previewMap = new MappingComponent();

    public AddGeometriesToMapPreviewVisualPanel(AddGeometriesToMapPreviewWizardPanel model) {
        this.model = model;
        this.initComponents();
        this.modelChangeL = new ModelChangeListener();
        model.addChangeListener(WeakListeners.change((ChangeListener)this.modelChangeL, (Object)((Object)model)));
        this.setName(NbBundle.getMessage(AddGeometriesToMapPreviewVisualPanel.class, (String)"AddGeometriesToMapPreviewVisualPanel.<init>(AddGeometryToMapPreviewWizardPanel).panelName"));
    }

    public AddGeometriesToMapPreviewWizardPanel getModel() {
        return this.model;
    }

    private void initMap() {
        final double buffer = this.model.getCurrentCrs().isMetric() ? 5.0 : 0.001;
        CismetConcurrency.getInstance((String)"cismap-commons").getDefaultExecutor().execute(new SwingWorker<XBoundingBox, Void>(){

            @Override
            protected XBoundingBox doInBackground() throws Exception {
                Thread.currentThread().setName("AddGeometriesToMapPreviewVisualPanel initMap()");
                try {
                    XBoundingBox box = new XBoundingBox(AddGeometriesToMapPreviewVisualPanel.this.model.getGeometry().getEnvelope().buffer(buffer));
                    CrsTransformer transformer = new CrsTransformer(AddGeometriesToMapPreviewVisualPanel.this.model.getCurrentCrs().getCode());
                    return transformer.transformBoundingBox(box);
                }
                catch (Exception e) {
                    LOG.warn((Object)"cannot create home bbox for current crs, preview most likely without background layer", (Throwable)e);
                    return null;
                }
            }

            @Override
            protected void done() {
                String previewUrl;
                XBoundingBox homeBbox = null;
                try {
                    homeBbox = (XBoundingBox)this.get(300L, TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"cannot retrieve home boundingbox, preview unusable", (Throwable)ex);
                }
                XBoundingBox box = new XBoundingBox(AddGeometriesToMapPreviewVisualPanel.this.model.getGeometry().getEnvelope().buffer(buffer));
                ActiveLayerModel mappingModel = (ActiveLayerModel)AddGeometriesToMapPreviewVisualPanel.this.previewMap.getMappingModel();
                mappingModel.setSrs(AddGeometriesToMapPreviewVisualPanel.this.model.getCurrentCrs());
                mappingModel.addHome(box);
                if (homeBbox != null) {
                    mappingModel.addHome(homeBbox);
                }
                if ((previewUrl = AddGeometriesToMapPreviewVisualPanel.this.model.getPreviewUrl()) != null) {
                    SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(previewUrl));
                    swms.setName("background");
                    mappingModel.addLayer(swms);
                }
                AddGeometriesToMapPreviewVisualPanel.this.previewMap.setMappingModel(mappingModel);
                AddGeometriesToMapPreviewVisualPanel.this.previewMap.setAnimationDuration(0);
                AddGeometriesToMapPreviewVisualPanel.this.previewMap.gotoInitialBoundingBox();
                AddGeometriesToMapPreviewVisualPanel.this.previewMap.setInteractionMode("ZOOM");
                AddGeometriesToMapPreviewVisualPanel.this.previewMap.setInteractionMode("MUTE");
                if (AddGeometriesToMapPreviewVisualPanel.this.model.hasMultipleGeometries() && AddGeometriesToMapPreviewVisualPanel.this.model.getGeometry() instanceof GeometryCollection) {
                    GeometryCollection gc = (GeometryCollection)AddGeometriesToMapPreviewVisualPanel.this.model.getGeometry();
                    for (int i = 0; i < gc.getNumGeometries(); ++i) {
                        PureNewFeature dsf = new PureNewFeature(gc.getGeometryN(i));
                        AddGeometriesToMapPreviewVisualPanel.this.previewMap.getFeatureCollection().addFeature(dsf);
                    }
                } else {
                    PureNewFeature dsf = new PureNewFeature(AddGeometriesToMapPreviewVisualPanel.this.model.getGeometry());
                    AddGeometriesToMapPreviewVisualPanel.this.previewMap.getFeatureCollection().addFeature(dsf);
                }
                AddGeometriesToMapPreviewVisualPanel.this.previewMap.setAnimationDuration(300);
                AddGeometriesToMapPreviewVisualPanel.this.previewMap.unlock();
                AddGeometriesToMapPreviewVisualPanel.this.previewMap.zoomToFeatureCollection();
            }
        });
    }

    private void clearMap() {
        assert (EventQueue.isDispatchThread()) : "may only be accessed in EDT";
        this.previewMap.getFeatureCollection().removeAllFeatures();
        ActiveLayerModel mappingModel = new ActiveLayerModel();
        this.previewMap.setMappingModel(mappingModel);
        this.previewMap.lock();
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.pnlPreview.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AddGeometriesToMapPreviewVisualPanel.class, (String)"AddGeometriesToMapPreviewVisualPanel.pnlPreview.border.title")));
        this.pnlPreview.setOpaque(false);
        this.pnlPreview.setLayout(new BorderLayout());
        this.pnlPreview.add((Component)((Object)this.previewMap), "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnlPreview, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnlStatus, gridBagConstraints);
    }

    private final class ModelChangeListener
    implements ChangeListener {
        private ModelChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() instanceof AddGeometriesToMapPreviewWizardPanel) {
                AddGeometriesToMapPreviewVisualPanel.this.pnlStatus.setBusy(AddGeometriesToMapPreviewVisualPanel.this.model.isBusy());
                AddGeometriesToMapPreviewVisualPanel.this.pnlStatus.setStatusMessage(AddGeometriesToMapPreviewVisualPanel.this.model.getStatusMessage());
                if (AddGeometriesToMapPreviewVisualPanel.this.model.getGeometry() == null) {
                    AddGeometriesToMapPreviewVisualPanel.this.clearMap();
                } else {
                    AddGeometriesToMapPreviewVisualPanel.this.initMap();
                }
            }
        }
    }
}

