/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import de.cismet.commons.cismap.io.converters.AbstractGeometryFromTextConverter;
import de.cismet.commons.cismap.io.converters.PointFromTextConverter;
import de.cismet.commons.converter.ConversionException;
import de.cismet.commons.converter.Converter;
import org.openide.util.NbBundle;

public final class BoundingBoxFromTextConverter
extends AbstractGeometryFromTextConverter
implements Converter.MatchRating<String> {
    @Override
    protected Geometry createGeometry(Coordinate[] coordinates, GeometryFactory geomFactory) throws ConversionException {
        if (coordinates.length < 2) {
            throw new ConversionException("too few coordinates for bounding box: " + coordinates.length);
        }
        Coordinate[] coords = new Coordinate[5];
        double llx = coordinates[0].x;
        double lly = coordinates[0].y;
        double urx = coordinates[1].x;
        double ury = coordinates[1].y;
        coords[0] = coordinates[0];
        coords[1] = new Coordinate(llx, ury);
        coords[2] = coordinates[1];
        coords[3] = new Coordinate(urx, lly);
        coords[4] = coordinates[0];
        LinearRing ring = geomFactory.createLinearRing(coords);
        return geomFactory.createPolygon(ring, null);
    }

    public String getFormatName() {
        return "BoundingBoxFromTextConverter";
    }

    public String getFormatDisplayName() {
        return NbBundle.getMessage(BoundingBoxFromTextConverter.class, (String)"BoundingBoxFromTextConverter.getFormatDisplayName().returnValue");
    }

    public String getFormatHtmlName() {
        return null;
    }

    @Override
    public String getFormatDescription() {
        String desc = NbBundle.getMessage(PointFromTextConverter.class, (String)"BoundingBoxFromTextConverter.getFormatDescription().returnValue");
        String superDesc = super.getFormatDescription();
        return desc + "\n" + superDesc;
    }

    @Override
    public String getFormatHtmlDescription() {
        String desc = NbBundle.getMessage(PointFromTextConverter.class, (String)"BoundingBoxFromTextConverter.getFormatHtmlDescription().returnValue").replaceAll("<[/]?html>", "");
        String superDesc = super.getFormatHtmlDescription().replaceAll("<[/]?html>", "");
        return "<html>" + desc + "<br/>" + superDesc + "</html>";
    }

    public Object getFormatExample() {
        return NbBundle.getMessage(PointFromTextConverter.class, (String)"BoundingBoxFromTextConverter.getFormatExample().returnValue", (Object)Character.valueOf(this.getDecimalSeparator()));
    }

    @Override
    public int rate(String from, String ... params) {
        int superRating = super.rate(from, params);
        if (superRating == 0) {
            return 0;
        }
        String[] tokens = from.split(this.getTokenRegex());
        if (tokens.length < 4) {
            return 0;
        }
        if (tokens.length > 4) {
            return 50;
        }
        return 100;
    }
}

