/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.commons.cismap.io.converters.AbstractRatingConverter;
import de.cismet.commons.cismap.io.converters.TextToGeometryConverter;
import de.cismet.commons.converter.ConversionException;
import org.openide.util.NbBundle;

public final class GeomFromWktConverter
extends AbstractRatingConverter<String, Geometry>
implements TextToGeometryConverter {
    @Override
    public Geometry convertForward(String from, String ... params) throws ConversionException {
        int srid;
        EWKT ewkt;
        if (from == null || from.isEmpty()) {
            throw new IllegalArgumentException("'from' must not be null or empty");
        }
        if (params == null || params.length < 1) {
            throw new IllegalArgumentException("no parameters provided, epsgcode is required parameter");
        }
        try {
            ewkt = this.getEWKT(from);
        }
        catch (RuntimeException e) {
            throw new ConversionException("illegal (e)wkt format: " + from, (Throwable)e);
        }
        if (ewkt.srid < 0) {
            try {
                srid = CrsTransformer.extractSridFromCrs(params[0]);
            }
            catch (Exception e) {
                throw new ConversionException("unsupported epsg parameter: " + params[0], (Throwable)e);
            }
        } else {
            srid = ewkt.srid;
        }
        GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
        WKTReader wktReader = new WKTReader(geomFactory);
        try {
            return wktReader.read(ewkt.wkt);
        }
        catch (ParseException ex) {
            throw new ConversionException("cannot create geometry from WKT: " + ewkt.wkt, (Throwable)ex);
        }
    }

    private EWKT getEWKT(String candidate) {
        EWKT ewkt = new EWKT();
        int skIndex = candidate.indexOf(59);
        if (skIndex > 0) {
            String sridKV = candidate.substring(0, skIndex);
            int eqIndex = sridKV.indexOf(61);
            if (eqIndex > 0) {
                ewkt.srid = Integer.parseInt(sridKV.substring(eqIndex + 1));
                ewkt.wkt = candidate.substring(skIndex + 1);
            } else {
                ewkt.wkt = candidate;
            }
        } else {
            ewkt.wkt = candidate;
        }
        return ewkt;
    }

    @Override
    public String convertBackward(Geometry to, String ... params) throws ConversionException {
        if (to == null) {
            throw new IllegalArgumentException("'to' must not be null");
        }
        WKTWriter wktWriter = new WKTWriter();
        return wktWriter.write(to);
    }

    public String getFormatName() {
        return "GeomFromWktConverter";
    }

    public String getFormatDisplayName() {
        return NbBundle.getMessage(GeomFromWktConverter.class, (String)"GeomFromWktConverter.getFormatDisplayName().returnValue");
    }

    public String getFormatHtmlName() {
        return null;
    }

    public String getFormatDescription() {
        return NbBundle.getMessage(GeomFromWktConverter.class, (String)"GeomFromWktConverter.getFormatDescription().returnValue");
    }

    public String getFormatHtmlDescription() {
        return NbBundle.getMessage(GeomFromWktConverter.class, (String)"GeomFromWktConverter.getFormatHtmlDescription().returnValue");
    }

    public Object getFormatExample() {
        return NbBundle.getMessage(GeomFromWktConverter.class, (String)"GeomFromWktConverter.getFormatExample().returnValue");
    }

    private static final class EWKT {
        private transient int srid = -1;
        private transient String wkt = null;

        private EWKT() {
        }
    }
}

