/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import de.cismet.commons.cismap.io.converters.AbstractGeometryFromTextConverter;
import de.cismet.commons.converter.ConversionException;
import org.openide.util.NbBundle;

public final class PointFromTextConverter
extends AbstractGeometryFromTextConverter {
    @Override
    protected Geometry createGeometry(Coordinate[] coordinates, GeometryFactory geomFactory) throws ConversionException {
        if (coordinates.length < 1) {
            throw new ConversionException("cannot create point from empty coordinate array");
        }
        return geomFactory.createPoint(coordinates[0]);
    }

    public String getFormatName() {
        return "PointFromTextConverter";
    }

    public String getFormatDisplayName() {
        return NbBundle.getMessage(PointFromTextConverter.class, (String)"PointFromTextConverter.getFormatDisplayName().returnValue");
    }

    public String getFormatHtmlName() {
        return null;
    }

    @Override
    public String getFormatDescription() {
        String desc = NbBundle.getMessage(PointFromTextConverter.class, (String)"PointFromTextConverter.getFormatDescription().returnValue");
        String superDesc = super.getFormatDescription();
        return desc + "\n" + superDesc;
    }

    @Override
    public String getFormatHtmlDescription() {
        String desc = NbBundle.getMessage(PointFromTextConverter.class, (String)"PointFromTextConverter.getFormatHtmlDescription().returnValue").replaceAll("<[/]?html>", "");
        String superDesc = super.getFormatHtmlDescription().replaceAll("<[/]?html>", "");
        return "<html>" + desc + "<br/>" + superDesc + "</html>";
    }

    public Object getFormatExample() {
        return NbBundle.getMessage(PointFromTextConverter.class, (String)"PointFromTextConverter.getFormatExample().returnValue", (Object)Character.valueOf(this.getDecimalSeparator()));
    }

    @Override
    public int rate(String from, String ... params) {
        int superRating = super.rate(from, params);
        if (superRating == 0) {
            return 0;
        }
        String[] tokens = from.split(this.getTokenRegex());
        if (tokens.length < 2) {
            return 0;
        }
        if (tokens.length > 2) {
            return 50;
        }
        return 100;
    }
}

