/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import de.cismet.commons.cismap.io.converters.AbstractGeometryFromTextConverter;
import de.cismet.commons.cismap.io.converters.PointFromTextConverter;
import de.cismet.commons.converter.ConversionException;
import org.openide.util.NbBundle;

public final class PolygonFromTextConverter
extends AbstractGeometryFromTextConverter {
    @Override
    protected Geometry createGeometry(Coordinate[] coordinates, GeometryFactory geomFactory) throws ConversionException {
        Coordinate[] coords;
        if (coordinates.length < 3) {
            throw new ConversionException("too few coordinates for polygon: " + coordinates.length);
        }
        Coordinate lastCoord = coordinates[coordinates.length - 1];
        if (coordinates[0].equals((Object)lastCoord)) {
            coords = coordinates;
        } else {
            coords = new Coordinate[coordinates.length + 1];
            System.arraycopy(coordinates, 0, coords, 0, coordinates.length);
            coords[coordinates.length] = coordinates[0];
        }
        LinearRing ring = geomFactory.createLinearRing(coords);
        return geomFactory.createPolygon(ring, null);
    }

    public String getFormatName() {
        return "PolygonFromTextConverter";
    }

    public String getFormatDisplayName() {
        return NbBundle.getMessage(PolygonFromTextConverter.class, (String)"PolygonFromTextConverter.getFormatDisplayName().returnValue");
    }

    public String getFormatHtmlName() {
        return null;
    }

    @Override
    public String getFormatDescription() {
        String desc = NbBundle.getMessage(PointFromTextConverter.class, (String)"PolygonFromTextConverter.getFormatDescription().returnValue");
        String superDesc = super.getFormatDescription();
        return desc + "\n" + superDesc;
    }

    @Override
    public String getFormatHtmlDescription() {
        String desc = NbBundle.getMessage(PointFromTextConverter.class, (String)"PolygonFromTextConverter.getFormatHtmlDescription().returnValue").replaceAll("<[/]?html>", "");
        String superDesc = super.getFormatHtmlDescription().replaceAll("<[/]?html>", "");
        return "<html>" + desc + "<br/>" + superDesc + "</html>";
    }

    public Object getFormatExample() {
        return NbBundle.getMessage(PointFromTextConverter.class, (String)"PolygonFromTextConverter.getFormatExample().returnValue", (Object)Character.valueOf(this.getDecimalSeparator()));
    }

    @Override
    public int rate(String from, String ... params) {
        int superRating = super.rate(from, params);
        if (superRating == 0) {
            return 0;
        }
        String[] tokens = from.split(this.getTokenRegex());
        if (tokens.length < 6) {
            return 0;
        }
        if (tokens[0].equals(tokens[tokens.length - 2]) && tokens[1].equals(tokens[tokens.length - 1])) {
            return 100;
        }
        return 80;
    }
}

