/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import de.cismet.commons.cismap.io.converters.AbstractGeometryFromTextConverter;
import de.cismet.commons.cismap.io.converters.PointFromTextConverter;
import de.cismet.commons.converter.ConversionException;
import de.cismet.commons.converter.Converter;
import org.openide.util.NbBundle;

public final class PolylineFromTextConverter
extends AbstractGeometryFromTextConverter
implements Converter.MatchRating<String> {
    @Override
    protected Geometry createGeometry(Coordinate[] coordinates, GeometryFactory geomFactory) throws ConversionException {
        if (coordinates.length < 2) {
            throw new ConversionException("cannot create linestring lnfrom empty coordinate array");
        }
        return geomFactory.createLineString(coordinates);
    }

    public String getFormatName() {
        return "PolylineFromTextConverter";
    }

    public String getFormatDisplayName() {
        return NbBundle.getMessage(PolylineFromTextConverter.class, (String)"PolylineFromTextConverter.getFormatDisplayName().returnValue");
    }

    public String getFormatHtmlName() {
        return null;
    }

    @Override
    public String getFormatDescription() {
        String desc = NbBundle.getMessage(PointFromTextConverter.class, (String)"PolylineFromTextConverter.getFormatDescription().returnValue");
        String superDesc = super.getFormatDescription();
        return desc + "\n" + superDesc;
    }

    @Override
    public String getFormatHtmlDescription() {
        String desc = NbBundle.getMessage(PointFromTextConverter.class, (String)"PolylineFromTextConverter.getFormatHtmlDescription().returnValue").replaceAll("<[/]?html>", "");
        String superDesc = super.getFormatHtmlDescription().replaceAll("<[/]?html>", "");
        return "<html>" + desc + "<br/>" + superDesc + "</html>";
    }

    public Object getFormatExample() {
        return NbBundle.getMessage(PointFromTextConverter.class, (String)"PolylineFromTextConverter.getFormatExample().returnValue", (Object)Character.valueOf(this.getDecimalSeparator()));
    }

    @Override
    public int rate(String from, String ... params) {
        int superRating = super.rate(from, params);
        if (superRating == 0) {
            return 0;
        }
        String[] tokens = from.split(this.getTokenRegex());
        if (tokens.length < 6) {
            return 0;
        }
        if (tokens[0].equals(tokens[tokens.length - 2]) && tokens[1].equals(tokens[tokens.length - 1])) {
            return 80;
        }
        return 100;
    }
}

