/*
 * Decompiled with CFR 0.152.
 */
package de.preagro.jts2gmldom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Jts2GmlDOM {
    protected static final Logger LOGGER = Logger.getLogger("de.preagro.jts2gmldom");
    private static final String EMPTY_STRING = "";
    public static final String EIGHT_DP_NUMBER_FORMAT = "0.########";
    public static final String GML_NAMESPACE = "http://www.opengis.net/gml";
    public static final String GML_PREFIX = "gml";
    public static final String PREFIX_SEPARATOR = ":";
    public static final String DEFAULT_LIST_SEPARATOR = " ";
    public static final String DEFAULT_TUPLE_SEPARATOR = ",";
    public static final String POINT = "Point";
    public static final String POS = "pos";
    public static final String LINESTRING = "LineString";
    public static final String LINEARRING = "LinearRing";
    public static final String POSLIST = "posList";
    public static final String POLYGON = "Polygon";
    public static final String EXTERIOR = "exterior";
    public static final String INTERIOR = "interior";
    public static final String MULTIGEOMETRY = "MultiGeometry";
    public static final String GEOMETRYMEMBER = "geometryMember";
    public static final String MULTICURVE = "MultiCurve";
    public static final String CURVEMEMBER = "curveMember";
    public static final String MULTIPOINT = "MultiPoint";
    public static final String POINTMEMBER = "pointMember";
    public static final String MULTISURFACE = "MultiSurface";
    public static final String SURFACEMEMBER = "surfaceMember";
    private Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

    public Element geometryToGmlElement(Geometry theGeom) throws DOMException {
        int geomType = GeomTypes.classifyGeometry(theGeom);
        switch (geomType) {
            case 10: {
                return this.pointToGmlElement((Point)theGeom);
            }
            case 20: {
                return this.lineStringToGmlElement((LineString)theGeom);
            }
            case 21: {
                return this.linearRingToGmlElement((LinearRing)theGeom);
            }
            case 30: {
                return this.polygonToGmlElement((Polygon)theGeom);
            }
            case 40: {
                return this.geometryCollectionToGmlElement((GeometryCollection)theGeom);
            }
            case 41: {
                return this.multiPointToGmlElement((MultiPoint)theGeom);
            }
            case 42: {
                return this.multiLineStringToGmlElement((MultiLineString)theGeom);
            }
            case 43: {
                return this.multiPolygonToGmlElement((MultiPolygon)theGeom);
            }
        }
        return null;
    }

    public static String gmlQualifiedTag(String localName) {
        return GML_PREFIX.concat(PREFIX_SEPARATOR).concat(localName);
    }

    protected Element createElement(String elementName) throws DOMException {
        return this.doc.createElementNS(GML_NAMESPACE, Jts2GmlDOM.gmlQualifiedTag(elementName));
    }

    protected void addTextToElement(Element el, String text) throws DOMException {
        Text n = this.doc.createTextNode(text);
        el.appendChild(n);
    }

    protected String getFormattedCoord(Coordinate thePoint) {
        return this.getFormattedCoord(thePoint, DEFAULT_LIST_SEPARATOR);
    }

    protected String getFormattedCoord(Coordinate theCoord, String separator) {
        DecimalFormat formatter = new DecimalFormat(EIGHT_DP_NUMBER_FORMAT, new DecimalFormatSymbols(Locale.ENGLISH));
        return formatter.format(theCoord.x) + separator + formatter.format(theCoord.y) + (Double.isNaN(theCoord.z) ? EMPTY_STRING : separator + formatter.format(theCoord.z));
    }

    protected String getFormattedCoordList(Coordinate[] theCoords) {
        return this.getFormattedCoordList(theCoords, DEFAULT_TUPLE_SEPARATOR, DEFAULT_LIST_SEPARATOR);
    }

    protected String getFormattedCoordList(Coordinate[] theCoords, String tupleSeparator) {
        return this.getFormattedCoordList(theCoords, tupleSeparator, DEFAULT_LIST_SEPARATOR);
    }

    protected String getFormattedCoordList(Coordinate[] theCoords, String tupleSeparator, String listSeparator) {
        String coordList = EMPTY_STRING;
        for (int i = 0; i < theCoords.length; ++i) {
            coordList = coordList + (i > 0 ? listSeparator : EMPTY_STRING) + this.getFormattedCoord(theCoords[i], tupleSeparator);
        }
        return coordList;
    }

    public Element pointToGmlElement(Point thePoint) throws DOMException {
        Element pointElement = this.createElement(POINT);
        Element posElement = this.createElement(POS);
        this.addTextToElement(posElement, this.getFormattedCoord(thePoint.getCoordinate()));
        pointElement.appendChild(posElement);
        return pointElement;
    }

    public Element lineStringToGmlElement(LineString theLineString) throws DOMException {
        return this.linearThingToGmlElement(theLineString, LINESTRING);
    }

    public Element linearRingToGmlElement(LinearRing theLinearRing) throws DOMException {
        return this.linearThingToGmlElement((LineString)theLinearRing, LINEARRING);
    }

    protected Element linearThingToGmlElement(LineString theLinearThing, String elementName) throws DOMException {
        Element lineStringElement = this.createElement(elementName);
        Element posListElement = this.createElement(POSLIST);
        this.addTextToElement(posListElement, this.getFormattedCoordList(theLinearThing.getCoordinates()));
        lineStringElement.appendChild(posListElement);
        return lineStringElement;
    }

    public Element polygonToGmlElement(Polygon thePolygon) throws DOMException {
        Element polygonElement = this.createElement(POLYGON);
        polygonElement.appendChild(this.createMemberElement((Geometry)thePolygon.getExteriorRing(), EXTERIOR));
        int numInteriors = thePolygon.getNumInteriorRing();
        for (int i = 0; i < numInteriors; ++i) {
            polygonElement.appendChild(this.createMemberElement((Geometry)thePolygon.getInteriorRingN(i), INTERIOR));
        }
        return polygonElement;
    }

    public Element geometryCollectionToGmlElement(GeometryCollection theGeoms) throws DOMException {
        return this.collectionToGmlElement(theGeoms, MULTIGEOMETRY, GEOMETRYMEMBER);
    }

    public Element multiPointToGmlElement(MultiPoint theGeoms) throws DOMException {
        return this.collectionToGmlElement((GeometryCollection)theGeoms, MULTIPOINT, POINTMEMBER);
    }

    public Element multiLineStringToGmlElement(MultiLineString theGeoms) throws DOMException {
        return this.collectionToGmlElement((GeometryCollection)theGeoms, MULTICURVE, CURVEMEMBER);
    }

    public Element multiPolygonToGmlElement(MultiPolygon theGeoms) throws DOMException {
        return this.collectionToGmlElement((GeometryCollection)theGeoms, MULTISURFACE, SURFACEMEMBER);
    }

    protected Element collectionToGmlElement(GeometryCollection theGeoms, String elementName, String associationName) throws DOMException {
        Element collectionElement = this.createElement(elementName);
        int numGeoms = theGeoms.getNumGeometries();
        for (int i = 0; i < numGeoms; ++i) {
            collectionElement.appendChild(this.createMemberElement(theGeoms.getGeometryN(i), associationName));
        }
        return collectionElement;
    }

    protected Element createMemberElement(Geometry theGeom, String associationName) {
        Element geometryElement = this.geometryToGmlElement(theGeom);
        Element associationElement = this.createElement(associationName);
        associationElement.appendChild(geometryElement);
        return associationElement;
    }

    private static class GeomTypes {
        public static final int UNKNOWN = 0;
        public static final String POINT_NAME = "Point";
        public static final int POINT = 10;
        public static final String LINESTRING_NAME = "LineString";
        public static final int LINESTRING = 20;
        public static final String LINEARRING_NAME = "LinearRing";
        public static final int LINEARRING = 21;
        public static final String POLYGON_NAME = "Polygon";
        public static final int POLYGON = 30;
        public static final String GEOMETRYCOLLECTION_NAME = "GeometryCollection";
        public static final int GEOMETRYCOLLECTION = 40;
        public static final String MULTIPOINT_NAME = "MultiPoint";
        public static final int MULTIPOINT = 41;
        public static final String MULTILINESTRING_NAME = "MultiLineString";
        public static final int MULTILINESTRING = 42;
        public static final String MULTIPOLYGON_NAME = "MultiPolygon";
        public static final int MULTIPOLYGON = 43;

        private GeomTypes() {
        }

        public static int classifyGeometry(Geometry theGeom) {
            String geomType = theGeom.getGeometryType();
            if (geomType.equals("Point")) {
                return 10;
            }
            if (geomType.equals("LineString")) {
                return 20;
            }
            if (geomType.equals("LinearRing")) {
                return 21;
            }
            if (geomType.equals("Polygon")) {
                return 30;
            }
            if (geomType.equals(GEOMETRYCOLLECTION_NAME)) {
                return 40;
            }
            if (geomType.equals("MultiPoint")) {
                return 41;
            }
            if (geomType.equals(MULTILINESTRING_NAME)) {
                return 42;
            }
            if (geomType.equals(MULTIPOLYGON_NAME)) {
                return 43;
            }
            return 0;
        }
    }
}

