/*
 * Decompiled with CFR 0.152.
 */
package pswing;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.io.Serializable;
import pswing.PSwingMouseMotionEvent;

public class PSwingMouseEvent
extends MouseEvent
implements Serializable {
    private int id;
    private PInputEvent event;

    protected PSwingMouseEvent(int id, MouseEvent e, PInputEvent event) {
        super((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        this.id = id;
        this.event = event;
    }

    public static PSwingMouseEvent createMouseEvent(int id, MouseEvent e, PInputEvent pEvent) {
        if (id == 503 || id == 506) {
            return new PSwingMouseMotionEvent(id, e, pEvent);
        }
        return new PSwingMouseEvent(id, e, pEvent);
    }

    public Point2D getLocalPoint() {
        Point2D.Double point = new Point2D.Double();
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    public double getLocalX() {
        Point2D point = this.getLocalPoint();
        return point.getX();
    }

    public double getLocalY() {
        Point2D point = this.getLocalPoint();
        return point.getY();
    }

    @Override
    public int getID() {
        return this.id;
    }

    public PNode getNode() {
        return this.event.getPickedNode();
    }

    public PPickPath getPath() {
        return this.event.getPath();
    }

    public PNode getGrabNode() {
        return this.event.getPickedNode();
    }

    public PPickPath getGrabPath() {
        return this.getPath();
    }

    public PNode getCurrentNode() {
        return this.event.getPickedNode();
    }

    public PPickPath getCurrentPath() {
        return this.getPath();
    }

    public void dispatchTo(Object listener) {
        if (listener instanceof MouseListener) {
            MouseListener mouseListener = (MouseListener)listener;
            switch (this.getID()) {
                case 500: {
                    mouseListener.mouseClicked(this);
                    break;
                }
                case 504: {
                    mouseListener.mouseEntered(this);
                    break;
                }
                case 505: {
                    mouseListener.mouseExited(this);
                    break;
                }
                case 501: {
                    mouseListener.mousePressed(this);
                    break;
                }
                case 502: {
                    mouseListener.mouseReleased(this);
                    break;
                }
                default: {
                    throw new RuntimeException("ZMouseEvent with bad ID");
                }
            }
        } else {
            MouseMotionListener mouseMotionListener = (MouseMotionListener)listener;
            switch (this.getID()) {
                case 506: {
                    mouseMotionListener.mouseDragged(this);
                    break;
                }
                case 503: {
                    mouseMotionListener.mouseMoved(this);
                    break;
                }
                default: {
                    throw new RuntimeException("ZMouseMotionEvent with bad ID");
                }
            }
        }
    }

    @Override
    public void setSource(Object aSource) {
        this.source = aSource;
    }
}

