/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * TestHistoryButton.java
 *
 * Created on 14. Juli 2005, 10:02
 */
package de.cismet.tools.gui.historybutton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.UIManager;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten.hell@cismet.de
 * @version  $Revision$, $Date$
 */
public class TestHistoryButton extends javax.swing.JFrame {

    //~ Instance fields --------------------------------------------------------

    DefaultHistoryModel historyModel = new DefaultHistoryModel();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem aboutMenuItem;
    private javax.swing.JButton cmdGo;
    private javax.swing.JMenuItem contentsMenuItem;
    private javax.swing.JMenuItem copyMenuItem;
    private javax.swing.JMenuItem cutMenuItem;
    private javax.swing.JMenuItem deleteMenuItem;
    private javax.swing.JMenu editMenu;
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JMenu helpMenu;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem jMenuItem3;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenuItem openMenuItem;
    private javax.swing.JMenuItem pasteMenuItem;
    private javax.swing.JPopupMenu popupMenu;
    private javax.swing.JMenuItem saveAsMenuItem;
    private javax.swing.JMenuItem saveMenuItem;
    private javax.swing.JToolBar toolBar;
    private javax.swing.JTextField txtUrl;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form TestHistoryButton.
     */
    public TestHistoryButton() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
        }
        initComponents();
        final JHistoryButton hbBack = JHistoryButton.getDefaultJHistoryButton(
                JHistoryButton.DIRECTION_BACKWARD,
                JHistoryButton.ICON_SIZE_16,
                historyModel);
        // hbBack.setRolloverIcon(new
        // javax.swing.ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/historybutton/res/forward16.png")));
        final JHistoryButton hbForward = JHistoryButton.getDefaultJHistoryButton(
                JHistoryButton.DIRECTION_FORWARD,
                JHistoryButton.ICON_SIZE_16,
                historyModel);
        toolBar.add(hbBack, 0);
        toolBar.add(hbForward, 1);
        historyModel.addHistoryModelListener(new HistoryModelListener() {

                @Override
                public void historyChanged() {
                    txtUrl.setText(historyModel.getCurrentElement().toString());
                }

                @Override
                public void forwardStatusChanged() {
                }

                @Override
                public void backStatusChanged() {
                }
                @Override
                public void historyActionPerformed() {
                }
            });
        historyModel.addToHistory("http://www.google.de/"); // NOI18N
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        popupMenu = new javax.swing.JPopupMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuItem2 = new javax.swing.JMenuItem();
        jMenuItem3 = new javax.swing.JMenuItem();
        jButton1 = new javax.swing.JButton();
        toolBar = new javax.swing.JToolBar();
        jLabel1 = new javax.swing.JLabel();
        txtUrl = new javax.swing.JTextField();
        cmdGo = new javax.swing.JButton();
        menuBar = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        openMenuItem = new javax.swing.JMenuItem();
        saveMenuItem = new javax.swing.JMenuItem();
        saveAsMenuItem = new javax.swing.JMenuItem();
        exitMenuItem = new javax.swing.JMenuItem();
        editMenu = new javax.swing.JMenu();
        cutMenuItem = new javax.swing.JMenuItem();
        copyMenuItem = new javax.swing.JMenuItem();
        pasteMenuItem = new javax.swing.JMenuItem();
        deleteMenuItem = new javax.swing.JMenuItem();
        helpMenu = new javax.swing.JMenu();
        contentsMenuItem = new javax.swing.JMenuItem();
        aboutMenuItem = new javax.swing.JMenuItem();

        jMenuItem1.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.jMenuItem1.text")); // NOI18N
        popupMenu.add(jMenuItem1);

        jMenuItem2.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.jMenuItem2.text")); // NOI18N
        popupMenu.add(jMenuItem2);

        jMenuItem3.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.jMenuItem3.text")); // NOI18N
        popupMenu.add(jMenuItem3);

        jButton1.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.jButton1.text")); // NOI18N

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jLabel1.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.jLabel1.text")); // NOI18N
        toolBar.add(jLabel1);

        txtUrl.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    txtUrlActionPerformed(evt);
                }
            });
        toolBar.add(txtUrl);

        cmdGo.setText(org.openide.util.NbBundle.getMessage(TestHistoryButton.class, "TestHistoryButton.cmdGo.text")); // NOI18N
        cmdGo.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cmdGoActionPerformed(evt);
                }
            });
        toolBar.add(cmdGo);

        getContentPane().add(toolBar, java.awt.BorderLayout.NORTH);

        fileMenu.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.fileMenu.text")); // NOI18N

        openMenuItem.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.openMenuItem.text")); // NOI18N
        fileMenu.add(openMenuItem);

        saveMenuItem.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.saveMenuItem.text")); // NOI18N
        fileMenu.add(saveMenuItem);

        saveAsMenuItem.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.saveAsMenuItem.text")); // NOI18N
        fileMenu.add(saveAsMenuItem);

        exitMenuItem.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.exitMenuItem.text")); // NOI18N
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    exitMenuItemActionPerformed(evt);
                }
            });
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        editMenu.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.editMenu.text")); // NOI18N

        cutMenuItem.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.cutMenuItem.text")); // NOI18N
        editMenu.add(cutMenuItem);

        copyMenuItem.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.copyMenuItem.text")); // NOI18N
        editMenu.add(copyMenuItem);

        pasteMenuItem.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.pasteMenuItem.text")); // NOI18N
        editMenu.add(pasteMenuItem);

        deleteMenuItem.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.deleteMenuItem.text")); // NOI18N
        editMenu.add(deleteMenuItem);

        menuBar.add(editMenu);

        helpMenu.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.helpMenu.text")); // NOI18N

        contentsMenuItem.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.contentsMenuItem.text")); // NOI18N
        helpMenu.add(contentsMenuItem);

        aboutMenuItem.setText(org.openide.util.NbBundle.getMessage(
                TestHistoryButton.class,
                "TestHistoryButton.aboutMenuItem.text")); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        setJMenuBar(menuBar);

        final java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width - 352) / 2, (screenSize.height - 287) / 2, 352, 287);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void txtUrlActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_txtUrlActionPerformed
        historyModel.addToHistory(txtUrl.getText());
    }                                                                          //GEN-LAST:event_txtUrlActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cmdGoActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cmdGoActionPerformed
// TODO add your handling code here:
    } //GEN-LAST:event_cmdGoActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void exitMenuItemActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_exitMenuItemActionPerformed
        System.exit(0);
    }                                                                                //GEN-LAST:event_exitMenuItemActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  args  the command line arguments
     */
    public static void main(final String[] args) {
        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    new TestHistoryButton().setVisible(true);
                }
            });
    }
}
