/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.tools.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

/**
 * DOCUMENT ME!
 *
 * @author   daniel
 * @version  $Revision$, $Date$
 */
public class LayeredAlertPanel extends javax.swing.JPanel {

    //~ Instance fields --------------------------------------------------------

    private int offset = 5;
    private int topOffset = 5;
    private JPanel contentPanel;
    private JPanel alert;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLayeredPane layeredPane;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form LayeredAlertPanel.
     */
    public LayeredAlertPanel() {
        this(new JPanel(), new JPanel());
    }

    /**
     * Creates a new LayeredAlertPanel object.
     *
     * @param  component  DOCUMENT ME!
     * @param  alert      DOCUMENT ME!
     */
    public LayeredAlertPanel(final JPanel component, final JPanel alert) {
        this(component, alert, 5);
    }

    /**
     * Creates a new LayeredAlertPanel object.
     *
     * @param  component  DOCUMENT ME!
     * @param  alert      DOCUMENT ME!
     * @param  offset     DOCUMENT ME!
     */
    public LayeredAlertPanel(final JPanel component, final JPanel alert, final int offset) {
        initComponents();
        this.offset = offset;
        this.contentPanel = component;
        this.alert = alert;
        this.layeredPane.setLayout(new LayeredAlertLayoutManager());
        if ((contentPanel != null) && (alert != null)) {
            layeredPane.add(contentPanel, JLayeredPane.DEFAULT_LAYER);
            layeredPane.add(alert, JLayeredPane.POPUP_LAYER);
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  offset  DOCUMENT ME!
     */
    public void setOffset(final int offset) {
        this.offset = offset;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  topOffset  DOCUMENT ME!
     */
    public void setTopOffset(final int topOffset) {
        this.topOffset = topOffset;
    }
    /**
     * DOCUMENT ME!
     *
     * @param  args  DOCUMENT ME!
     */
    public static void main(final String[] args) {
        final JFrame f = new JFrame();
        f.setSize(500, 500);
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        final JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.setBackground(Color.WHITE);
        contentPanel.setOpaque(true);
        contentPanel.add(new JLabel("Content panel"), BorderLayout.CENTER);

        final AlertPanel alert = new AlertPanel(
                AlertPanel.TYPE.DANGER,
                new JLabel(
                    "Warnung! Es wurde kein Dokument gefunden. Klicken Sie auf diese Meldung um eine Weiterleitung einzurichten."),
                true);
        alert.setPreferredSize(new Dimension(100, 50));
        alert.setMinimumSize(new Dimension(100, 50));
        alert.setMaximumSize(new Dimension(100, 50));
        final JPanel p = new LayeredAlertPanel(contentPanel, alert);
        f.getContentPane().add(p);
        f.setVisible(true);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        layeredPane = new javax.swing.JLayeredPane();

        setLayout(new java.awt.BorderLayout());

        final javax.swing.GroupLayout layeredPaneLayout = new javax.swing.GroupLayout(layeredPane);
        layeredPane.setLayout(layeredPaneLayout);
        layeredPaneLayout.setHorizontalGroup(
            layeredPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                400,
                Short.MAX_VALUE));
        layeredPaneLayout.setVerticalGroup(
            layeredPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                300,
                Short.MAX_VALUE));

        add(layeredPane, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private final class LayeredAlertLayoutManager implements LayoutManager {

        //~ Methods ------------------------------------------------------------

        @Override
        public void addLayoutComponent(final String name, final Component comp) {
        }

        @Override
        public void removeLayoutComponent(final Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(final Container parent) {
            return new Dimension(100, 100);
        }

        @Override
        public Dimension minimumLayoutSize(final Container parent) {
            return new Dimension(100, 100);
        }

        @Override
        public void layoutContainer(final Container parent) {
            contentPanel.setBounds(0, 0, parent.getWidth(), parent.getHeight());
            alert.setBounds(2, 0, parent.getWidth() - 4, alert.getPreferredSize().height);
//            alert.setBounds(offset, topOffset, parent.getWidth() - (2 * offset), alert.getPreferredSize().height);
        }
    }
}
