/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.equalizer;

import de.cismet.commons.gui.equalizer.AbstractEqualizerModel;
import de.cismet.commons.gui.equalizer.EqualizerCategory;
import de.cismet.commons.gui.equalizer.EqualizerModelEvent;
import de.cismet.commons.gui.equalizer.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DefaultEqualizerModel
extends AbstractEqualizerModel {
    public static final Range DEFAULT_RANGE = new Range(0, 100);
    protected final List<EqualizerCategory> equalizerCategories;
    private final Range range;

    public DefaultEqualizerModel(Collection<EqualizerCategory> equalizerCategories) {
        this(equalizerCategories, DEFAULT_RANGE);
    }

    public DefaultEqualizerModel(Collection<EqualizerCategory> equalizerCategories, Range range) {
        if (equalizerCategories == null || equalizerCategories.isEmpty()) {
            throw new IllegalArgumentException("equalizerCategories must not be null or empty");
        }
        if (range == null) {
            throw new IllegalArgumentException("range must not be null");
        }
        this.checkDuplicateCategoryNames(equalizerCategories);
        this.range = range;
        for (EqualizerCategory cat : equalizerCategories) {
            this.checkValueWithinRange(cat.getValue());
        }
        this.equalizerCategories = this.cloneCategories(equalizerCategories);
    }

    public void checkValueWithinRange(int value) {
        if (this.range.getMin() > value || this.range.getMax() < value) {
            throw new IllegalArgumentException("value is not within range: [value=" + value + "|range=" + this.range + "]");
        }
    }

    private void checkDuplicateCategoryNames(Collection<EqualizerCategory> categories) {
        HashSet<String> names = new HashSet<String>(categories.size(), 1.0f);
        Iterator<EqualizerCategory> it = categories.iterator();
        while (it.hasNext()) {
            String name = it.next().getName();
            if (names.add(name)) continue;
            throw new IllegalArgumentException("duplicate category name: " + name);
        }
    }

    private List<EqualizerCategory> cloneCategories(Collection<EqualizerCategory> categories) {
        ArrayList<EqualizerCategory> clone = new ArrayList<EqualizerCategory>(categories.size());
        Iterator<EqualizerCategory> it = categories.iterator();
        while (it.hasNext()) {
            clone.add((EqualizerCategory)it.next().clone());
        }
        return clone;
    }

    public List<EqualizerCategory> getEqualizerCategories() {
        return this.cloneCategories(this.equalizerCategories);
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public String getEqualizerCategory(int index) {
        return this.equalizerCategories.get(index).getName();
    }

    @Override
    public int getEqualizerCategoryCount() {
        return this.equalizerCategories.size();
    }

    @Override
    public int getValueAt(int index) {
        return this.equalizerCategories.get(index).getValue();
    }

    @Override
    public void setValueAt(int index, int value) {
        EqualizerCategory cat = this.equalizerCategories.get(index);
        this.checkValueWithinRange(value);
        int oldValue = cat.getValue();
        if (oldValue != value) {
            cat.setValue(value);
            this.fireEqualizerModelEvent(new EqualizerModelEvent(this, index, oldValue, value));
        }
    }
}

