/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.equalizer;

import de.cismet.commons.gui.equalizer.DefaultEqualizerModel;
import de.cismet.commons.gui.equalizer.EqualizerCategory;
import de.cismet.commons.gui.equalizer.EqualizerModelEvent;
import de.cismet.commons.gui.equalizer.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class RubberBandEqualizerModel
extends DefaultEqualizerModel {
    public RubberBandEqualizerModel(Collection<EqualizerCategory> equalizerCategories) {
        super(equalizerCategories, new Range(0, 100));
        int sum = 0;
        for (EqualizerCategory cat : this.equalizerCategories) {
            sum += cat.getValue();
        }
        if (sum == 0) {
            int initial = 100 / this.equalizerCategories.size();
            int delta = 100 % this.equalizerCategories.size();
            Iterator it = this.equalizerCategories.iterator();
            while (it.hasNext()) {
                EqualizerCategory cat = (EqualizerCategory)it.next();
                if (delta == 0 || it.hasNext()) {
                    cat.setValue(initial);
                    continue;
                }
                cat.setValue(initial + delta);
            }
        } else if (sum != 100) {
            throw new IllegalArgumentException("equalizer categories do not sum up to 100: " + sum);
        }
    }

    @Override
    public void setValueAt(int index, int value) {
        this.checkValueWithinRange(value);
        if (this.getValueAt(index) == value) {
            return;
        }
        int[] newVals = this.calculateValues(index, value);
        for (int i = 0; i < this.getEqualizerCategoryCount(); ++i) {
            ((EqualizerCategory)this.equalizerCategories.get(i)).setValue(newVals[i]);
        }
        this.fireEqualizerModelEvent(new EqualizerModelEvent(this));
    }

    private int[] calculateValues(int index, int value) {
        int i;
        ListIterator<Integer> li;
        if (value == 100) {
            int[] values = new int[this.getEqualizerCategoryCount()];
            for (int i2 = 0; i2 < values.length; ++i2) {
                values[i2] = 0;
            }
            values[index] = 100;
            return values;
        }
        int delta = this.getValueAt(index) - value;
        int[] values = new int[this.getEqualizerCategoryCount()];
        ArrayList<Integer> goodIndexes = new ArrayList<Integer>(this.getEqualizerCategoryCount());
        for (int i3 = 0; i3 < this.getEqualizerCategoryCount(); ++i3) {
            values[i3] = this.getValueAt(i3);
            goodIndexes.add(i3);
        }
        values[index] = value;
        this.removeIndex(goodIndexes, index);
        if (delta > 0 && values[index] + delta != 100) {
            ListIterator<Integer> li2 = goodIndexes.listIterator();
            while (li2.hasNext()) {
                if (values[li2.next()] != 0) continue;
                li2.remove();
            }
        }
        int valueDelta = delta / goodIndexes.size();
        int carryOver = delta % goodIndexes.size();
        while (valueDelta != 0) {
            li = goodIndexes.listIterator();
            while (li.hasNext()) {
                int n = i = li.next().intValue();
                values[n] = values[n] + valueDelta;
                if (values[i] > 0) continue;
                li.remove();
                carryOver += values[i];
                values[i] = 0;
            }
            valueDelta = carryOver / goodIndexes.size();
            carryOver %= goodIndexes.size();
        }
        li = goodIndexes.listIterator();
        while (carryOver != 0) {
            i = li.next();
            if (carryOver > 0) {
                int n = i;
                values[n] = values[n] + 1;
                --carryOver;
                continue;
            }
            if (carryOver >= 0 || values[i] == 0) continue;
            int n = i;
            values[n] = values[n] - 1;
            ++carryOver;
        }
        return values;
    }

    private void removeIndex(List<Integer> list, int toRemove) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != toRemove) continue;
            list.remove(i);
            return;
        }
    }
}

