/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.progress;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.icon.PainterIcon;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.painter.Painter;

public class BusyLoggingTextPane
extends JTextPane {
    private static final Logger LOG = Logger.getLogger(BusyLoggingTextPane.class);
    private PainterIcon icon;
    private BusyPainter busyPainter;
    private Timer busy;
    private boolean showWaitAnimation = false;
    private final int busyWidth;
    private final int busyHeight;
    private Style styleTip;
    private Style styleSuccess;
    private Style styleInfo;
    private Style styleExpert;
    private Style styleWarn;
    private Style styleError;
    private Style styleErrorReason;
    private HashMap<Styles, Style> styles = new HashMap();

    public BusyLoggingTextPane() {
        this(20, 20);
    }

    public BusyLoggingTextPane(int height, int width) {
        this.initComponents();
        this.busyWidth = width;
        this.busyHeight = height;
        this.busyPainter = new BusyPainter(height);
        this.icon = new PainterIcon(new Dimension(this.busyWidth, this.busyHeight));
        this.icon.setPainter((Painter)this.busyPainter);
        this.styleTip = this.addStyle(Styles.TIP.toString(), null);
        StyleConstants.setForeground(this.styleTip, Color.blue);
        StyleConstants.setFontSize(this.styleTip, 10);
        this.styles.put(Styles.TIP, this.styleTip);
        this.styleSuccess = this.addStyle(Styles.SUCCESS.toString(), null);
        StyleConstants.setForeground(this.styleSuccess, Color.green.darker());
        StyleConstants.setFontSize(this.styleSuccess, 10);
        this.styles.put(Styles.SUCCESS, this.styleSuccess);
        this.styleInfo = this.addStyle(Styles.INFO.toString(), null);
        StyleConstants.setForeground(this.styleInfo, Color.DARK_GRAY);
        StyleConstants.setFontSize(this.styleInfo, 10);
        this.styles.put(Styles.INFO, this.styleInfo);
        this.styleExpert = this.addStyle(Styles.EXPERT.toString(), null);
        StyleConstants.setForeground(this.styleExpert, Color.gray);
        StyleConstants.setFontSize(this.styleExpert, 10);
        this.styles.put(Styles.EXPERT, this.styleExpert);
        this.styleWarn = this.addStyle(Styles.WARN.toString(), null);
        StyleConstants.setForeground(this.styleWarn, Color.orange.darker());
        StyleConstants.setFontSize(this.styleWarn, 10);
        this.styles.put(Styles.WARN, this.styleWarn);
        this.styleError = this.addStyle(Styles.ERROR.toString(), null);
        StyleConstants.setForeground(this.styleError, Color.red);
        StyleConstants.setFontSize(this.styleError, 10);
        StyleConstants.setBold(this.styleError, true);
        this.styles.put(Styles.ERROR, this.styleError);
        this.styleErrorReason = this.addStyle(Styles.ERROR_REASON.toString(), null);
        StyleConstants.setForeground(this.styleErrorReason, Color.red);
        StyleConstants.setFontSize(this.styleErrorReason, 10);
        this.styles.put(Styles.ERROR_REASON, this.styleErrorReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(final String msg, final Styles reason) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BusyLoggingTextPane.this.addMessage(msg, reason);
                }
            });
        } else {
            BusyLoggingTextPane busyLoggingTextPane = this;
            synchronized (busyLoggingTextPane) {
                try {
                    this.getStyledDocument().insertString(this.getStyledDocument().getLength(), msg + "\n", this.styles.get((Object)reason));
                }
                catch (BadLocationException ble) {
                    LOG.error((Object)"error during Insert", (Throwable)ble);
                }
            }
        }
    }

    private void stopWaitAnimation() {
        if (this.busy != null) {
            this.showWaitAnimation = false;
            this.busy.stop();
            this.busyPainter.setFrame(-1);
            this.repaint();
            this.busy = null;
        }
    }

    private void startWaitAnimation() {
        this.busy = new Timer(100, new ActionListener(){
            int frame;
            {
                this.frame = BusyLoggingTextPane.this.busyPainter.getPoints();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.frame = (this.frame + 1) % BusyLoggingTextPane.this.busyPainter.getPoints();
                BusyLoggingTextPane.this.busyPainter.setFrame(this.frame);
                BusyLoggingTextPane.this.repaint();
            }
        });
        this.showWaitAnimation = true;
        this.busy.start();
    }

    public void setBusy(boolean flag) {
        if (flag && !this.showWaitAnimation) {
            this.startWaitAnimation();
        } else if (!flag && this.showWaitAnimation) {
            this.stopWaitAnimation();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
        if (this.showWaitAnimation) {
            this.icon.paintIcon((Component)this, (Graphics)g2, this.getWidth() / 2 - this.busyWidth / 2, this.getHeight() / 2 - this.busyHeight / 2);
        }
        g2.dispose();
    }

    private void initComponents() {
    }

    public static enum Styles {
        TIP,
        INFO,
        SUCCESS,
        EXPERT,
        WARN,
        ERROR,
        ERROR_REASON;

    }
}

