/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.protocol;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.cismet.commons.gui.protocol.ProtocolStep;
import de.cismet.commons.gui.protocol.ProtocolStepConfiguration;
import de.cismet.commons.gui.protocol.ProtocolStepToolbarItem;
import de.cismet.commons.gui.protocol.listener.ProtocolHandlerListener;
import de.cismet.commons.gui.protocol.listener.ProtocolHandlerListenerEvent;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.Lookup;

public class ProtocolHandler
implements Configurable {
    private static final transient Logger LOG = Logger.getLogger(ProtocolHandler.class);
    private static ProtocolHandler INSTANCE;
    private final LinkedList<ProtocolStep> storage = new LinkedList();
    private final ProtocolHandlerListenerHandler listenerHandler = new ProtocolHandlerListenerHandler();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, ProtocolStepConfiguration> configMap = new HashMap<String, ProtocolStepConfiguration>();
    private final List<ProtocolStepToolbarItem> toolbarItems = new ArrayList<ProtocolStepToolbarItem>();
    private boolean recordEnabled = false;

    private ProtocolHandler() {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        Collection configs = Lookup.getDefault().lookupAll(ProtocolStepConfiguration.class);
        for (ProtocolStepConfiguration config : configs) {
            String configKey = config.getProtocolStepKey();
            if (configKey == null) continue;
            this.configMap.put(configKey, config);
        }
        Collection toolbarItems = Lookup.getDefault().lookupAll(ProtocolStepToolbarItem.class);
        for (ProtocolStepToolbarItem toolbarItem : toolbarItems) {
            if (!toolbarItem.isVisible()) continue;
            this.toolbarItems.add(toolbarItem);
        }
        Collections.sort(this.toolbarItems, new Comparator<ProtocolStepToolbarItem>(){

            @Override
            public int compare(ProtocolStepToolbarItem o1, ProtocolStepToolbarItem o2) {
                return o1.getSorterString().compareTo(o2.getSorterString());
            }
        });
    }

    public static ProtocolHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProtocolHandler();
        }
        return INSTANCE;
    }

    public boolean addProtocolHandlerListener(ProtocolHandlerListener listener) {
        return this.listenerHandler.addProtocolHandlerListener(listener);
    }

    public boolean removeProtocolHandlerListener(ProtocolHandlerListener listener) {
        return this.listenerHandler.removeProtocolHandlerListener(listener);
    }

    public ProtocolStepConfiguration getProtocolStepConfiguration(String stepKey) {
        return this.configMap.get(stepKey);
    }

    public void setRecordEnabled(boolean recordEnabled) {
        LOG.info((Object)("protocol globally enabled: " + recordEnabled));
        this.recordEnabled = recordEnabled;
        this.fireRecordStateChanged(new ProtocolHandlerListenerEvent(this, ProtocolHandlerListenerEvent.PROTOCOL_RECORD_STATE));
    }

    public boolean isRecordEnabled() {
        return this.recordEnabled;
    }

    public void removeStep(ProtocolStep protocolStep) {
        this.storage.remove(protocolStep);
        this.fireStepRemoved(new ProtocolHandlerListenerEvent(this, protocolStep, ProtocolHandlerListenerEvent.PROTOCOL_STEP_REMOVED));
    }

    public boolean recordStep(ProtocolStep protocolStep) {
        return this.recordStep(protocolStep, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recordStep(final ProtocolStep protocolStep, boolean checkIfRecordIsEnabled) {
        if (!checkIfRecordIsEnabled || this.isRecordEnabled()) {
            LinkedList<ProtocolStep> linkedList = this.storage;
            synchronized (linkedList) {
                this.storage.add(protocolStep);
            }
            this.fireStepAdded(new ProtocolHandlerListenerEvent(this, protocolStep, ProtocolHandlerListenerEvent.PROTOCOL_STEP_ADDED));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    protocolStep.init();
                }
            }).start();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("protocol step '" + protocolStep.getMetaInfo().getKey() + "' added."));
            }
            return true;
        }
        LOG.warn((Object)("protocol step '" + protocolStep.getMetaInfo().getKey() + "' not added: protocol globally  disabled!"));
        return false;
    }

    public ProtocolStep getLastStep() {
        return this.storage.getLast();
    }

    public List<ProtocolStep> getAllSteps() {
        return new ArrayList<ProtocolStep>(this.storage);
    }

    public List<ProtocolStepToolbarItem> getToolbarItems() {
        return new ArrayList<ProtocolStepToolbarItem>(this.toolbarItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSteps() {
        LinkedList<ProtocolStep> linkedList = this.storage;
        synchronized (linkedList) {
            this.storage.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"all protocol step cleared");
        }
        this.fireStepsCleared(new ProtocolHandlerListenerEvent(this, ProtocolHandlerListenerEvent.PROTOCOL_STEPS_CLEARED));
    }

    public String toJsonString() throws JsonProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saving " + this.storage.size() + " protocol objects to JSON"));
        }
        return this.objectMapper.writerWithType((TypeReference)new TypeReference<Collection<ProtocolStep>>(){}).writeValueAsString(this.storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromJsonString(String jsonString) throws IOException, ClassNotFoundException {
        Collection loadedStorage = (Collection)this.objectMapper.readValue(jsonString, (TypeReference)new TypeReference<Collection<ProtocolStep>>(){});
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(loadedStorage.size() + " protocol objects restored from JSON"));
        }
        LinkedList<ProtocolStep> linkedList = this.storage;
        synchronized (linkedList) {
            this.storage.clear();
            this.storage.addAll(loadedStorage);
        }
        this.fireStepsRestored(new ProtocolHandlerListenerEvent(this, ProtocolHandlerListenerEvent.PROTOCOL_STEPS_RESTORED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromFile(File file) throws IOException, ClassNotFoundException {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            this.fromJsonString(sb.toString());
        }
    }

    public void writeToFile(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write(this.toJsonString());
        fw.close();
    }

    protected void fireRecordStateChanged(ProtocolHandlerListenerEvent event) {
        this.listenerHandler.recordStateChanged(event);
    }

    protected void fireStepAdded(ProtocolHandlerListenerEvent event) {
        this.listenerHandler.stepAdded(event);
    }

    protected void fireStepRemoved(ProtocolHandlerListenerEvent event) {
        this.listenerHandler.stepRemoved(event);
    }

    protected void fireStepsCleared(ProtocolHandlerListenerEvent event) {
        this.listenerHandler.stepsCleared(event);
    }

    protected void fireStepsRestored(ProtocolHandlerListenerEvent event) {
        this.listenerHandler.stepsRestored(event);
    }

    public void configure(Element parent) {
        Element root = parent.getChild("protocolHandler");
        Element steps = root.getChild("protocolSteps");
        for (String key : this.configMap.keySet()) {
            try {
                ProtocolStepConfiguration config = this.configMap.get(key);
                config.configure(steps);
            }
            catch (Exception ex) {
                LOG.warn((Object)("error while configuration of " + key), (Throwable)ex);
            }
        }
    }

    public void masterConfigure(Element parent) {
        this.configure(parent);
    }

    public Element getConfiguration() throws NoWriteError {
        Element root = new Element("protocolHandler");
        Element steps = new Element("protocolSteps");
        root.addContent((Content)steps);
        for (Configurable configurable : this.configMap.values()) {
            try {
                Element element = configurable.getConfiguration();
                if (element == null) continue;
                steps.addContent((Content)element);
            }
            catch (Exception t) {
                LOG.warn((Object)"error while writing config part", (Throwable)t);
            }
        }
        return root;
    }

    private class ProtocolHandlerListenerHandler
    implements ProtocolHandlerListener {
        private final Collection<ProtocolHandlerListener> listeners = new ArrayList<ProtocolHandlerListener>();

        private ProtocolHandlerListenerHandler() {
        }

        public boolean addProtocolHandlerListener(ProtocolHandlerListener listener) {
            return this.listeners.add(listener);
        }

        public boolean removeProtocolHandlerListener(ProtocolHandlerListener listener) {
            return this.listeners.remove(listener);
        }

        @Override
        public void recordStateChanged(ProtocolHandlerListenerEvent event) {
            for (ProtocolHandlerListener listener : this.listeners) {
                listener.recordStateChanged(event);
            }
        }

        @Override
        public void stepAdded(ProtocolHandlerListenerEvent event) {
            for (ProtocolHandlerListener listener : this.listeners) {
                listener.stepAdded(event);
            }
        }

        @Override
        public void stepRemoved(ProtocolHandlerListenerEvent event) {
            for (ProtocolHandlerListener listener : this.listeners) {
                listener.stepRemoved(event);
            }
        }

        @Override
        public void stepsCleared(ProtocolHandlerListenerEvent event) {
            for (ProtocolHandlerListener listener : this.listeners) {
                listener.stepsCleared(event);
            }
        }

        @Override
        public void stepsRestored(ProtocolHandlerListenerEvent event) {
            for (ProtocolHandlerListener listener : this.listeners) {
                listener.stepsRestored(event);
            }
        }
    }
}

