/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.protocol.test;

import de.cismet.commons.gui.protocol.AbstractProtocolStep;
import de.cismet.commons.gui.protocol.ProtocolHandler;
import de.cismet.commons.gui.protocol.ProtocolStep;
import de.cismet.commons.gui.protocol.impl.CommentProtocolStep;
import de.cismet.commons.gui.protocol.impl.CommentProtocolStepImpl;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.util.List;
import org.apache.log4j.Logger;

public class ProtocolTester {
    private static final Logger LOG = Logger.getLogger(ProtocolTester.class);

    private ProtocolTester() {
    }

    public static void main(String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        ProtocolTester tester = new ProtocolTester();
        try {
            tester.test();
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
        }
    }

    private void test() throws Exception {
        ProtocolTester.log("========================");
        ProtocolTester.log("= single protocol test = ");
        ProtocolTester.log("========================");
        ProtocolTester.log("creating protocol...");
        CommentProtocolStepImpl proto = new CommentProtocolStepImpl("dies ist ein Test-Kommentar");
        ProtocolTester.log("protocol: " + proto);
        ProtocolTester.log("* date: " + proto.getDate());
        ProtocolTester.log("* message: " + proto.getMessage());
        ProtocolTester.log("storing protocol to json...");
        String jsonString = proto.toJsonString();
        ProtocolTester.log("json:" + jsonString);
        ProtocolTester.log("restoring protocol from json...");
        CommentProtocolStep newProto = (CommentProtocolStep)AbstractProtocolStep.fromJsonString(jsonString, CommentProtocolStepImpl.class);
        ProtocolTester.log("protocol: " + newProto);
        ProtocolTester.log("* date: " + newProto.getDate());
        ProtocolTester.log("* message: " + newProto.getMessage());
        ProtocolTester.log("=========================");
        ProtocolTester.log("= protocol handler test =");
        ProtocolTester.log("=========================");
        ProtocolTester.log(new CommentProtocolStepImpl("Protollierungs-Test nummer eins...").toJsonString());
        ProtocolTester.log("recording some protocols...");
        ProtocolHandler.getInstance().setRecordEnabled(true);
        ProtocolHandler.getInstance().recordStep(new CommentProtocolStepImpl("Protollierungs-Test nummer eins..."));
        ProtocolHandler.getInstance().recordStep(new CommentProtocolStepImpl("...noch ein Test..."));
        ProtocolHandler.getInstance().recordStep(new CommentProtocolStepImpl("...es wird wie wild getestet..."));
        ProtocolHandler.getInstance().recordStep(new CommentProtocolStepImpl("...irgendwann reicht es aber auch !"));
        ProtocolTester.log("number of recorded protocols: " + ProtocolHandler.getInstance().getAllSteps().size());
        ProtocolTester.log("storing all protocols to json...");
        String allProtosJson = ProtocolHandler.getInstance().toJsonString();
        ProtocolTester.log("json: " + allProtosJson);
        ProtocolTester.log("restoring all protocols from json...");
        ProtocolHandler.getInstance().fromJsonString(allProtosJson);
        List<ProtocolStep> newList = ProtocolHandler.getInstance().getAllSteps();
        ProtocolTester.log("size after jsonify: " + newList.size());
        ProtocolTester.log("protocolls after jsonify: ");
        for (ProtocolStep newProtoFromList : newList) {
            ProtocolTester.log("protocol: " + newProtoFromList.getClass().getCanonicalName());
            CommentProtocolStep newProtoFromListCasted = (CommentProtocolStep)newProtoFromList;
            ProtocolTester.log("* date: " + newProtoFromListCasted.getDate());
            ProtocolTester.log("* message: " + newProtoFromListCasted.getMessage());
            ProtocolTester.log(" ----- ");
        }
    }

    private static void log(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)message);
        }
        System.out.println(message);
    }
}

