/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.wizard.converter;

import de.cismet.commons.converter.Converter;
import de.cismet.commons.gui.l10n.Localizable;
import de.cismet.commons.gui.wizard.AbstractWizardPanel;
import de.cismet.commons.gui.wizard.converter.DefaultConverterChooseVisualPanel;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.ResourceBundle;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public abstract class AbstractConverterChooseWizardPanel
extends AbstractWizardPanel
implements Localizable {
    public static final String PROP_CONVERTER = "__prop_converter__";
    public static final String PROPERTY_INIT = "__property_init__";
    private final transient PropertyChangeSupport propCSupport = new PropertyChangeSupport(this);
    private transient Converter converter;
    private transient ResourceBundle resourceBundle;

    @Override
    protected Component createComponent() {
        return new DefaultConverterChooseVisualPanel(this);
    }

    @Override
    protected void read(WizardDescriptor wizard) {
        this.converter = (Converter)wizard.getProperty(PROP_CONVERTER);
        this.propCSupport.firePropertyChange(PROPERTY_INIT, null, null);
        wizard.putProperty("WizardPanel_infoMessage", (Object)this.getText("AbstractConverterChooseWizardPanel.read(WizardDescriptor).wizard.putProperty(String,String)"));
    }

    @Override
    protected void store(WizardDescriptor wizard) {
        wizard.putProperty(PROP_CONVERTER, (Object)this.converter);
        wizard.putProperty("WizardPanel_infoMessage", null);
    }

    @Override
    public boolean isValid() {
        return this.converter != null;
    }

    public abstract List<Converter> getAvailableConverters();

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        Converter old = this.converter;
        this.converter = converter;
        this.changeSupport.fireChange();
        this.propCSupport.firePropertyChange("converter", old, converter);
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public void setResourceBundle(ResourceBundle resourceBundle) {
        ResourceBundle old = this.resourceBundle;
        this.resourceBundle = resourceBundle;
        this.propCSupport.firePropertyChange("resourceBundle", old, resourceBundle);
    }

    public String getText(String property) {
        if (this.resourceBundle == null) {
            return NbBundle.getMessage(DefaultConverterChooseVisualPanel.class, (String)property);
        }
        try {
            return this.resourceBundle.getString(property);
        }
        catch (Exception e) {
            return NbBundle.getMessage(DefaultConverterChooseVisualPanel.class, (String)property);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propCSupport.addPropertyChangeListener(pcl);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener pcl) {
        this.propCSupport.addPropertyChangeListener(property, pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.propCSupport.removePropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener pcl) {
        this.propCSupport.removePropertyChangeListener(property, pcl);
    }
}

