/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.wizard.converter;

import de.cismet.commons.converter.Converter;
import de.cismet.commons.converter.FormatHint;
import de.cismet.commons.gui.wizard.converter.AbstractConverterChooseWizardPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.util.WeakListeners;

public class DefaultConverterChooseVisualPanel
extends JPanel {
    private static final transient Logger LOG = Logger.getLogger(DefaultConverterChooseVisualPanel.class);
    private final transient AbstractConverterChooseWizardPanel model;
    private final transient ItemListener converterL;
    private final transient PropertyChangeListener propChangeL;
    private transient boolean initialising;
    private final transient JComboBox cboConverterChooser = new JComboBox();
    private final transient JPanel jPanel1 = new JPanel();
    private final transient JLabel lblConverter = new JLabel();
    private final transient JLabel lblFormatDescription = new JLabel();
    private final transient JLabel lblFormatDescriptionValue = new JLabel();
    private final transient JLabel lblFormatExample = new JLabel();
    private final transient JLabel lblFormatExampleValue = new JLabel();
    private final transient JPanel pnlFormatExample = new JPanel();

    public DefaultConverterChooseVisualPanel(AbstractConverterChooseWizardPanel model) {
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        this.model = model;
        this.converterL = new ConverterItemListener();
        this.propChangeL = new ModelPropertyChangeL();
        this.initialising = false;
        this.initComponents();
        this.setName(model.getText("DefaultConverterChooseVisualPanel.name"));
        this.cboConverterChooser.addItemListener((ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.converterL, (Object)this.cboConverterChooser));
        this.cboConverterChooser.setRenderer(new ConverterRenderer());
        model.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propChangeL, (Object)model));
    }

    public AbstractConverterChooseWizardPanel getModel() {
        return this.model;
    }

    private void init() {
        assert (EventQueue.isDispatchThread()) : "only EDT allowed";
        this.initialising = true;
        Converter selectedConv = this.model.getConverter();
        this.cboConverterChooser.removeAllItems();
        List<Converter> converters = this.model.getAvailableConverters();
        Collections.sort(converters, new Comparator<Converter>(){

            @Override
            public int compare(Converter o1, Converter o2) {
                if (o1 instanceof FormatHint && o2 instanceof FormatHint) {
                    return ((FormatHint)o1).getFormatDisplayName().compareTo(((FormatHint)o2).getFormatDisplayName());
                }
                return o1.hashCode() - o2.hashCode();
            }
        });
        for (Converter converter : converters) {
            this.cboConverterChooser.addItem(converter);
        }
        this.initialising = false;
        if (selectedConv == null) {
            this.cboConverterChooser.setSelectedIndex(0);
        } else {
            this.cboConverterChooser.setSelectedItem(selectedConv);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.cboConverterChooser.setMinimumSize(new Dimension(300, 27));
        this.cboConverterChooser.setPreferredSize(new Dimension(300, 27));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.cboConverterChooser, gridBagConstraints);
        this.lblConverter.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblConverter.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblConverter, gridBagConstraints);
        this.lblFormatDescription.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblFormatDescription.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblFormatDescription, gridBagConstraints);
        this.lblFormatDescriptionValue.setFont(new Font("Tahoma", 0, 10));
        this.lblFormatDescriptionValue.setHorizontalAlignment(2);
        this.lblFormatDescriptionValue.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblFormatDescriptionValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.jPanel1.add((Component)this.lblFormatDescriptionValue, gridBagConstraints);
        this.lblFormatExample.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblFormatExample.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblFormatExample, gridBagConstraints);
        this.pnlFormatExample.setBackground(new Color(255, 255, 255));
        this.pnlFormatExample.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 2));
        this.pnlFormatExample.setLayout(new GridBagLayout());
        this.lblFormatExampleValue.setFont(new Font("Tahoma", 0, 10));
        this.lblFormatExampleValue.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblFormatExampleValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlFormatExample.add((Component)this.lblFormatExampleValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel1.add((Component)this.pnlFormatExample, gridBagConstraints);
        this.add((Component)this.jPanel1, "Center");
    }

    private void applyL10N() {
        this.setName(this.model.getText("DefaultConverterChooseVisualPanel.name"));
        this.lblFormatDescriptionValue.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblFormatDescriptionValue.text"));
        this.lblFormatExampleValue.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblFormatExampleValue.text"));
        this.lblConverter.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblConverter.text"));
        this.lblFormatDescription.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblFormatDescription.text"));
        this.lblFormatDescriptionValue.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblFormatDescriptionValue.text"));
        this.lblFormatExample.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblFormatExample.text"));
        this.lblFormatExampleValue.setText(this.model.getText("DefaultConverterChooseVisualPanel.lblFormatExampleValue.text"));
    }

    private final class ConverterItemListener
    implements ItemListener {
        private ConverterItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (DefaultConverterChooseVisualPanel.this.initialising) {
                return;
            }
            if (1 == e.getStateChange()) {
                Converter converter = (Converter)e.getItem();
                if (converter instanceof FormatHint) {
                    FormatHint hint = (FormatHint)converter;
                    if (hint.getFormatHtmlDescription() == null) {
                        DefaultConverterChooseVisualPanel.this.lblFormatDescriptionValue.setText(hint.getFormatDescription());
                    } else {
                        DefaultConverterChooseVisualPanel.this.lblFormatDescriptionValue.setText(hint.getFormatHtmlDescription());
                    }
                    Object formatExample = hint.getFormatExample();
                    if (formatExample instanceof String) {
                        DefaultConverterChooseVisualPanel.this.lblFormatExampleValue.setText((String)formatExample);
                    } else if (formatExample instanceof Component) {
                        DefaultConverterChooseVisualPanel.this.pnlFormatExample.removeAll();
                        DefaultConverterChooseVisualPanel.this.pnlFormatExample.add((Component)formatExample);
                    } else {
                        LOG.warn((Object)("unsupported example format: " + formatExample));
                        this.resetExample();
                    }
                } else {
                    DefaultConverterChooseVisualPanel.this.lblFormatDescriptionValue.setText(DefaultConverterChooseVisualPanel.this.model.getText("DefaultConverterChooseVisualPanel.lblFormatDescriptionValue.text"));
                    this.resetExample();
                }
                DefaultConverterChooseVisualPanel.this.model.setConverter(converter);
            }
        }

        private void resetExample() {
            DefaultConverterChooseVisualPanel.this.lblFormatExampleValue.setText(DefaultConverterChooseVisualPanel.this.model.getText("DefaultConverterChooseVisualPanel.lblFormatExampleValue.text"));
            DefaultConverterChooseVisualPanel.this.pnlFormatExample.removeAll();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 2;
            constraints.anchor = 18;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(10, 10, 10, 10);
            DefaultConverterChooseVisualPanel.this.pnlFormatExample.add((Component)DefaultConverterChooseVisualPanel.this.lblFormatExampleValue, constraints);
        }
    }

    private final class ConverterRenderer
    extends DefaultListCellRenderer {
        private ConverterRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (c instanceof JLabel && value instanceof FormatHint) {
                JLabel label = (JLabel)c;
                FormatHint formatHint = (FormatHint)value;
                label.setText(formatHint.getFormatDisplayName());
            }
            return c;
        }
    }

    private final class ModelPropertyChangeL
    implements PropertyChangeListener {
        private ModelPropertyChangeL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if ("converter".equals(prop)) {
                DefaultConverterChooseVisualPanel.this.cboConverterChooser.setSelectedItem(evt.getNewValue());
            } else if ("resourceBundle".equals(prop)) {
                DefaultConverterChooseVisualPanel.this.applyL10N();
            } else if ("__property_init__".equals(prop)) {
                DefaultConverterChooseVisualPanel.this.init();
            }
        }
    }
}

