/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lookupoptions.options;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;
import de.cismet.lookupoptions.options.SecurityOptionsCategory;
import de.cismet.security.PrivacyClientHandler;
import de.cismet.tools.configuration.NoWriteError;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class PrivacyOptionsPanel
extends AbstractOptionsPanel
implements OptionsPanelController {
    private static final transient Logger LOG = Logger.getLogger(PrivacyOptionsPanel.class);
    private static final String OPTION_NAME = NbBundle.getMessage(PrivacyOptionsPanel.class, (String)"PrivacyOptionsPanel.OptionController.name");
    private static final String XML_CONF_ROOT = "privacy";
    private static final String XML_CONF_SEND_UNCAUGHT_EXCEPTIONS = "sendUncaughtExceptions";
    private JCheckBox cbSendUncaughtClientExceptions;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JPanel jPanel3;

    public PrivacyOptionsPanel() {
        super(OPTION_NAME, SecurityOptionsCategory.class);
        this.initComponents();
        this.update();
    }

    @Override
    public final void update() {
        this.cbSendUncaughtClientExceptions.setSelected(PrivacyClientHandler.getInstance().isSendUncaughtExceptions());
    }

    @Override
    public void applyChanges() {
        PrivacyClientHandler.getInstance().setSendUncaughtExceptions(this.cbSendUncaughtClientExceptions.isSelected());
    }

    @Override
    public boolean isChanged() {
        return PrivacyClientHandler.getInstance().isSendUncaughtExceptions() != this.cbSendUncaughtClientExceptions.isSelected();
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(PrivacyOptionsPanel.class, (String)"PrivacyOptionsPanel.getTooltip().text");
    }

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public void configure(Element parent) {
        if (parent == null) {
            return;
        }
        boolean sendUncaughtExceptions = true;
        try {
            Element config = parent.getChild(XML_CONF_ROOT);
            Element sendUncaughtExceptionsElement = config.getChild(XML_CONF_SEND_UNCAUGHT_EXCEPTIONS);
            if (sendUncaughtExceptionsElement != null && sendUncaughtExceptionsElement.getTextTrim() != null) {
                sendUncaughtExceptions = Boolean.parseBoolean(sendUncaughtExceptionsElement.getTextTrim());
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)ex, (Throwable)ex);
        }
        PrivacyClientHandler.getInstance().setSendUncaughtExceptions(sendUncaughtExceptions);
        this.update();
    }

    @Override
    public void masterConfigure(Element parent) {
    }

    @Override
    public Element getConfiguration() throws NoWriteError {
        Element config = new Element(XML_CONF_ROOT);
        Element directory = new Element(XML_CONF_SEND_UNCAUGHT_EXCEPTIONS);
        directory.addContent(Boolean.toString(PrivacyClientHandler.getInstance().isSendUncaughtExceptions()));
        config.addContent((Content)directory);
        return config;
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.cbSendUncaughtClientExceptions = new JCheckBox();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.cbSendUncaughtClientExceptions.setText(NbBundle.getMessage(PrivacyOptionsPanel.class, (String)"PrivacyOptionsPanel.cbSendUncaughtClientExceptions.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.jPanel3.add((Component)this.cbSendUncaughtClientExceptions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.filler2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jPanel3, gridBagConstraints);
    }
}

