/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lookupoptions.options;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;
import de.cismet.lookupoptions.options.NetworkOptionsCategory;
import de.cismet.netutil.Proxy;
import de.cismet.netutil.ProxyHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ProxyOptionsPanel
extends AbstractOptionsPanel
implements OptionsPanelController {
    private static final transient Logger LOG = Logger.getLogger(ProxyOptionsPanel.class);
    private static final String OPTION_NAME = NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.OptionController.name");
    private final ProxyHandler.Listener proxyListener;
    private ButtonGroup buttonGroup1;
    private JCheckBox cbEnabled;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JLabel lblDomain;
    private JLabel lblExcludedHosts;
    private JLabel lblHost;
    private JLabel lblPassword;
    private JLabel lblPort;
    private JLabel lblUsername;
    private JPasswordField pwdPassword;
    private JRadioButton rdoManualProxy;
    private JRadioButton rdoPreconfiguredProxy;
    private JSpinner spiPort;
    private JTextField txtDomain;
    private JTextArea txtExcludedHosts;
    private JTextField txtHost;
    private JTextField txtUsername;

    public ProxyOptionsPanel() {
        super(OPTION_NAME, NetworkOptionsCategory.class);
        this.initComponents();
        Proxy preconfiguredProxy = ProxyHandler.getInstance().getPreconfiguredProxy();
        this.jPanel2.setVisible(preconfiguredProxy != null && preconfiguredProxy.isValid());
        this.update();
        this.proxyListener = new ProxyHandler.Listener(){

            public void proxyChanged(final ProxyHandler.Event event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProxyHandler.Mode mode = event.getNewMode();
                        ProxyOptionsPanel.this.updateFields(mode, (Proxy)(ProxyHandler.Mode.MANUAL.equals((Object)mode) ? ProxyHandler.getInstance().getManualProxy() : (ProxyHandler.Mode.PRECONFIGURED.equals((Object)mode) ? ProxyHandler.getInstance().getPreconfiguredProxy() : null)));
                    }
                });
            }
        };
        ProxyHandler.getInstance().addListener(this.proxyListener);
    }

    @Override
    public int getOrder() {
        return 1;
    }

    public void dispose() {
        ProxyHandler.getInstance().removeListener(this.proxyListener);
    }

    @Override
    public final void update() {
        ProxyHandler.Mode mode = ProxyHandler.getInstance().getMode();
        if (mode != null) {
            switch (mode) {
                case MANUAL: {
                    this.rdoManualProxyActionPerformed(null);
                    break;
                }
                case PRECONFIGURED: {
                    this.rdoPreconfiguredProxyActionPerformed(null);
                }
            }
        }
    }

    @Override
    public void applyChanges() {
        ProxyHandler.Mode selectedMode = this.getSelectedMode();
        if (selectedMode != null) {
            switch (selectedMode) {
                case MANUAL: {
                    ProxyHandler.getInstance().useManualProxy(this.getProxyFromFields());
                    break;
                }
                case PRECONFIGURED: {
                    ProxyHandler.getInstance().usePreconfiguredProxy();
                    break;
                }
                default: {
                    ProxyHandler.getInstance().useNoProxy();
                    break;
                }
            }
        } else {
            ProxyHandler.getInstance().useNoProxy();
        }
    }

    private ProxyHandler.Mode getSelectedMode() {
        if (this.rdoPreconfiguredProxy.isSelected()) {
            return ProxyHandler.Mode.PRECONFIGURED;
        }
        if (this.rdoManualProxy.isSelected()) {
            return ProxyHandler.Mode.MANUAL;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        ProxyHandler.Mode selectedMode;
        ProxyHandler.Mode mode = ProxyHandler.getInstance().getMode();
        if (!Objects.equals(mode, selectedMode = this.getSelectedMode())) {
            return true;
        }
        if (ProxyHandler.Mode.MANUAL.equals((Object)selectedMode)) {
            Proxy proxy = ProxyHandler.getInstance().getManualProxy();
            String host = proxy != null ? proxy.getHost() : "";
            int port = proxy != null ? proxy.getPort() : 0;
            String username = proxy != null ? proxy.getUsername() : "";
            String password = proxy != null ? proxy.getPassword() : "";
            String domain = proxy != null ? proxy.getDomain() : "";
            String excludeHosts = proxy != null ? proxy.getExcludedHosts() : "";
            return !this.txtHost.getText().equals(host) || (Integer)this.spiPort.getValue() != port || !this.txtUsername.getText().equals(username) || !String.valueOf(this.pwdPassword.getPassword()).equals(password) || !this.txtDomain.getText().equals(domain) || !this.txtExcludedHosts.getText().replaceAll("Pattern.quote(\n)", "|").equals(excludeHosts);
        }
        return false;
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.getTooltip().text");
    }

    private void updateFields(ProxyHandler.Mode mode, Proxy proxy) {
        this.cbEnabled.setEnabled(ProxyHandler.Mode.MANUAL.equals((Object)mode));
        boolean enabledFields = ProxyHandler.Mode.MANUAL.equals((Object)mode) && proxy != null && proxy.isEnabled();
        this.jPanel1.setEnabled(enabledFields);
        this.lblHost.setEnabled(enabledFields);
        this.txtHost.setEnabled(enabledFields);
        this.lblPort.setEnabled(enabledFields);
        this.spiPort.setEnabled(enabledFields);
        this.lblUsername.setEnabled(enabledFields);
        this.txtUsername.setEnabled(enabledFields);
        this.lblPassword.setEnabled(enabledFields);
        this.pwdPassword.setEnabled(enabledFields);
        this.lblDomain.setEnabled(enabledFields);
        this.txtDomain.setEnabled(enabledFields);
        this.jPanel7.setEnabled(enabledFields);
        this.lblExcludedHosts.setEnabled(enabledFields);
        this.txtExcludedHosts.setEnabled(enabledFields);
        this.rdoManualProxy.setSelected(ProxyHandler.Mode.MANUAL.equals((Object)mode));
        this.rdoPreconfiguredProxy.setSelected(ProxyHandler.Mode.PRECONFIGURED.equals((Object)mode));
        this.cbEnabled.setSelected(proxy != null ? proxy.isEnabled() : false);
        this.txtHost.setText(proxy != null ? proxy.getHost() : null);
        this.spiPort.setValue(proxy != null ? proxy.getPort() : 0);
        this.txtUsername.setText(proxy != null ? proxy.getUsername() : null);
        this.pwdPassword.setText(proxy != null ? proxy.getPassword() : null);
        this.txtExcludedHosts.setText(proxy != null && proxy.getExcludedHosts() != null ? proxy.getExcludedHosts().replaceAll(Pattern.quote("|"), "\n") : null);
        this.txtDomain.setText(proxy != null ? proxy.getDomain() : null);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.rdoPreconfiguredProxy = new JRadioButton();
        this.rdoManualProxy = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.cbEnabled = new JCheckBox();
        this.lblHost = new JLabel();
        this.txtHost = new JTextField();
        this.lblPort = new JLabel();
        this.spiPort = new JSpinner();
        this.jPanel1 = new JPanel();
        this.jPanel6 = new JPanel();
        this.lblUsername = new JLabel();
        this.txtUsername = new JTextField();
        this.lblPassword = new JLabel();
        this.pwdPassword = new JPasswordField();
        this.lblDomain = new JLabel();
        this.txtDomain = new JTextField();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.lblExcludedHosts = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtExcludedHosts = new JTextArea();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridLayout(0, 1));
        this.buttonGroup1.add(this.rdoPreconfiguredProxy);
        this.rdoPreconfiguredProxy.setSelected(true);
        this.rdoPreconfiguredProxy.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.rdoPreconfiguredProxy.text"));
        this.rdoPreconfiguredProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProxyOptionsPanel.this.rdoPreconfiguredProxyActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.rdoPreconfiguredProxy);
        this.buttonGroup1.add(this.rdoManualProxy);
        this.rdoManualProxy.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.rdoManualProxy.text"));
        this.rdoManualProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProxyOptionsPanel.this.rdoManualProxyActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.rdoManualProxy);
        this.rdoManualProxy.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.rdoManualProxy.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel5.setLayout(new GridBagLayout());
        this.cbEnabled.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.cbEnabled.text"));
        this.cbEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProxyOptionsPanel.this.cbEnabledActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.jPanel5.add((Component)this.cbEnabled, gridBagConstraints);
        this.lblHost.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.lblHost.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel5.add((Component)this.lblHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel5.add((Component)this.txtHost, gridBagConstraints);
        this.lblPort.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.lblPort.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel5.add((Component)this.lblPort, gridBagConstraints);
        this.spiPort.setModel(new SpinnerNumberModel(0, 0, 65535, 1));
        this.spiPort.setEditor(new JSpinner.NumberEditor(this.spiPort, "0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel5.add((Component)this.spiPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.jPanel1.border.title")));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel6.setLayout(new GridBagLayout());
        this.lblUsername.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.lblUsername.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel6.add((Component)this.lblUsername, gridBagConstraints);
        this.txtUsername.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.txtUsername.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel6.add((Component)this.txtUsername, gridBagConstraints);
        this.lblPassword.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.lblPassword.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel6.add((Component)this.lblPassword, gridBagConstraints);
        this.pwdPassword.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.pwdPassword.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel6.add((Component)this.pwdPassword, gridBagConstraints);
        this.lblDomain.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.lblDomain.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel6.add((Component)this.lblDomain, gridBagConstraints);
        this.txtDomain.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.txtDomain.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel6.add((Component)this.txtDomain, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel4.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.jPanel7.border.title")));
        this.jPanel7.setLayout(new GridBagLayout());
        this.jPanel8.setLayout(new GridBagLayout());
        this.lblExcludedHosts.setText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.lblExcludedHosts.text"));
        this.lblExcludedHosts.setToolTipText(NbBundle.getMessage(ProxyOptionsPanel.class, (String)"ProxyOptionsPanel.lblExcludedHosts.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.jPanel8.add((Component)this.lblExcludedHosts, gridBagConstraints);
        this.txtExcludedHosts.setColumns(20);
        this.txtExcludedHosts.setRows(5);
        this.jScrollPane1.setViewportView(this.txtExcludedHosts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel8.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.jPanel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel3.add((Component)this.jPanel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private Proxy getProxyFromFields() {
        return new Proxy(this.cbEnabled.isSelected(), this.txtHost.getText().trim(), ((Integer)this.spiPort.getValue()).intValue(), this.txtExcludedHosts.getText().replaceAll(Pattern.quote("\n"), "|"), this.txtUsername.getText(), String.valueOf(this.pwdPassword.getPassword()), this.txtDomain.getText());
    }

    private void rdoPreconfiguredProxyActionPerformed(ActionEvent evt) {
        ProxyHandler.getInstance().setManualProxy(this.getProxyFromFields());
        this.updateFields(ProxyHandler.Mode.PRECONFIGURED, ProxyHandler.getInstance().getPreconfiguredProxy());
    }

    private void rdoManualProxyActionPerformed(ActionEvent evt) {
        this.updateFields(ProxyHandler.Mode.MANUAL, ProxyHandler.getInstance().getManualProxy());
    }

    private void cbEnabledActionPerformed(ActionEvent evt) {
        Proxy proxy = ProxyHandler.getInstance().getManualProxy();
        proxy.setEnabled(this.cbEnabled.isSelected());
        this.updateFields(this.getSelectedMode(), proxy);
    }
}

