/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.security;

import de.cismet.netutil.Proxy;
import de.cismet.netutil.ProxyHandler;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.gui.DialogOpenedEvent;
import de.cismet.tools.gui.DialogSupport;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXLoginPane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.auth.DefaultUserNameStore;
import org.jdesktop.swingx.auth.LoginService;
import org.jdesktop.swingx.auth.UserNameStore;
import org.openide.util.NbBundle;

public class GUICredentialsProvider
extends LoginService
implements CredentialsProvider {
    private static final Logger log = Logger.getLogger(GUICredentialsProvider.class);
    private DefaultUserNameStore usernames;
    private Preferences appPrefs = null;
    private UsernamePasswordCredentials creds;
    private Component parent;
    private JFrame parentFrame;
    private boolean isAuthenticationCanceled = false;
    private URL url;
    private Object dummy = new Object();
    private String username = null;
    private String title;
    private String prefTitle;

    public GUICredentialsProvider(URL url) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating new Credential Provider Instance for URL: " + url.toString()));
        }
        this.url = url;
    }

    public GUICredentialsProvider(URL url, Component parentComponent) {
        this(url);
        if (parentComponent != null) {
            this.parent = StaticSwingTools.getParentFrame(parentComponent);
            if (this.parent == null) {
                this.parent = StaticSwingTools.getFirstParentFrame(parentComponent);
            }
        }
    }

    public String getUserName() {
        return this.creds.getUserName();
    }

    public UsernamePasswordCredentials getCredentials() {
        return this.creds;
    }

    public void setUsernamePassword(UsernamePasswordCredentials creds) {
        this.creds = creds;
    }

    public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Credentials requested for :" + this.url.toString() + " alias: " + this.title));
        }
        this.usernames = new DefaultUserNameStore();
        this.appPrefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        this.usernames.setPreferences(this.appPrefs.node("loginURLHash" + Integer.toString(this.url.toString().hashCode())));
        if (this.creds != null) {
            return this.creds;
        }
        Object object = this.dummy;
        synchronized (object) {
            if (this.creds != null) {
                return this.creds;
            }
            this.isAuthenticationCanceled = false;
            if (authscheme == null) {
                return null;
            }
            if (authscheme instanceof NTLMScheme) {
                this.requestUsernamePassword();
                return this.creds;
            }
            if (authscheme instanceof RFC2617Scheme) {
                block13: {
                    String[] userPassword = this.addUserAndPasswordToUrlIfRequired(this.url.toString());
                    if (userPassword != null) {
                        try {
                            if (this.authenticate(userPassword[0], userPassword[1].toCharArray(), null)) {
                                return this.creds;
                            }
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block13;
                            log.debug((Object)"Error during athentication with url user/password", (Throwable)e);
                        }
                    }
                }
                this.requestUsernamePassword();
                return this.creds;
            }
            throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
        }
    }

    private String[] addUserAndPasswordToUrlIfRequired(String url) {
        String userPwd;
        if (url.contains("@") && url.contains("://") && url.indexOf("@") > url.indexOf("://") && (userPwd = url.substring(url.indexOf("://") + 3, url.indexOf("@"))).contains(":")) {
            String[] userPassword = new String[]{userPwd.substring(0, userPwd.indexOf(":")), userPwd.substring(userPwd.indexOf(":") + 1)};
            return userPassword;
        }
        return null;
    }

    private void requestUsernamePassword() throws CredentialsNotAvailableException {
        try {
            JXLoginPane login = new JXLoginPane((LoginService)this, null, (UserNameStore)this.usernames);
            String[] names = this.usernames.getUserNames();
            if (names.length != 0) {
                this.username = names[names.length - 1];
            }
            login.setUserName(this.username);
            this.title = WebAccessManager.getInstance().getServerAliasProperty(this.url.toString());
            if (this.title != null) {
                login.setMessage(NbBundle.getMessage(GUICredentialsProvider.class, (String)"GUICredentialsProvider.requestUsernamePassword().login.message") + " \"" + this.title + "\" ");
            } else {
                this.title = this.url.toString();
                if (this.title.startsWith("http://") && this.title.length() > 21) {
                    this.title = this.title.substring(7, 21) + "...";
                } else if (this.title.length() > 14) {
                    this.title = this.title.substring(0, 14) + "...";
                }
                login.setMessage(NbBundle.getMessage(GUICredentialsProvider.class, (String)"GUICredentialsProvider.requestUsernamePassword().login.message") + "\n \"" + this.title + "\" ");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("parentFrame in GUICredentialprovider:" + this.parent));
            }
            JXLoginPane.JXLoginDialog dialog = new JXLoginPane.JXLoginDialog((Frame)((JFrame)this.parent), login);
            try {
                ((JXPanel)((JXPanel)login.getComponent(1)).getComponent(1)).getComponent(3).requestFocus();
            }
            catch (Exception exception) {
                // empty catch block
            }
            dialog.setAlwaysOnTop(true);
            dialog.toFront();
            dialog.setAlwaysOnTop(false);
            DialogSupport.fireNewDialogOpened(new DialogOpenedEvent((JDialog)dialog));
            dialog.setVisible(true);
            if (JXLoginPane.Status.SUCCEEDED != dialog.getStatus()) {
                this.isAuthenticationCanceled = true;
                throw new CredentialsNotAvailableException();
            }
        }
        catch (RuntimeException rte) {
            log.error((Object)"Problem in GUICredProv", (Throwable)rte);
        }
    }

    public boolean authenticate(String name, char[] password, String server) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication with username: " + name));
        }
        if (this.testConnection(new UsernamePasswordCredentials(name, new String(password)))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Credentials are valid for URL: " + this.url.toString()));
            }
            this.usernames.removeUserName(name);
            this.usernames.saveUserNames();
            this.usernames.addUserName(name);
            this.usernames.saveUserNames();
            this.setUsernamePassword(new UsernamePasswordCredentials(name, new String(password)));
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Credentials are not valid for URL: " + this.url.toString()));
        }
        return false;
    }

    public boolean isAuthenticationCanceled() {
        return this.isAuthenticationCanceled;
    }

    public boolean testConnection(UsernamePasswordCredentials creds) {
        HttpClient client = new HttpClient();
        Proxy proxy = ProxyHandler.getInstance().getProxy();
        if (proxy != null && proxy.isValid() && proxy.isEnabledFor(this.url.getHost())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"proxyIs Set");
                log.debug((Object)("ProxyHost:" + System.getProperty("http.proxyHost")));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ProxyPort:" + System.getProperty("http.proxyPort")));
            }
            try {
                client.getHostConfiguration().setProxy(proxy.getHost(), proxy.getPort());
                if (proxy.getUsername() != null && proxy.getPassword() != null) {
                    AuthScope authscope = new AuthScope(proxy.getHost(), proxy.getPort());
                    NTCredentials credentials = new NTCredentials(proxy.getUsername(), proxy.getPassword(), "", proxy.getDomain() == null ? "" : proxy.getDomain());
                    client.getState().setProxyCredentials(authscope, (Credentials)credentials);
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem while setting proxy", (Throwable)e);
            }
        }
        GetMethod method = new GetMethod(this.url.toString());
        client.getState().setCredentials(new AuthScope(this.url.getHost(), -1, AuthScope.ANY_REALM), (Credentials)creds);
        method.setDoAuthentication(true);
        int statuscode = 200;
        try {
            statuscode = client.executeMethod((HttpMethod)method);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (statuscode != 401) {
            method.releaseConnection();
            return true;
        }
        method.releaseConnection();
        this.usernames.removeUserName(creds.getUserName());
        return false;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

