/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.security;

import de.cismet.security.WebAccessManager;
import de.cismet.tools.gui.DialogOpenedEvent;
import de.cismet.tools.gui.DialogSupport;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXLoginPane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.auth.DefaultUserNameStore;
import org.jdesktop.swingx.auth.LoginService;
import org.jdesktop.swingx.auth.UserNameStore;
import org.openide.util.NbBundle;

public abstract class PasswordDialog
extends LoginService {
    private static final Logger log = Logger.getLogger(PasswordDialog.class);
    protected DefaultUserNameStore usernames;
    protected Component parent;
    protected boolean isAuthenticationDone = false;
    protected URL url;
    private Preferences appPrefs = null;
    private UsernamePasswordCredentials creds;
    private JFrame parentFrame;
    private boolean isAuthenticationCanceled = false;
    private Object dummy = new Object();
    private String username = null;
    private String title;
    private String prefTitle;

    public PasswordDialog(URL url) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating new PaswordDialog Instance for URL: " + url.toString()));
        }
        this.url = url;
    }

    public PasswordDialog(URL url, Component parentComponent) {
        this(url);
        if (parentComponent != null) {
            this.parent = StaticSwingTools.getParentFrame(parentComponent);
            if (this.parent == null) {
                this.parent = StaticSwingTools.getFirstParentFrame(parentComponent);
            }
        }
    }

    public String getUserName() {
        return this.creds.getUserName();
    }

    public void setUsernamePassword(UsernamePasswordCredentials creds) {
        this.creds = creds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsernamePasswordCredentials getCredentials() throws CredentialsNotAvailableException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Credentials requested for :" + this.url.toString() + " alias: " + this.title));
        }
        this.usernames = new DefaultUserNameStore();
        this.appPrefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        this.usernames.setPreferences(this.appPrefs.node("loginURLHash" + Integer.toString(this.url.toString().hashCode())));
        if (this.creds != null) {
            return this.creds;
        }
        Object object = this.dummy;
        synchronized (object) {
            if (this.creds != null) {
                return this.creds;
            }
            this.isAuthenticationCanceled = false;
            this.requestUsernamePassword();
            return this.creds;
        }
    }

    private void requestUsernamePassword() throws CredentialsNotAvailableException {
        String msg;
        if (log.isDebugEnabled()) {
            log.debug((Object)"requestUsernamePassword");
        }
        JXLoginPane login = new JXLoginPane((LoginService)this, null, (UserNameStore)this.usernames);
        String[] names = this.usernames.getUserNames();
        if (names.length != 0) {
            this.username = names[names.length - 1];
        }
        login.setUserName(this.username);
        this.title = WebAccessManager.getInstance().getServerAliasProperty(this.url.toString());
        if (this.title != null) {
            msg = NbBundle.getMessage(PasswordDialog.class, (String)"PasswordDialog.requestUsernamePassword().login.message");
            login.setMessage(msg + " \"" + this.title + "\" ");
        } else {
            this.title = this.url.toString();
            if (this.title.startsWith("http://") && this.title.length() > 21) {
                this.title = this.title.substring(7, 21) + "...";
            } else if (this.title.length() > 14) {
                this.title = this.title.substring(0, 14) + "...";
            }
            msg = NbBundle.getMessage(PasswordDialog.class, (String)"PasswordDialog.requestUsernamePassword().login.message");
            login.setMessage(msg + "\n \"" + this.title + "\" ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parentFrame in GUICredentialprovider:" + this.parent));
        }
        JXLoginPane.JXLoginDialog dialog = new JXLoginPane.JXLoginDialog((Frame)((JFrame)this.parent), login);
        try {
            ((JXPanel)((JXPanel)login.getComponent(1)).getComponent(1)).getComponent(3).requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
        login.setVisible(true);
        dialog.setAlwaysOnTop(true);
        dialog.toFront();
        dialog.setAlwaysOnTop(false);
        DialogSupport.fireNewDialogOpened(new DialogOpenedEvent((JDialog)dialog));
        dialog.setVisible(true);
        if (!this.isAuthenticationDone) {
            this.isAuthenticationCanceled = true;
            throw new CredentialsNotAvailableException();
        }
    }

    public abstract boolean authenticate(String var1, char[] var2, String var3) throws Exception;

    public boolean isAuthenticationCanceled() {
        return this.isAuthenticationCanceled;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

