/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.security;

import de.cismet.security.PasswordDialog;
import java.awt.Component;
import java.net.URL;
import net.environmatics.acs.accessor.WSSAccessorDeegree;
import net.environmatics.acs.accessor.interfaces.AuthenticationMethod;
import net.environmatics.acs.accessor.methods.PasswordAuthenticationMethod;
import net.environmatics.acs.exceptions.AuthenticationFailedException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.log4j.Logger;

public class WSSPasswordDialog
extends PasswordDialog {
    private static final Logger log = Logger.getLogger(WSSPasswordDialog.class);
    private final WSSAccessorDeegree wssac = new WSSAccessorDeegree();
    private String sInfo;
    private String subParent;

    public WSSPasswordDialog(URL url, Component parentComponent, String subParent) {
        super(url, parentComponent);
        this.wssac.setWSS(url.toString());
        this.subParent = subParent;
    }

    @Override
    public boolean authenticate(String name, char[] password, String server) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication with username: " + name));
        }
        try {
            PasswordAuthenticationMethod authMethod = new PasswordAuthenticationMethod(name + "," + new String(password));
            this.sInfo = this.wssac.getSession((AuthenticationMethod)authMethod).getSessionID();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authentication successful for WSS " + this.url.toString() + " New SesionID:" + this.sInfo));
            }
            this.usernames.removeUserName(name);
            this.usernames.saveUserNames();
            this.usernames.addUserName(name);
            this.usernames.saveUserNames();
            this.isAuthenticationDone = true;
            this.setUsernamePassword(new UsernamePasswordCredentials(name, new String(password)));
            return true;
        }
        catch (AuthenticationFailedException ex) {
            log.error((Object)("Authentication failed for WSS: " + this.url.toString()), (Throwable)ex);
            return false;
        }
    }
}

