/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.security;

import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.security.Tunnel;
import de.cismet.commons.security.TunnelStore;
import de.cismet.commons.security.handler.ExtendedAccessHandler;
import de.cismet.commons.security.handler.ProxyCabaple;
import de.cismet.netutil.Proxy;
import de.cismet.netutil.ProxyHandler;
import de.cismet.security.exceptions.AccessMethodIsNotSupportedException;
import de.cismet.security.exceptions.MissingArgumentException;
import de.cismet.security.exceptions.NoHandlerForURLException;
import de.cismet.security.exceptions.RequestFailedException;
import de.cismet.security.handler.DefaultHTTPAccessHandler;
import de.cismet.security.handler.FTPAccessHandler;
import de.cismet.security.handler.HTTPBasedAccessHandler;
import de.cismet.security.handler.SecondaryJksSSLSocketFactory;
import de.cismet.security.handler.WSSAccessHandler;
import java.awt.Component;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class WebAccessManager
implements AccessHandler,
TunnelStore,
ExtendedAccessHandler,
ProxyHandler.Listener {
    private static final Logger LOG = Logger.getLogger(WebAccessManager.class);
    private static WebAccessManager instance = null;
    private static final ReentrantReadWriteLock reLock = new ReentrantReadWriteLock();
    private static final Lock readLock = reLock.readLock();
    private static final Lock writeLock = reLock.writeLock();
    private static String jws;
    private final HashMap<URL, AccessHandler> handlerMapping = new HashMap();
    private final HashMap<AccessHandler.ACCESS_HANDLER_TYPES, AccessHandler> allHandlers = new HashMap();
    private AccessHandler defaultHandler;
    private final Properties serverAliasProps = new Properties();
    private Component topLevelComponent = null;
    private Tunnel tunnel = null;

    private WebAccessManager() {
        Proxy proxy = ProxyHandler.getInstance().getProxy();
        this.initHandlers(proxy);
        this.setProxy(proxy);
        ProxyHandler.getInstance().addListener((ProxyHandler.Listener)this);
        try (InputStream jksInputStream = this.getClass().getClassLoader().getResourceAsStream("de/cismet/security/secondary.jks");
             InputStream pwInputStream = this.getClass().getClassLoader().getResourceAsStream("de/cismet/security/secondary.pw");){
            if (jksInputStream != null && pwInputStream != null) {
                String pw = IOUtils.toString((InputStream)pwInputStream, (String)"UTF-8");
                Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new SecondaryJksSSLSocketFactory(jksInputStream, pw), 443));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    public void proxyChanged(ProxyHandler.Event event) {
        this.setProxy(event.getNewProxy());
    }

    private void setProxy(Proxy proxy) {
        for (AccessHandler accessHandler : this.allHandlers.values()) {
            if (!(accessHandler instanceof ProxyCabaple)) continue;
            ((ProxyCabaple)accessHandler).setProxy(proxy);
        }
    }

    public void resetWSSCredentials() {
        AccessHandler wssHandler = this.allHandlers.get(AccessHandler.ACCESS_HANDLER_TYPES.WSS);
        if (wssHandler != null && wssHandler instanceof WSSAccessHandler) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"reset WSS credentials");
            }
            ((WSSAccessHandler)wssHandler).resetCredentials();
        }
    }

    public void resetCredentials() {
        for (AccessHandler wmsHandler : this.allHandlers.values()) {
            if (wmsHandler == null || !(wmsHandler instanceof HTTPBasedAccessHandler)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"reset credentials");
            }
            ((HTTPBasedAccessHandler)wmsHandler).resetCredentials();
        }
    }

    public Proxy getHttpProxy() {
        AccessHandler httpHandler = this.allHandlers.get(AccessHandler.ACCESS_HANDLER_TYPES.HTTP);
        if (httpHandler != null && httpHandler instanceof HTTPBasedAccessHandler) {
            return ((HTTPBasedAccessHandler)httpHandler).getProxy();
        }
        AccessHandler wssHandler = this.allHandlers.get(AccessHandler.ACCESS_HANDLER_TYPES.WSS);
        if (wssHandler != null && wssHandler instanceof WSSAccessHandler) {
            return ((WSSAccessHandler)wssHandler).getProxy();
        }
        return null;
    }

    private void initHandlers(Proxy proxy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"initHandlers");
        }
        this.allHandlers.put(AccessHandler.ACCESS_HANDLER_TYPES.HTTP, (AccessHandler)new DefaultHTTPAccessHandler(proxy));
        this.allHandlers.put(AccessHandler.ACCESS_HANDLER_TYPES.WSS, (AccessHandler)new WSSAccessHandler(proxy));
        this.allHandlers.put(AccessHandler.ACCESS_HANDLER_TYPES.FTP, (AccessHandler)new FTPAccessHandler(proxy));
        this.defaultHandler = this.allHandlers.get(AccessHandler.ACCESS_HANDLER_TYPES.HTTP);
    }

    public AccessHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(AccessHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public static WebAccessManager getInstance() {
        if (instance != null) {
            return instance;
        }
        WebAccessManager.createInstance();
        return instance;
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new WebAccessManager();
        }
    }

    public static void setJwsToken(String jws) {
        WebAccessManager.jws = jws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean registerAccessHandler(URL url, AccessHandler.ACCESS_HANDLER_TYPES handlerType) {
        writeLock.lock();
        try {
            if (this.handlerMapping.get(url) == null && this.allHandlers.get(handlerType) != null) {
                this.handlerMapping.put(url, this.allHandlers.get(handlerType));
                boolean bl = true;
                return bl;
            }
            if (this.deregisterAccessHandler(url)) {
                if (this.allHandlers.get(handlerType) != null) {
                    this.handlerMapping.put(url, this.allHandlers.get(handlerType));
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public synchronized boolean deregisterAccessHandler(URL url) {
        writeLock.lock();
        try {
            if (this.handlerMapping.containsKey(url)) {
                this.handlerMapping.remove(url);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean isHandlerForURLRegistered(URL url) {
        readLock.lock();
        try {
            boolean bl = this.handlerMapping.get(url) != null;
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public AccessHandler getHandlerForURL(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AccessHandler.ACCESS_HANDLER_TYPES getTypeOfHandler(URL url) {
        AccessHandler accessHandler = this.handlerMapping.get(url);
        if (accessHandler != null) {
            return accessHandler.getHandlerType();
        }
        return null;
    }

    public InputStream doRequest(URL url) throws MissingArgumentException, AccessMethodIsNotSupportedException, RequestFailedException, NoHandlerForURLException, Exception {
        String requestParameter;
        URL serviceURL;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("URL: " + url + "... trying to retrieve parameters automatically by HTTP_GET"));
        }
        try {
            String urlString = url.toString();
            if (urlString.indexOf(63) != -1) {
                serviceURL = new URL(urlString.substring(0, urlString.indexOf(63)));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("service URL: " + serviceURL));
                }
                if (urlString.indexOf(63) + 1 < urlString.length()) {
                    requestParameter = urlString.substring(urlString.indexOf(63) + 1, urlString.length());
                    if (requestParameter.toLowerCase().contains("service=wss")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"query default WMS");
                        }
                        requestParameter = "REQUEST=GetCapabilities&service=WMS";
                    }
                } else {
                    requestParameter = "";
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("requestParameter: " + requestParameter));
                }
            } else {
                LOG.warn((Object)"Not able to parse requestparameter (no ?) trying without");
                serviceURL = url;
                requestParameter = "";
            }
        }
        catch (Exception ex) {
            String errorMessage = "Request parameters coud not be parsed: " + ex.getMessage();
            LOG.error((Object)errorMessage);
            throw new RequestFailedException(errorMessage, ex);
        }
        return this.doRequest(serviceURL, new StringReader(requestParameter), AccessHandler.ACCESS_METHODS.GET_REQUEST);
    }

    public InputStream doRequest(URL url, String requestParameter, AccessHandler.ACCESS_METHODS accessMethod) throws MissingArgumentException, AccessMethodIsNotSupportedException, RequestFailedException, NoHandlerForURLException, Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Requestparameter: " + requestParameter));
        }
        return this.doRequest(url, new StringReader(requestParameter), accessMethod);
    }

    public InputStream doRequest(URL url, Reader requestParameter, AccessHandler.ACCESS_METHODS accessMethod) throws MissingArgumentException, AccessMethodIsNotSupportedException, RequestFailedException, NoHandlerForURLException, Exception {
        return this.doRequest(url, requestParameter, accessMethod, null);
    }

    public InputStream doRequest(URL url, Reader requestParameter, AccessHandler.ACCESS_METHODS accessMethod, HashMap<String, String> options) throws MissingArgumentException, AccessMethodIsNotSupportedException, RequestFailedException, NoHandlerForURLException, Exception {
        readLock.lock();
        if (url == null) {
            throw new MissingArgumentException("URL is null.");
        }
        if (accessMethod == null) {
            LOG.warn((Object)"No access method specified. Calling handler's default method.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Request URL: '" + url.toString() + "'."));
        }
        try {
            AccessHandler handler = this.handlerMapping.get(url);
            if (handler != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Handler for URL '" + url + "' available."));
                }
                if (handler.isAccessMethodSupported(accessMethod)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Handler supports access method '" + accessMethod + "'."));
                    }
                    InputStream inputStream = handler.doRequest(WebAccessManager.getUrlWithCredentials(url), requestParameter, accessMethod, options);
                    return inputStream;
                }
                throw new AccessMethodIsNotSupportedException("The access method '" + accessMethod + "' is not supported by handler '" + handler.getClass() + "'.");
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"No handler for URL available. Using DefaultHandler.");
            }
            if (this.defaultHandler != null) {
                InputStream inputStream = this.defaultHandler.doRequest(WebAccessManager.getUrlWithCredentials(url), requestParameter, accessMethod, options);
                return inputStream;
            }
            throw new NoHandlerForURLException("No default handler available.");
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Releasing lock.");
            }
            readLock.unlock();
        }
    }

    public static URL getUrlWithCredentials(URL url) {
        if (jws != null) {
            try {
                return new URL(url.toString().replace("$(user-jwt)", jws));
            }
            catch (MalformedURLException e) {
                return url;
            }
        }
        return url;
    }

    public InputStream doRequest(URL url, InputStream requestParameter, HashMap<String, String> options) throws MissingArgumentException, AccessMethodIsNotSupportedException, RequestFailedException, NoHandlerForURLException, Exception {
        readLock.lock();
        if (url == null) {
            throw new MissingArgumentException("URL is null.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Request URL: '" + url.toString() + "'."));
        }
        try {
            AccessHandler handler = this.handlerMapping.get(url);
            if (handler != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Handler for URL '" + url + "' available."));
                }
                if (handler.isAccessMethodSupported(AccessHandler.ACCESS_METHODS.POST_REQUEST)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Handler supports access method + '" + AccessHandler.ACCESS_METHODS.POST_REQUEST + "'."));
                    }
                    InputStream inputStream = handler.doRequest(WebAccessManager.getUrlWithCredentials(url), requestParameter, options);
                    return inputStream;
                }
                throw new AccessMethodIsNotSupportedException("The access method '" + AccessHandler.ACCESS_METHODS.POST_REQUEST + "' is not supported by handler '" + handler.getClass() + "'.");
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"No handler for URL available. Using default handler.");
            }
            if (this.defaultHandler != null) {
                InputStream inputStream = this.defaultHandler.doRequest(WebAccessManager.getUrlWithCredentials(url), requestParameter, options);
                return inputStream;
            }
            try {
                throw new NoHandlerForURLException("No default handler available.");
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while doRequest.", (Throwable)ex);
                throw ex;
            }
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Releasing lock.");
            }
            readLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkIfURLaccessible(URL url) {
        boolean urlAccessible = false;
        try (InputStream inputStream = this.doRequest(url, "", AccessHandler.ACCESS_METHODS.HEAD_REQUEST);){
            boolean bl = inputStream != null;
            return bl;
        }
        catch (MissingArgumentException ex) {
            if (!LOG.isDebugEnabled()) return false;
            LOG.debug((Object)("Could not read document from URL '" + url.toExternalForm() + "'."), (Throwable)ex);
            return false;
        }
        catch (AccessMethodIsNotSupportedException ex) {
            if (!LOG.isDebugEnabled()) return false;
            LOG.debug((Object)("Can't access document URL '" + url.toExternalForm() + "' with default access method."), (Throwable)ex);
            return false;
        }
        catch (RequestFailedException ex) {
            if (!LOG.isDebugEnabled()) return false;
            LOG.debug((Object)("Requesting document from URL '" + url.toExternalForm() + "' failed."), (Throwable)ex);
            return false;
        }
        catch (NoHandlerForURLException ex) {
            if (!LOG.isDebugEnabled()) return false;
            LOG.debug((Object)("Can't handle URL '" + url.toExternalForm() + "'."), (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            if (!LOG.isDebugEnabled()) return false;
            LOG.debug((Object)("An exception occurred while opening URL '" + url.toExternalForm() + "'."), (Throwable)ex);
        }
        return false;
    }

    public void addServerAliasProperty(String key, String value) {
        this.serverAliasProps.put(key, value);
    }

    public String getServerAliasProperty(String key) {
        return this.serverAliasProps.getProperty(key);
    }

    public Component getTopLevelComponent() {
        return this.topLevelComponent;
    }

    public void setTopLevelComponent(Component topLevelComponent) {
        this.topLevelComponent = topLevelComponent;
    }

    public AccessHandler.ACCESS_HANDLER_TYPES getHandlerType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAccessMethodSupported(AccessHandler.ACCESS_METHODS method) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Tunnel getTunnel() {
        return this.tunnel;
    }

    public void setTunnel(Tunnel tunnel) {
        this.tunnel = tunnel;
        Collection<AccessHandler> c = this.allHandlers.values();
        for (AccessHandler a : c) {
            if (!(a instanceof TunnelStore)) continue;
            ((TunnelStore)a).setTunnel(tunnel);
        }
        if (!c.contains(this.defaultHandler) && this.defaultHandler instanceof TunnelStore) {
            ((TunnelStore)this.defaultHandler).setTunnel(tunnel);
        }
    }

    public static void main(String[] args) throws Exception {
        WebAccessManager.getInstance().setProxy(new Proxy(true, "localhost", 9090, null, "102-cismet", "Irgendwas 2021!", "stadt"));
        System.out.println(IOUtils.toString((InputStream)WebAccessManager.getInstance().doRequest(new URL("https://boxy.cismet.de")), (String)"UTF-8"));
    }
}

