/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.security.handler;

import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.security.Tunnel;
import de.cismet.commons.security.handler.AbstractAccessHandler;
import de.cismet.netutil.Proxy;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.log4j.Logger;

public class FTPAccessHandler
extends AbstractAccessHandler {
    private static final Logger LOG = Logger.getLogger(FTPAccessHandler.class);
    public static final AccessHandler.ACCESS_HANDLER_TYPES ACCESS_HANDLER_TYPE = AccessHandler.ACCESS_HANDLER_TYPES.FTP;
    public static AccessHandler.ACCESS_METHODS[] SUPPORTED_ACCESS_METHODS = new AccessHandler.ACCESS_METHODS[]{AccessHandler.ACCESS_METHODS.GET_REQUEST};
    private transient Proxy proxy;
    private Tunnel tunnel = null;

    public FTPAccessHandler(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean isAccessMethodSupported(AccessHandler.ACCESS_METHODS method) {
        for (AccessHandler.ACCESS_METHODS curMethod : SUPPORTED_ACCESS_METHODS) {
            if (curMethod != method) continue;
            return true;
        }
        return false;
    }

    public AccessHandler.ACCESS_HANDLER_TYPES getHandlerType() {
        return ACCESS_HANDLER_TYPE;
    }

    public InputStream doRequest(URL url, Reader requestParameter, AccessHandler.ACCESS_METHODS method, HashMap<String, String> options) throws Exception {
        String currentLine;
        FTPClient ftpClient = this.getConfiguredFTPClient();
        StringBuilder parameter = new StringBuilder();
        BufferedReader reader = new BufferedReader(requestParameter);
        while ((currentLine = reader.readLine()) != null) {
            parameter.append(currentLine);
        }
        if (this.tunnel != null && (method == AccessHandler.ACCESS_METHODS.GET_REQUEST || method == AccessHandler.ACCESS_METHODS.POST_REQUEST || method == AccessHandler.ACCESS_METHODS.HEAD_REQUEST) && this.tunnel.isResponsible(method, url.toString())) {
            return this.tunnel.doRequest(url, (Reader)new StringReader(parameter.toString()), method, options);
        }
        int port = url.getPort() != -1 ? url.getPort() : url.getDefaultPort();
        ftpClient.connect(url.getHost(), port);
        if (url.getUserInfo() != null) {
            String[] user_password = url.getUserInfo().split(":");
            String password = "";
            if (user_password.length > 1) {
                password = user_password[1];
            }
            ftpClient.login(user_password[0], password);
        } else {
            ftpClient.login("anonymous", "");
        }
        ftpClient.enterLocalPassiveMode();
        ftpClient.setFileType(2);
        return ftpClient.retrieveFileStream(url.getPath());
    }

    public InputStream doRequest(URL url, InputStream requestParameter, HashMap<String, String> options) throws Exception {
        LOG.fatal((Object)"FTPAccessHandler.doRequest: Not supported yet.", (Throwable)new Exception());
        return null;
    }

    protected FTPClient getConfiguredFTPClient() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getConfiguredFTPClient");
        }
        FTPClient client = new FTPClient();
        FTPClientConfig config = new FTPClientConfig();
        if (this.proxy != null) {
            if (this.proxy.getUsername() != null && this.proxy.getPassword() != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        PasswordAuthentication p = new PasswordAuthentication(FTPAccessHandler.this.proxy.getUsername(), FTPAccessHandler.this.proxy.getPassword().toCharArray());
                        return p;
                    }
                });
            }
            java.net.Proxy proxyfo = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxy.getHost(), this.proxy.getPort()));
            client.setProxy(proxyfo);
        }
        client.configure(config);
        return client;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Tunnel getTunnel() {
        return this.tunnel;
    }

    public void setTunnel(Tunnel tunnel) {
        this.tunnel = tunnel;
    }
}

