/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.security.handler;

import de.cismet.commons.security.handler.AbstractAccessHandler;
import de.cismet.commons.security.handler.ProxyCabaple;
import de.cismet.netutil.Proxy;
import de.cismet.security.GUICredentialsProvider;
import de.cismet.security.WebAccessManager;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.log4j.Logger;

public abstract class HTTPBasedAccessHandler
extends AbstractAccessHandler
implements ProxyCabaple {
    private static final transient Logger LOG = Logger.getLogger(HTTPBasedAccessHandler.class);
    private final transient Map<String, GUICredentialsProvider> httpCredentialsForURLS;
    private transient Proxy proxy;

    protected HTTPBasedAccessHandler(Proxy proxy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"HTTPBasedAccessHandler");
        }
        this.httpCredentialsForURLS = new HashMap<String, GUICredentialsProvider>();
        this.proxy = proxy;
    }

    protected HttpClient getConfiguredHttpClientForUrl(URL url) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getConfiguredHttpClient");
        }
        HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        if (this.proxy != null && this.proxy.getHost() != null && this.proxy.getPort() > 0 && this.proxy.isValid() && this.proxy.isEnabledFor(url != null ? url.getHost() : null)) {
            client.getHostConfiguration().setProxy(this.proxy.getHost(), this.proxy.getPort());
            if (this.proxy.getUsername() != null && this.proxy.getPassword() != null) {
                AuthScope authscope = new AuthScope(this.proxy.getHost(), this.proxy.getPort());
                NTCredentials credentials = new NTCredentials(this.proxy.getUsername(), this.proxy.getPassword(), "", this.proxy.getDomain() == null ? "" : this.proxy.getDomain());
                client.getState().setProxyCredentials(authscope, (Credentials)credentials);
            }
        }
        return client;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    protected HttpClient getSecurityEnabledHttpClient(URL url) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getSecurityEnabledHttpClient");
        }
        HttpClient client = this.getConfiguredHttpClientForUrl(url);
        client.getParams().setParameter("http.authentication.credential-provider", (Object)this.getCredentialProvider(url));
        return client;
    }

    protected CredentialsProvider getCredentialProvider(URL url) {
        GUICredentialsProvider cp;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving Credential Provider for url: " + url));
        }
        if ((cp = this.getHttpCredentialProviderURL(url)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("no Credential Provider available for url: " + url));
            }
            cp = this.createSynchronizedCP(url);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Credential Provider available for url: " + url));
        }
        return cp;
    }

    public GUICredentialsProvider getHttpCredentialProviderURL(URL url) {
        GUICredentialsProvider cp = this.httpCredentialsForURLS.get(url.toString());
        return cp;
    }

    public synchronized GUICredentialsProvider createSynchronizedCP(URL url) {
        GUICredentialsProvider cp;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Credential Provider should be created synchronously");
        }
        if ((cp = this.httpCredentialsForURLS.get(url.toString())) == null) {
            cp = new GUICredentialsProvider(url, WebAccessManager.getInstance().getTopLevelComponent());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("A new Credential Provider instance was created for: " + url.toString()));
            }
            this.httpCredentialsForURLS.put(url.toString(), cp);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Credential Provider was already available: " + url.toString()));
        }
        return cp;
    }

    public void resetCredentials() {
        for (GUICredentialsProvider prov : this.httpCredentialsForURLS.values()) {
            prov.setUsernamePassword(null);
        }
        this.httpCredentialsForURLS.clear();
    }
}

