/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.security.handler;

import de.cismet.commons.security.AccessHandler;
import de.cismet.netutil.Proxy;
import de.cismet.security.PasswordDialog;
import de.cismet.security.WebAccessManager;
import de.cismet.security.handler.HTTPBasedAccessHandler;
import de.cismet.tools.gui.StaticSwingTools;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.environmatics.acs.accessor.WSSAccessorDeegree;
import net.environmatics.acs.accessor.interfaces.AuthenticationMethod;
import net.environmatics.acs.accessor.interfaces.SessionInformation;
import net.environmatics.acs.accessor.methods.PasswordAuthenticationMethod;
import net.environmatics.acs.exceptions.AuthenticationFailedException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.log4j.Logger;

public class WSSAccessHandler
extends HTTPBasedAccessHandler {
    public static AccessHandler.ACCESS_METHODS[] SUPPORTED_ACCESS_METHODS = new AccessHandler.ACCESS_METHODS[]{AccessHandler.ACCESS_METHODS.GET_REQUEST, AccessHandler.ACCESS_METHODS.POST_REQUEST};
    public static final AccessHandler.ACCESS_HANDLER_TYPES ACCESS_HANDLER_TYPE = AccessHandler.ACCESS_HANDLER_TYPES.WSS;
    private static final HashMap<URL, WSSAccessorDeegree> wssAccessorMapping = new HashMap();
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private ReentrantLock lock = new ReentrantLock();

    public WSSAccessHandler(Proxy proxy) {
        super(proxy);
    }

    public InputStream doRequest(URL url, InputStream requestParameter, HashMap<String, String> options) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAccessMethodSupported(AccessHandler.ACCESS_METHODS method) {
        for (AccessHandler.ACCESS_METHODS curMethod : SUPPORTED_ACCESS_METHODS) {
            if (curMethod != method) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resetCredentials() {
        super.resetCredentials();
        wssAccessorMapping.clear();
    }

    public AccessHandler.ACCESS_HANDLER_TYPES getHandlerType() {
        return ACCESS_HANDLER_TYPE;
    }

    public InputStream doRequest(URL url, Reader requestParameter, AccessHandler.ACCESS_METHODS method, HashMap<String, String> options) throws Exception {
        Proxy proxy;
        WSSAccessorDeegree accessor;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("doRequest: " + url));
        }
        if ((accessor = wssAccessorMapping.get(url)) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("no WSSAccessor for URL: " + url));
            }
            accessor = this.createNewWSSAccessor(url);
        }
        if ((proxy = this.getProxy()) != null) {
            accessor.setProxy(proxy.getHost(), proxy.getPort());
        } else {
            accessor.setProxy(null, -1);
        }
        String accessMethod = null;
        switch (method) {
            case POST_REQUEST: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"wss accessmethod ist post");
                }
                accessMethod = "HTTP_POST";
                break;
            }
            case GET_REQUEST: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"wss accessmethod ist get");
                }
                accessMethod = "HTTP_GET";
                break;
            }
            default: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Keine Methode spezifiziert default: " + AccessHandler.ACCESS_METHODS.POST_REQUEST));
                }
                accessMethod = "HTTP_POST";
            }
        }
        StringBuffer parameter = new StringBuffer();
        BufferedReader reader = new BufferedReader(requestParameter);
        String currentLine = null;
        while ((currentLine = reader.readLine()) != null) {
            parameter.append(currentLine);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("WSSRequestParameter: " + parameter.toString()));
            this.log.debug((Object)("using facade URL: " + url.toString()));
        }
        return new ByteArrayInputStream(accessor.doService(accessMethod, parameter.toString(), url.toString()).asBytes());
    }

    private synchronized WSSAccessorDeegree createNewWSSAccessor(URL url) throws Exception {
        WSSAccessorDeegree testAccessor;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"createNewWSSAccessor");
        }
        if ((testAccessor = wssAccessorMapping.get(url)) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"accessor f\u00fcr URL wird angelegt");
            }
            WSSAccessorDeegree accessor = new WSSAccessorDeegree();
            accessor.setWSS(url.toString());
            this.authenticate(accessor);
            wssAccessorMapping.put(url, accessor);
            accessor.setCredentialProvider(this.getCredentialProvider(url));
            return accessor;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"accessor f\u00fcr URL ist schon vorhanden");
        }
        return testAccessor;
    }

    public String getSecuredServiceTypeForURL(URL url) throws Exception {
        WSSAccessorDeegree accessor = wssAccessorMapping.get(url);
        if (accessor == null) {
            accessor = this.createNewWSSAccessor(url);
            return accessor.getSecuredServiceType();
        }
        return accessor.getSecuredServiceType();
    }

    private synchronized void authenticate(WSSAccessorDeegree accessor) throws Exception {
        if (!accessor.isSessionAvailable()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Keine Session Informationen f\u00fcr url: " + accessor.getWSS() + " vorhanden --> Passwordfenster"));
            }
            WSSPasswordDialog dialog = new WSSPasswordDialog(accessor);
            dialog.getCredentials();
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Session infromationen vorhanden --> ist schon authentifiziert");
        }
    }

    public String createGetRequest(String request) throws Exception {
        WSSAccessorDeegree accessor;
        URL baseURL = null;
        String requestString = null;
        if (request.indexOf(63) != -1) {
            baseURL = new URL(request.substring(0, request.indexOf(63)));
            requestString = request.substring(request.indexOf(63) + 1);
        } else {
            baseURL = new URL(request);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Urlbase: " + baseURL.toString()));
            this.log.debug((Object)("Requestparameter: " + requestString));
        }
        if ((accessor = wssAccessorMapping.get(baseURL)) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"there is no accessor for the given url");
            }
            return null;
        }
        SessionInformation si = accessor.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("session information" + si.getSessionID()));
        }
        requestString = requestString + "&sessionID=" + si.getSessionID();
        StringBuffer sb = new StringBuffer(2000);
        sb.append(baseURL).append("?service=WSS&request=DoService&version=1.0.0&");
        sb.append("AUTHMETHOD=urn:x-gdi-nrw:authnMethod:1.0:session&");
        sb.append("DCP=http_get&");
        sb.append("CREDENTIALS=").append(si.getSessionID()).append("&");
        sb.append("SERVICEREQUEST=").append(URLEncoder.encode(requestString, this.getSystemCharset()));
        return sb.toString();
    }

    public String getSystemCharset() {
        String charset = null;
        try {
            charset = System.getProperty("CHARSET");
        }
        catch (Exception exc) {
            this.log.error((Object)"Error retrieving system property CHARSET", (Throwable)exc);
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        this.log.error((Object)("Using system charset: " + charset));
        return charset;
    }

    class WSSPasswordDialog
    extends PasswordDialog {
        WSSAccessorDeegree wssac;
        private final Logger log;
        private String sInfo;

        public WSSPasswordDialog(WSSAccessorDeegree accessor) {
            super(accessor.getWSSURL(), StaticSwingTools.getParentFrame(WebAccessManager.getInstance().getTopLevelComponent()));
            this.log = Logger.getLogger(((Object)((Object)this)).getClass());
            this.wssac = accessor;
        }

        @Override
        public boolean authenticate(String name, char[] password, String server) throws Exception {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Authentication with username: " + name));
            }
            try {
                PasswordAuthenticationMethod authMethod = new PasswordAuthenticationMethod(name + "," + new String(password));
                this.sInfo = this.wssac.getSession((AuthenticationMethod)authMethod).getSessionID();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Authentication successful for WSS " + this.url.toString() + " New SesionID:" + this.sInfo));
                }
                this.usernames.removeUserName(name);
                this.usernames.saveUserNames();
                this.usernames.addUserName(name);
                this.usernames.saveUserNames();
                this.isAuthenticationDone = true;
                this.setUsernamePassword(new UsernamePasswordCredentials(name, new String(password)));
                return true;
            }
            catch (AuthenticationFailedException ex) {
                this.log.error((Object)("Authentication failed for WSS: " + this.url.toString()), (Throwable)ex);
                return false;
            }
        }
    }

    public static enum SECURED_SERVICE_TYPE {
        WMS,
        WFS;

    }
}

