/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.options.GeneralOptionsCategory;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.configuration.NoWriteError;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class BrowserLauncherOptionsPanel
extends AbstractOptionsPanel
implements ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(BrowserLauncherOptionsPanel.class);
    private static final String CONFIGURATION = "BrowserLauncherOptionsPanel";
    private static final String CONF_CUSTOM_CMD = "CustomCmd";
    private boolean browserCmdEnabled = false;
    private String browserCmd = null;
    private boolean stillConfigured = false;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Box.Filler filler1;
    private JCheckBox jCheckBox1;
    private JTextField jTextField1;
    private JLabel lblIntervall;
    private JLabel lblSeconds;
    private BindingGroup bindingGroup;

    public BrowserLauncherOptionsPanel() {
        super(NbBundle.getMessage(BrowserLauncherOptionsPanel.class, (String)"BrowserLauncherOptionsPanel.title"), GeneralOptionsCategory.class);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        try {
            this.initComponents();
        }
        catch (Exception e) {
            LOG.error((Object)"Erro during Creation of Password Dialog", (Throwable)e);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.lblSeconds = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.lblIntervall = new JLabel();
        this.jTextField1 = new JTextField();
        this.jCheckBox1 = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setMaximumSize(new Dimension(264, 177));
        this.setMinimumSize(new Dimension(100, 177));
        this.setLayout(new GridBagLayout());
        this.lblSeconds.setFont(new Font("Noto Sans", 2, 12));
        this.lblSeconds.setText(NbBundle.getMessage(BrowserLauncherOptionsPanel.class, (String)"BrowserLauncherOptionsPanel.lblSeconds.text"));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jCheckBox1, (Property)ELProperty.create((String)"${selected}"), (Object)this.lblSeconds, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.lblSeconds, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.filler1, gridBagConstraints);
        this.lblIntervall.setText(NbBundle.getMessage(BrowserLauncherOptionsPanel.class, (String)"BrowserLauncherOptionsPanel.lblIntervall.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jCheckBox1, (Property)ELProperty.create((String)"${selected}"), (Object)this.lblIntervall, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.lblIntervall, gridBagConstraints);
        this.jTextField1.setText(NbBundle.getMessage(BrowserLauncherOptionsPanel.class, (String)"BrowserLauncherOptionsPanel.jTextField1.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jCheckBox1, (Property)ELProperty.create((String)"${selected}"), (Object)this.jTextField1, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jTextField1, gridBagConstraints);
        this.jCheckBox1.setText(NbBundle.getMessage(BrowserLauncherOptionsPanel.class, (String)"BrowserLauncherOptionsPanel.jCheckBox1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jCheckBox1, gridBagConstraints);
        this.bindingGroup.bind();
    }

    @Override
    public void update() {
        this.browserCmd = BrowserLauncher.getCustomBrowserCmd();
        this.browserCmdEnabled = this.browserCmd != null;
        this.updateGui();
    }

    @Override
    public void applyChanges() {
        this.browserCmd = this.jTextField1.getText();
        this.browserCmdEnabled = this.jCheckBox1.isSelected();
        if (this.browserCmdEnabled) {
            BrowserLauncher.setCustomBrowserCmd((String)this.browserCmd);
        }
    }

    @Override
    public boolean isChanged() {
        String test;
        String string = test = this.jCheckBox1.isSelected() ? this.jTextField1.getText() : null;
        return test == null ? this.browserCmd != null : !test.equals(this.browserCmd);
    }

    private void updateGui() {
        this.jCheckBox1.setSelected(this.browserCmdEnabled);
        this.jTextField1.setText(this.browserCmd);
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(BrowserLauncherOptionsPanel.class, (String)"BrowserLauncherOptionsPanel.tooltip");
    }

    @Override
    public void configure(Element parent) {
        if (!this.stillConfigured) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Configure BrowserLauncherOptionsPanel");
            }
            try {
                Element conf;
                String browserCmd = null;
                if (parent != null && (conf = parent.getChild(CONFIGURATION)) != null) {
                    browserCmd = conf.getChildText(CONF_CUSTOM_CMD);
                }
                this.browserCmd = browserCmd;
                this.browserCmdEnabled = browserCmd != null;
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim Konfigurieren des BrowserLauncherOptionsPanel", (Throwable)ex);
            }
            this.updateGui();
            this.stillConfigured = true;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"skip Configure GeometryOptionsPanel - still configured");
        }
        this.applyChanges();
    }

    @Override
    public Element getConfiguration() throws NoWriteError {
        Element conf = new Element(CONFIGURATION);
        if (this.browserCmdEnabled) {
            Element cmdElement = new Element(CONF_CUSTOM_CMD);
            cmdElement.addContent(this.browserCmd);
            conf.addContent((Content)cmdElement);
        }
        return conf;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

