/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class CellSpecificRenderedTable
extends JXTable {
    private Map<Integer, TableCellRenderer> rowRenderer = new HashMap<Integer, TableCellRenderer>();
    private Map<TablePosition, TableCellRenderer> customCellRenderer = new HashMap<TablePosition, TableCellRenderer>();
    private Map<Integer, TableCellEditor> rowEditor = new HashMap<Integer, TableCellEditor>();
    private Map<TablePosition, TableCellEditor> customCellEditor = new HashMap<TablePosition, TableCellEditor>();

    public void addRowRenderer(int row, TableCellRenderer renderer) {
        this.rowRenderer.put(row, renderer);
    }

    public void addCellRenderer(int column, int row, TableCellRenderer renderer) {
        this.customCellRenderer.put(new TablePosition(column, row), renderer);
    }

    public void addRowEditor(int row, TableCellEditor editor) {
        this.rowEditor.put(row, editor);
    }

    public void addCellEditor(int column, int row, TableCellEditor editor) {
        this.customCellEditor.put(new TablePosition(column, row), editor);
    }

    public void removeAllCellRenderers() {
        this.customCellRenderer.clear();
    }

    public void removeAllCellEditors() {
        this.customCellEditor.clear();
    }

    public void removeCellRenderer(int column, int row) {
        this.customCellRenderer.remove(new TablePosition(column, row));
    }

    public void removeCellEditor(int column, int row) {
        this.customCellEditor.remove(new TablePosition(column, row));
    }

    public void removeRowRenderer(int row) {
        this.rowRenderer.remove(row);
    }

    public void removeRowEditor(int row) {
        this.rowEditor.remove(row);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer customRenderer = this.customCellRenderer.get(new TablePosition(column, row));
        if (customRenderer == null) {
            customRenderer = this.rowRenderer.get(row);
        }
        if (customRenderer != null) {
            return customRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor customEditor = this.customCellEditor.get(new TablePosition(column, row));
        if (customEditor == null) {
            customEditor = this.rowEditor.get(row);
        }
        if (customEditor != null) {
            return customEditor;
        }
        return super.getCellEditor(row, column);
    }

    class TablePosition {
        private int column;
        private int row;

        public TablePosition(int column, int row) {
            this.column = column;
            this.row = row;
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TablePosition) {
                TablePosition other = (TablePosition)obj;
                return this.row == other.row && this.column == other.column;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + this.column;
            hash = 97 * hash + this.row;
            return hash;
        }
    }
}

