/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.ContinueOrExitDialogAction;
import de.cismet.tools.gui.ContinueOrExitDialogActionEvent;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ContinueOrExitDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(ContinueOrExitDialog.class);
    private String contentTitle;
    private String content;
    private String continueButtonText;
    private String exitButtonText;
    private Integer contentWidth;
    private ContinueOrExitDialogAction action;
    private boolean showContinueButton = true;
    private boolean showExitButton = true;
    private JButton btnContinue;
    private JButton btnExit;
    private Box.Filler fllButtons;
    private JPanel panButtons;
    private JPanel panCenter;
    private JPanel panContent;
    private JPanel panMain;
    private JPanel panSouth;
    private JScrollPane scpContent;
    private JTextPane txpContent;

    public ContinueOrExitDialog() {
        this((Frame)null);
    }

    public ContinueOrExitDialog(Component component) {
        this(StaticSwingTools.getParentFrame(component));
    }

    public ContinueOrExitDialog(Frame parent) {
        super(parent, true);
    }

    public ContinueOrExitDialog(ContinueOrExitDialogAction action) {
        this((Frame)null, action);
    }

    public ContinueOrExitDialog(Component component, ContinueOrExitDialogAction action) {
        this(StaticSwingTools.getParentFrame(component), action);
    }

    public ContinueOrExitDialog(Frame parent, ContinueOrExitDialogAction action) {
        super(parent, true);
        this.action = action;
    }

    public ContinueOrExitDialog(Component parent, String contentTitle, String content, String continueButtonText, String exitButtonText) {
        this(parent);
        this.setContentTitle(contentTitle);
        this.setContent(content);
        this.setContinueButtonText(continueButtonText);
        this.setExitButtonText(exitButtonText);
    }

    public ContinueOrExitDialog(Frame parent, String contentTitle, String content, String continueButtonText, String exitButtonText) {
        this(parent);
        this.setContentTitle(contentTitle);
        this.setContent(content);
        this.setContinueButtonText(continueButtonText);
        this.setExitButtonText(exitButtonText);
    }

    public ContinueOrExitDialog(Frame parent, String contentTitle, String content, String continueButtonText, String exitButtonText, ContinueOrExitDialogAction action) {
        this(parent);
        this.setContentTitle(contentTitle);
        this.setContent(content);
        this.setContinueButtonText(continueButtonText);
        this.setExitButtonText(exitButtonText);
        this.setAction(action);
    }

    private void initComponents() {
        this.panMain = new JPanel();
        this.panCenter = new JPanel();
        this.panContent = new JPanel();
        this.scpContent = new JScrollPane();
        this.txpContent = new JTextPane();
        this.panSouth = new JPanel();
        this.fllButtons = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.panButtons = new JPanel();
        this.btnExit = new JButton();
        this.btnContinue = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(NbBundle.getMessage(ContinueOrExitDialog.class, (String)"ContinueOrExitDialog.title"));
        this.setAlwaysOnTop(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.panMain.setLayout(new BorderLayout());
        this.panCenter.setLayout(new GridBagLayout());
        this.panContent.setLayout(new GridBagLayout());
        this.scpContent.setBorder(null);
        this.txpContent.setEditable(false);
        this.txpContent.setContentType("text/html");
        this.txpContent.setOpaque(false);
        this.txpContent.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                ContinueOrExitDialog.this.txpContentHyperlinkUpdate(evt);
            }
        });
        this.scpContent.setViewportView(this.txpContent);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panContent.add((Component)this.scpContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panCenter.add((Component)this.panContent, gridBagConstraints);
        this.panMain.add((Component)this.panCenter, "Center");
        this.panSouth.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panSouth.add((Component)this.fllButtons, gridBagConstraints);
        this.panButtons.setLayout(new GridLayout(1, 0, 10, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.btnExit, (String)NbBundle.getMessage(ContinueOrExitDialog.class, (String)"ContinueOrExitDialog.btnExit.text"));
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContinueOrExitDialog.this.btnExitActionPerformed(evt);
            }
        });
        this.panButtons.add(this.btnExit);
        Mnemonics.setLocalizedText((AbstractButton)this.btnContinue, (String)NbBundle.getMessage(ContinueOrExitDialog.class, (String)"ContinueOrExitDialog.btnContinue.text"));
        this.btnContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContinueOrExitDialog.this.btnContinueActionPerformed(evt);
            }
        });
        this.panButtons.add(this.btnContinue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSouth.add((Component)this.panButtons, gridBagConstraints);
        this.panMain.add((Component)this.panSouth, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.panMain, gridBagConstraints);
        this.pack();
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        if (this.action != null) {
            this.action.actionPerformed(new ContinueOrExitDialogActionEvent(this, ContinueOrExitDialogActionEvent.Action.EXIT_ACTION));
        } else {
            this.doExit();
        }
    }

    private void btnContinueActionPerformed(ActionEvent evt) {
        if (this.action != null) {
            this.action.actionPerformed(new ContinueOrExitDialogActionEvent(this, ContinueOrExitDialogActionEvent.Action.CONTINUE_ACTION));
        } else {
            this.doContinue();
        }
    }

    private void txpContentHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                BrowserLauncher.openURL((String)evt.getDescription());
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    public final void doShow() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("%s.doShow()", ContinueOrExitDialog.class.getName()));
        }
        this.initComponents();
        this.setTitle(this.getContentTitle());
        this.txpContent.setText(this.getContent());
        this.panButtons.removeAll();
        if (this.getContinueButtonText() != null) {
            this.btnContinue.setText(this.getContinueButtonText());
            this.panButtons.add(this.btnContinue);
        }
        if (this.getExitButtonText() != null) {
            this.btnExit.setText(this.getExitButtonText());
            this.panButtons.add(this.btnExit);
        }
        this.pack();
        Dimension buttonExitSize = this.btnExit.getSize();
        Dimension buttonContinueSize = this.btnContinue.getSize();
        int buttonWidth = Math.max(buttonExitSize.width, buttonContinueSize.width);
        int buttonHeight = Math.max(buttonExitSize.height, buttonContinueSize.height);
        int minContentWidth = buttonWidth * 2 + 10;
        int maxContentWidth = 600;
        int contentWidth = Math.max(minContentWidth, this.contentWidth != null ? this.contentWidth : Math.min(buttonWidth * 3 + 10, 600));
        int contentHeight = ContinueOrExitDialog.determineHeight(this.txpContent, contentWidth);
        int maxDialogHeigth = 500;
        int dialogWidth = contentWidth + 40;
        int dialogHeight = Math.min(contentHeight + buttonHeight + 70, 500);
        this.setPreferredSize(new Dimension(dialogWidth, dialogHeight));
        this.pack();
        StaticSwingTools.showDialog(this, true);
    }

    private static int determineHeight(JEditorPane editorPaneOrig, int newWidth) {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setContentType(editorPaneOrig.getContentType());
        editorPane.setText(editorPaneOrig.getText());
        editorPane.setSize(new Dimension(newWidth, Integer.MAX_VALUE));
        return editorPane.getPreferredSize().height;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferred = super.getPreferredSize();
        Dimension maximum = this.getMaximumSize();
        int width = Math.min(preferred.width, maximum.width);
        int height = Math.min(preferred.height, maximum.height);
        return new Dimension(width, height);
    }

    private void doContinue() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("%s.doContinue()", ContinueOrExitDialog.class.getName()));
        }
        this.dispose();
    }

    private void doExit() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("%s.doExit()", ContinueOrExitDialog.class.getName()));
        }
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        String contentTitle = "LagIS - Wichtiger Hinweis";
        Font font = new JLabel().getFont();
        String test = "<p>Sie sind in einer Nutzergruppe, die ausschlie\u00dflich lesenden Zugriff auf die LagIS Daten hat. In Zukunft soll dazu die Applikation <a href='http://lagis-online.s10222.wuppertal-intra.de/lagis-desktop/#/login'>LagIS-Desktop</a> genutzt werden.</p><p>Sollten Sie Fragen zur Applikation haben, wenden Sie sich bitte an Ilmo Gimmler oder Michael Stosch.</p><p>F\u00fcr eine \u00dcbergangszeit ist die Java Anwendung noch verf\u00fcgbar.</p>";
        String content = String.format("<html><html><body style='font-family: %s; font-size: %dpt; margin: 0px'>%s", font.getFamily(), font.getSize(), "<p>Sie sind in einer Nutzergruppe, die ausschlie\u00dflich lesenden Zugriff auf die LagIS Daten hat. In Zukunft soll dazu die Applikation <a href='http://lagis-online.s10222.wuppertal-intra.de/lagis-desktop/#/login'>LagIS-Desktop</a> genutzt werden.</p><p>Sollten Sie Fragen zur Applikation haben, wenden Sie sich bitte an Ilmo Gimmler oder Michael Stosch.</p><p>F\u00fcr eine \u00dcbergangszeit ist die Java Anwendung noch verf\u00fcgbar.</p>");
        String continueButtonText = "Weiter mit der Java Anwendung";
        String exitButtonText = "Java Anwendung schlie\u00dfen";
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
        catch (Exception e) {
            LOG.warn((Object)"Fehler beim Einstellen des Look&Feels's!", (Throwable)e);
        }
        ContinueOrExitDialog instance = new ContinueOrExitDialog();
        instance.setContentTitle("LagIS - Wichtiger Hinweis");
        instance.setContent(content);
        instance.setContinueButtonText("Weiter mit der Java Anwendung");
        instance.setExitButtonText("Java Anwendung schlie\u00dfen");
        instance.setContentWidth(400);
        instance.doShow();
    }

    public String getContentTitle() {
        return this.contentTitle;
    }

    public String getContent() {
        return this.content;
    }

    public String getContinueButtonText() {
        return this.continueButtonText;
    }

    public String getExitButtonText() {
        return this.exitButtonText;
    }

    public Integer getContentWidth() {
        return this.contentWidth;
    }

    public ContinueOrExitDialogAction getAction() {
        return this.action;
    }

    public boolean isShowContinueButton() {
        return this.showContinueButton;
    }

    public boolean isShowExitButton() {
        return this.showExitButton;
    }

    public JButton getBtnContinue() {
        return this.btnContinue;
    }

    public JButton getBtnExit() {
        return this.btnExit;
    }

    public Box.Filler getFllButtons() {
        return this.fllButtons;
    }

    public JPanel getPanButtons() {
        return this.panButtons;
    }

    public JPanel getPanCenter() {
        return this.panCenter;
    }

    public JPanel getPanContent() {
        return this.panContent;
    }

    public JPanel getPanMain() {
        return this.panMain;
    }

    public JPanel getPanSouth() {
        return this.panSouth;
    }

    public JScrollPane getScpContent() {
        return this.scpContent;
    }

    public JTextPane getTxpContent() {
        return this.txpContent;
    }

    public void setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContinueButtonText(String continueButtonText) {
        this.continueButtonText = continueButtonText;
    }

    public void setExitButtonText(String exitButtonText) {
        this.exitButtonText = exitButtonText;
    }

    public void setContentWidth(Integer contentWidth) {
        this.contentWidth = contentWidth;
    }

    public void setAction(ContinueOrExitDialogAction action) {
        this.action = action;
    }

    public void setShowContinueButton(boolean showContinueButton) {
        this.showContinueButton = showContinueButton;
    }

    public void setShowExitButton(boolean showExitButton) {
        this.showExitButton = showExitButton;
    }

    public void setBtnContinue(JButton btnContinue) {
        this.btnContinue = btnContinue;
    }

    public void setBtnExit(JButton btnExit) {
        this.btnExit = btnExit;
    }

    public void setFllButtons(Box.Filler fllButtons) {
        this.fllButtons = fllButtons;
    }

    public void setPanButtons(JPanel panButtons) {
        this.panButtons = panButtons;
    }

    public void setPanCenter(JPanel panCenter) {
        this.panCenter = panCenter;
    }

    public void setPanContent(JPanel panContent) {
        this.panContent = panContent;
    }

    public void setPanMain(JPanel panMain) {
        this.panMain = panMain;
    }

    public void setPanSouth(JPanel panSouth) {
        this.panSouth = panSouth;
    }

    public void setScpContent(JScrollPane scpContent) {
        this.scpContent = scpContent;
    }

    public void setTxpContent(JTextPane txpContent) {
        this.txpContent = txpContent;
    }
}

