/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import de.cismet.tools.gui.StaticSwingTools;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CurvedFlowBackgroundPanel
extends JPanel {
    private int unten = 20;
    private int oben = 20;
    private double untenFraction = -1.0;
    private double obenFraction = -1.0;
    private boolean designMode;
    private boolean relativeHeights = false;

    public CurvedFlowBackgroundPanel() {
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2 && CurvedFlowBackgroundPanel.this.isDesignMode()) {
                    Frame parentFrame = StaticSwingTools.getParentFrame(CurvedFlowBackgroundPanel.this);
                    JDialog jd = new JDialog(parentFrame);
                    jd.setTitle(CurvedFlowBackgroundPanel.this.getClass().getName() + " Designer");
                    jd.getContentPane().setLayout(new BorderLayout());
                    jd.setDefaultCloseOperation(2);
                    final JSlider sliOben = new JSlider(0, 100);
                    final JSlider sliUnten = new JSlider(0, 100);
                    final JLabel lblInfo = new JLabel();
                    JButton cmdRefresh = new JButton("refresh");
                    final JCheckBox chkRelative = new JCheckBox("relativeHeight", CurvedFlowBackgroundPanel.this.isRelativeHeights());
                    chkRelative.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CurvedFlowBackgroundPanel.this.setRelativeHeights(chkRelative.isSelected());
                        }
                    });
                    sliOben.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            CurvedFlowBackgroundPanel.this.setOben((double)sliOben.getValue() / 100.0);
                            lblInfo.setText(CurvedFlowBackgroundPanel.this.getInfoString());
                        }
                    });
                    sliUnten.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            CurvedFlowBackgroundPanel.this.setUnten((double)sliUnten.getValue() / 100.0);
                            lblInfo.setText(CurvedFlowBackgroundPanel.this.getInfoString());
                        }
                    });
                    jd.getContentPane().add((Component)lblInfo, "Center");
                    jd.getContentPane().add((Component)sliOben, "North");
                    jd.getContentPane().add((Component)sliUnten, "South");
                    jd.getContentPane().add((Component)cmdRefresh, "East");
                    jd.getContentPane().add((Component)chkRelative, "West");
                    lblInfo.setText(CurvedFlowBackgroundPanel.this.getInfoString());
                    cmdRefresh.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            lblInfo.setText(CurvedFlowBackgroundPanel.this.getInfoString());
                        }
                    });
                    sliOben.setValue((int)((double)CurvedFlowBackgroundPanel.this.getOben() / (double)CurvedFlowBackgroundPanel.this.getHeight() * 100.0));
                    sliUnten.setValue((int)((double)CurvedFlowBackgroundPanel.this.getUnten() / (double)CurvedFlowBackgroundPanel.this.getHeight() * 100.0));
                    jd.pack();
                    StaticSwingTools.showDialog(jd);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                if (CurvedFlowBackgroundPanel.this.untenFraction < 0.0 || CurvedFlowBackgroundPanel.this.obenFraction < 0.0) {
                    CurvedFlowBackgroundPanel.this.untenFraction = (double)CurvedFlowBackgroundPanel.this.getUnten() / (double)CurvedFlowBackgroundPanel.this.getHeight();
                    CurvedFlowBackgroundPanel.this.obenFraction = (double)CurvedFlowBackgroundPanel.this.getOben() / (double)CurvedFlowBackgroundPanel.this.getHeight();
                }
                if (CurvedFlowBackgroundPanel.this.relativeHeights) {
                    CurvedFlowBackgroundPanel.this.setOben(CurvedFlowBackgroundPanel.this.obenFraction);
                    CurvedFlowBackgroundPanel.this.setUnten(CurvedFlowBackgroundPanel.this.untenFraction);
                }
            }
        });
    }

    public CurvedFlowBackgroundPanel(int OBEN, int UNTEN) {
        this();
        this.oben = OBEN;
        this.unten = UNTEN;
    }

    private String getInfoString() {
        return "Info: Size=" + this.getWidth() + "," + this.getHeight() + " Oben(abs,rel)=" + this.getOben() + "," + (double)this.getOben() / (double)this.getHeight() + " Unten(abs,rel)=" + this.getUnten() + "," + (double)this.getUnten() / (double)this.getHeight();
    }

    public boolean isDesignMode() {
        return this.designMode;
    }

    public void setDesignMode(boolean designMode) {
        this.designMode = designMode;
    }

    private BufferedImage createOben(int WIDTH, int HEIGHT) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath OBEN1_1 = new GeneralPath();
        OBEN1_1.setWindingRule(0);
        OBEN1_1.moveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN1_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.0);
        OBEN1_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        OBEN1_1.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.078125, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.078125);
        OBEN1_1.curveTo((double)IMAGE_WIDTH * 0.337890625, (double)IMAGE_HEIGHT * 0.181640625, (double)IMAGE_WIDTH * 0.4921875, (double)IMAGE_HEIGHT * 0.96484375, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN1_1.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN1_1.closePath();
        OBEN1_1.moveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN1_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN1_1.closePath();
        Color FILL_COLOR_PATH1_1 = new Color(0, 0, 0, 0);
        G2.setColor(FILL_COLOR_PATH1_1);
        G2.fill(OBEN1_1);
        GeneralPath OBEN2_1 = new GeneralPath();
        OBEN2_1.setWindingRule(0);
        OBEN2_1.moveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN2_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.0);
        OBEN2_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        OBEN2_1.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.078125, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.078125);
        OBEN2_1.curveTo((double)IMAGE_WIDTH * 0.337890625, (double)IMAGE_HEIGHT * 0.181640625, (double)IMAGE_WIDTH * 0.4921875, (double)IMAGE_HEIGHT * 0.96484375, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN2_1.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN2_1.closePath();
        OBEN2_1.moveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN2_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN2_1.closePath();
        Color FILL_COLOR_PATH2_1 = new Color(0xCCCCCC);
        G2.setColor(FILL_COLOR_PATH2_1);
        G2.fill(OBEN2_1);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage createUnten(int WIDTH, int HEIGHT) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath UNTEN1_1 = new GeneralPath();
        UNTEN1_1.setWindingRule(0);
        UNTEN1_1.moveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN1_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 1.0);
        UNTEN1_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        UNTEN1_1.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.921875, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.921875);
        UNTEN1_1.curveTo((double)IMAGE_WIDTH * 0.662109375, (double)IMAGE_HEIGHT * 0.818359375, (double)IMAGE_WIDTH * 0.5078125, (double)IMAGE_HEIGHT * 0.03515625, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN1_1.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN1_1.closePath();
        UNTEN1_1.moveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN1_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN1_1.closePath();
        Color FILL_COLOR_PATH1_1 = new Color(0xCCCCCC);
        G2.setColor(FILL_COLOR_PATH1_1);
        G2.fill(UNTEN1_1);
        GeneralPath UNTEN2_1 = new GeneralPath();
        UNTEN2_1.setWindingRule(0);
        UNTEN2_1.moveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN2_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 1.0);
        UNTEN2_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        UNTEN2_1.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.921875, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.921875);
        UNTEN2_1.curveTo((double)IMAGE_WIDTH * 0.662109375, (double)IMAGE_HEIGHT * 0.818359375, (double)IMAGE_WIDTH * 0.5078125, (double)IMAGE_HEIGHT * 0.03515625, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN2_1.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN2_1.closePath();
        UNTEN2_1.moveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN2_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN2_1.closePath();
        Color FILL_COLOR_PATH2_1 = new Color(0xCCCCCC);
        G2.setColor(FILL_COLOR_PATH2_1);
        G2.fill(UNTEN2_1);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage createFlow(int WIDTH, int HEIGHT, int HEIGHT_OBEN, int HEIGHT_UNTEN) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = HEIGHT_OBEN;
        G2.setPaint(this.getBackground());
        G2.fillRect(0, 0, WIDTH, HEIGHT);
        G2.setComposite(AlphaComposite.Clear);
        GeneralPath OBEN1_1 = new GeneralPath();
        OBEN1_1.setWindingRule(0);
        OBEN1_1.moveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN1_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.0);
        OBEN1_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        OBEN1_1.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.078125, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.078125);
        OBEN1_1.curveTo((double)IMAGE_WIDTH * 0.337890625, (double)IMAGE_HEIGHT * 0.181640625, (double)IMAGE_WIDTH * 0.4921875, (double)IMAGE_HEIGHT * 0.96484375, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN1_1.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN1_1.closePath();
        OBEN1_1.moveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN1_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN1_1.closePath();
        G2.fill(OBEN1_1);
        GeneralPath OBEN2_1 = new GeneralPath();
        OBEN2_1.setWindingRule(0);
        OBEN2_1.moveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN2_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.0);
        OBEN2_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        OBEN2_1.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.078125, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.078125);
        OBEN2_1.curveTo((double)IMAGE_WIDTH * 0.337890625, (double)IMAGE_HEIGHT * 0.181640625, (double)IMAGE_WIDTH * 0.4921875, (double)IMAGE_HEIGHT * 0.96484375, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN2_1.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN2_1.closePath();
        OBEN2_1.moveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN2_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        OBEN2_1.closePath();
        G2.fill(OBEN2_1);
        G2.translate(0, HEIGHT - HEIGHT_UNTEN);
        IMAGE_HEIGHT = HEIGHT_UNTEN;
        GeneralPath UNTEN1_1 = new GeneralPath();
        UNTEN1_1.setWindingRule(0);
        UNTEN1_1.moveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN1_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 1.0);
        UNTEN1_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        UNTEN1_1.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.921875, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.921875);
        UNTEN1_1.curveTo((double)IMAGE_WIDTH * 0.662109375, (double)IMAGE_HEIGHT * 0.818359375, (double)IMAGE_WIDTH * 0.5078125, (double)IMAGE_HEIGHT * 0.03515625, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN1_1.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN1_1.closePath();
        UNTEN1_1.moveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN1_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN1_1.closePath();
        Color FILL_COLOR_PATH1_1 = new Color(0xCCCCCC);
        G2.setColor(FILL_COLOR_PATH1_1);
        G2.fill(UNTEN1_1);
        GeneralPath UNTEN2_1 = new GeneralPath();
        UNTEN2_1.setWindingRule(0);
        UNTEN2_1.moveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN2_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 1.0);
        UNTEN2_1.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        UNTEN2_1.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.921875, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.921875);
        UNTEN2_1.curveTo((double)IMAGE_WIDTH * 0.662109375, (double)IMAGE_HEIGHT * 0.818359375, (double)IMAGE_WIDTH * 0.5078125, (double)IMAGE_HEIGHT * 0.03515625, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN2_1.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN2_1.closePath();
        UNTEN2_1.moveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN2_1.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        UNTEN2_1.closePath();
        G2.fill(UNTEN2_1);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        ((Graphics2D)g).drawImage((Image)this.createFlow(this.getWidth(), this.getHeight(), this.oben, this.unten), 0, 0, null);
    }

    public int getOben() {
        return this.oben;
    }

    public void setOben(int oben) {
        this.oben = oben;
        if (!this.relativeHeights) {
            this.obenFraction = (double)this.getOben() / (double)this.getHeight();
        }
        this.repaint();
    }

    public void setOben(double fractionOben) {
        this.obenFraction = fractionOben;
        int o = (int)((double)this.getHeight() * fractionOben);
        this.setOben(o);
    }

    public void setUnten(double fractionUnten) {
        this.untenFraction = fractionUnten;
        int u = (int)((double)this.getHeight() * fractionUnten);
        this.setUnten(u);
    }

    public int getUnten() {
        return this.unten;
    }

    public void setUnten(int unten) {
        this.unten = unten;
        if (!this.relativeHeights) {
            this.untenFraction = (double)this.getUnten() / (double)this.getHeight();
        }
        this.repaint();
    }

    public boolean isRelativeHeights() {
        return this.relativeHeights;
    }

    public void setRelativeHeights(boolean relativeHeights) {
        this.relativeHeights = relativeHeights;
    }
}

