/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DefaultPopupMenuListener
extends MouseAdapter {
    private final transient Logger log = Logger.getLogger(this.getClass());
    private final JPopupMenu popupMenu;

    public DefaultPopupMenuListener(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processPopupTrigger(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processPopupTrigger(e);
    }

    private void processPopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JTree currentTree;
            try {
                if (e.getSource() instanceof JTree) {
                    TreePath selPath;
                    currentTree = (JTree)e.getSource();
                    TreePath[] paths = currentTree.getSelectionPaths();
                    ArrayList<TreePath> pathList = new ArrayList<TreePath>();
                    if (paths != null && paths.length > 0) {
                        pathList.addAll(Arrays.asList(paths));
                    }
                    if ((selPath = currentTree.getPathForLocation(e.getX(), e.getY())) != null && !pathList.contains(selPath)) {
                        if (e.isControlDown()) {
                            pathList.add(selPath);
                            currentTree.setSelectionPaths(pathList.toArray(new TreePath[pathList.size()]));
                        } else if (e.isShiftDown() && pathList.size() > 0) {
                            TreePath first = (TreePath)pathList.get(0);
                            int firstIndex = currentTree.getRowForPath(first);
                            int selectedIndex = currentTree.getRowForPath(selPath);
                            currentTree.setSelectionInterval(firstIndex, selectedIndex);
                        } else {
                            currentTree.setSelectionPath(selPath);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.log.error((Object)"Error during on-the-fly-selection", (Throwable)ex);
            }
            if (!this.clickOnTreePath(e) && !e.isControlDown() && !e.isShiftDown() && e.getSource() instanceof JTree) {
                currentTree = (JTree)e.getSource();
                currentTree.clearSelection();
            }
            this.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        } else if (e.getButton() == 1 && !e.isControlDown() && !e.isShiftDown() && e.getSource() instanceof JTree && !this.clickOnTreePath(e)) {
            JTree currentTree = (JTree)e.getSource();
            currentTree.clearSelection();
        }
    }

    private boolean clickOnTreePath(MouseEvent e) {
        JTree currentTree;
        TreePath tp;
        if (e.getSource() instanceof JTree && (tp = (currentTree = (JTree)e.getSource()).getClosestPathForLocation(e.getX(), e.getY())) != null) {
            Rectangle bounds = currentTree.getPathBounds(tp);
            int x = e.getX();
            int y = e.getY();
            int x1 = (int)bounds.getX();
            int x2 = (int)(bounds.getX() + bounds.getWidth());
            int y1 = (int)bounds.getY();
            int y2 = (int)(bounds.getY() + bounds.getHeight());
            return x >= x1 && x <= x2 && y >= y1 && y <= y2;
        }
        return false;
    }
}

