/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import de.cismet.tools.ExifReader;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.graphics.ShadowRenderer;

public final class ImageUtil {
    private static Logger LOG = Logger.getLogger(ImageUtil.class);

    public static Image adjustScale(BufferedImage bi, JComponent component, int insetX, int insetY) {
        double scaley;
        double scalex = (double)component.getWidth() / (double)bi.getWidth();
        double scale = Math.min(scalex, scaley = (double)component.getHeight() / (double)bi.getHeight());
        if (scale <= 1.0) {
            return bi.getScaledInstance((int)((double)bi.getWidth() * scale) - insetX, (int)((double)bi.getHeight() * scale) - insetY, 4);
        }
        return bi;
    }

    public static Image adjustScale(BufferedImage bi, int targetW, int targetH, int insetX, int insetY) {
        double scaley;
        double scalex = (double)targetW / (double)bi.getWidth();
        double scale = Math.min(scalex, scaley = (double)targetH / (double)bi.getHeight());
        if (scale <= 1.0) {
            return bi.getScaledInstance((int)((double)bi.getWidth() * scale) - insetX, (int)((double)bi.getHeight() * scale) - insetY, 4);
        }
        return bi;
    }

    public static Image resizeOnScale(Image origImage, int maxWidth, int maxHeight) {
        int resizedHeight;
        int resizedWidth;
        int origHeight;
        int origWidth = origImage.getWidth(null);
        double ratio = (double)origWidth / (double)(origHeight = origImage.getHeight(null));
        if (ratio > (double)(maxWidth / maxHeight)) {
            resizedWidth = maxWidth;
            resizedHeight = (int)Math.round((double)maxWidth / ratio);
        } else {
            resizedWidth = (int)Math.round((double)maxHeight * ratio);
            resizedHeight = maxHeight;
        }
        return origImage.getScaledInstance(resizedWidth, resizedHeight, 4);
    }

    public static BufferedImage generateShadow(Image in, int shadowPixel) {
        BufferedImage input;
        if (in == null) {
            return null;
        }
        if (in instanceof BufferedImage) {
            input = (BufferedImage)in;
        } else {
            BufferedImage temp = new BufferedImage(in.getWidth(null), in.getHeight(null), 6);
            Graphics2D tg = temp.createGraphics();
            tg.drawImage(in, 0, 0, null);
            tg.dispose();
            input = temp;
        }
        if (shadowPixel < 1) {
            return input;
        }
        ShadowRenderer renderer = new ShadowRenderer(shadowPixel, 0.5f, Color.BLACK);
        BufferedImage shadow = renderer.createShadow(input);
        BufferedImage result = new BufferedImage(input.getWidth() + 2 * shadowPixel, input.getHeight() + 2 * shadowPixel, 6);
        Graphics2D rg = result.createGraphics();
        rg.drawImage((Image)shadow, 0, 0, null);
        rg.drawImage((Image)input, 0, 0, null);
        rg.dispose();
        return result;
    }

    public static BufferedImage rotateImage(BufferedImage src, double degrees) {
        float radianAngle = (float)Math.toRadians(degrees);
        float sin = (float)Math.abs(Math.sin(radianAngle));
        float cos = (float)Math.abs(Math.cos(radianAngle));
        int width = src.getWidth();
        int height = src.getHeight();
        int newWidth = Math.round((float)width * cos + (float)height * sin);
        int newHeight = Math.round((float)height * cos + (float)width * sin);
        AffineTransform transform = AffineTransform.getTranslateInstance((newWidth - width) / 2, (newHeight - height) / 2);
        transform.rotate(radianAngle, width / 2, height / 2);
        BufferedImage result = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(newWidth, newHeight, 3);
        Graphics2D g = result.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawRenderedImage(src, transform);
        g.dispose();
        return result;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D bGr = bufferedImage.createGraphics();
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        return bufferedImage;
    }

    public static BufferedImage toHorizontallyMirroredImage(BufferedImage image) {
        BufferedImage mirroredImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                mirroredImage.setRGB(image.getWidth() - x - 1, y, image.getRGB(x, y));
            }
        }
        return mirroredImage;
    }

    public static BufferedImage toVerticallyMirroredImage(BufferedImage image) {
        BufferedImage mirroredImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                mirroredImage.setRGB(x, image.getHeight() - y - 1, image.getRGB(x, y));
            }
        }
        return mirroredImage;
    }

    public static Image loadImageAccordingToExifOrientation(File imageFile) {
        Double rotation = null;
        ExifReader.Mirrored mirrored = ExifReader.Mirrored.NONE;
        try {
            ExifReader reader = new ExifReader(imageFile);
            rotation = reader.getOrientationRotation();
            mirrored = reader.getKindOfMirrored();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reading exif information", (Throwable)e);
        }
        Image image = new ImageIcon(imageFile.getAbsolutePath()).getImage();
        if (image != null) {
            if (rotation != null && rotation != 0.0) {
                image = ImageUtil.rotateImage(ImageUtil.toBufferedImage(image), rotation);
            }
            if (!mirrored.equals((Object)ExifReader.Mirrored.NONE)) {
                image = mirrored.equals((Object)ExifReader.Mirrored.HORIZONTAL) ? ImageUtil.toHorizontallyMirroredImage(ImageUtil.toBufferedImage(image)) : ImageUtil.toVerticallyMirroredImage(ImageUtil.toBufferedImage(image));
            }
        }
        return image;
    }
}

