/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;

public class JPopupMenuButton
extends JButton
implements MouseListener,
MouseMotionListener {
    protected boolean showPopupMenu = true;
    protected JPopupMenu popupMenu = null;
    protected boolean mouseInPopupArea = false;
    protected Icon downArrow = new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/res/down.png"));
    protected Icon downArrow2 = new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/res/down2.png"));
    protected Icon userDefinedIcon = null;
    protected Icon userDefinedSelectedIcon = null;
    protected int arrowXOffset = 0;
    protected int arrowSelectedXOffset = 0;
    protected boolean fireOnArrow = false;

    public JPopupMenuButton() {
        this(true);
    }

    public JPopupMenuButton(boolean showPopupMenu) {
        this.showPopupMenu = showPopupMenu;
        this.setIcon(null);
        this.setVerticalTextPosition(0);
        this.setHorizontalTextPosition(2);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setFocusPainted(false);
    }

    private boolean isOverMenuPopupArea(int x, int y) {
        return x >= this.getWidth() - this.getIcon().getIconWidth() + this.arrowXOffset - this.getInsets().right && x <= this.getWidth() - 1;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean oldValue = this.mouseInPopupArea;
        this.mouseInPopupArea = this.isOverMenuPopupArea((int)e.getPoint().getX(), (int)e.getPoint().getY());
        if (oldValue != this.mouseInPopupArea) {
            this.evaluateIcon(this.isSelected());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseInPopupArea = false;
        this.evaluateIcon(this.isSelected());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    public boolean isFireOnArrow() {
        return this.fireOnArrow;
    }

    public void setFireOnArrow(boolean fireOnArrow) {
        this.fireOnArrow = fireOnArrow;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isEnabled()) {
            if ((this.popupMenu == null || this.popupMenu.getComponentCount() == 0) && this.mouseInPopupArea) {
                this.actionPerformed(new ActionEvent(this, 0, ""));
            } else if (this.mouseInPopupArea || e.isPopupTrigger()) {
                this.popupMenu.show(this, 0, this.getHeight());
                this.popupMenu.setVisible(true);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        ActionEvent thisEvent = new ActionEvent(this, 0, "ACTION");
        this.fireActionPerformed(thisEvent);
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        this.userDefinedIcon = defaultIcon;
        this.evaluateIcon(false);
    }

    @Override
    public void setSelectedIcon(Icon defaultSelectedIcon) {
        this.userDefinedSelectedIcon = defaultSelectedIcon;
        this.evaluateIcon(true);
    }

    private void evaluateIcon(boolean isSelected) {
        if (this.mouseInPopupArea && this.isEnabled()) {
            this.evaluateIcon(this.downArrow2, isSelected);
        } else {
            this.evaluateIcon(this.downArrow, isSelected);
        }
    }

    private void evaluateIcon(Icon arrow, boolean isSelected) {
        Icon icon;
        Icon icon2 = icon = this.userDefinedSelectedIcon != null && isSelected ? this.userDefinedSelectedIcon : this.userDefinedIcon;
        if (icon != null) {
            int newWidth = icon.getIconWidth() + arrow.getIconWidth();
            int newHeight = icon.getIconHeight();
            int arrowYOffset = (icon.getIconHeight() - arrow.getIconHeight()) / 2;
            this.arrowXOffset = icon.getIconWidth();
            int iconYOffset = 0;
            if (arrow.getIconHeight() > newHeight) {
                newHeight = arrow.getIconHeight();
                arrowYOffset = 0;
                iconYOffset = (arrow.getIconHeight() - icon.getIconHeight()) / 2;
            }
            BufferedImage tmp = new BufferedImage(newWidth, newHeight, 2);
            icon.paintIcon(this, tmp.getGraphics(), 0, iconYOffset);
            if (this.showPopupMenu) {
                arrow.paintIcon(this, tmp.getGraphics(), icon.getIconWidth(), arrowYOffset);
            }
            if (isSelected) {
                super.setSelectedIcon(new ImageIcon(tmp));
            } else {
                super.setIcon(new ImageIcon(tmp));
            }
        } else if (isSelected) {
            super.setSelectedIcon(arrow);
        } else {
            super.setIcon(arrow);
        }
    }

    public void setPopupMenu(JPopupMenu pop) {
        this.popupMenu = pop;
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        if (this.isFireOnArrow() || this.popupMenu == null || !this.mouseInPopupArea) {
            super.fireActionPerformed(event);
        }
    }
}

