/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class NavigableImagePanel
extends JPanel {
    public static final String ZOOM_LEVEL_CHANGED_PROPERTY = "zoomLevel";
    public static final String ZOOM_INCREMENT_CHANGED_PROPERTY = "zoomIncrement";
    public static final String IMAGE_CHANGED_PROPERTY = "image";
    private static final double SCREEN_NAV_IMAGE_FACTOR = 0.15;
    private static final double NAV_IMAGE_FACTOR = 0.3;
    private static final double HIGH_QUALITY_RENDERING_SCALE_THRESHOLD = 1.0;
    private static final Object INTERPOLATION_TYPE = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private double zoomIncrement = 0.2;
    private double zoomFactor = 1.0 + this.zoomIncrement;
    private double navZoomFactor = 1.0 + this.zoomIncrement;
    private BufferedImage image;
    private BufferedImage navigationImage;
    private int navImageWidth;
    private int navImageHeight;
    private double initialScale = 0.0;
    private double scale = 0.0;
    private double navScale = 0.0;
    private int originX = 0;
    private int originY = 0;
    private Point mousePosition;
    private Dimension previousPanelSize;
    private boolean navigationImageEnabled = true;
    private boolean highQualityRenderingEnabled = true;
    private WheelZoomDevice wheelZoomDevice = null;
    private ButtonZoomDevice buttonZoomDevice = null;

    public NavigableImagePanel() {
        this.setOpaque(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (NavigableImagePanel.this.scale > 0.0) {
                    if (NavigableImagePanel.this.isFullImageInPanel()) {
                        NavigableImagePanel.this.centerImage();
                    } else if (NavigableImagePanel.this.isImageEdgeInPanel()) {
                        NavigableImagePanel.this.scaleOrigin();
                    }
                    if (NavigableImagePanel.this.isNavigationImageEnabled()) {
                        NavigableImagePanel.this.createNavigationImage();
                    }
                    NavigableImagePanel.this.repaint();
                }
                NavigableImagePanel.this.previousPanelSize = NavigableImagePanel.this.getSize();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && NavigableImagePanel.this.isInNavigationImage(e.getPoint())) {
                    Point p = e.getPoint();
                    NavigableImagePanel.this.displayImageAt(p);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && !NavigableImagePanel.this.isInNavigationImage(e.getPoint())) {
                    Point p = e.getPoint();
                    NavigableImagePanel.this.moveImage(p);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                NavigableImagePanel.this.mousePosition = e.getPoint();
            }
        });
        this.setZoomDevice(ZoomDevice.MOUSE_WHEEL);
    }

    public NavigableImagePanel(BufferedImage image) throws IOException {
        this();
        this.setImage(image);
    }

    private void addWheelZoomDevice() {
        if (this.wheelZoomDevice == null) {
            this.wheelZoomDevice = new WheelZoomDevice();
            this.addMouseWheelListener(this.wheelZoomDevice);
        }
    }

    private void addButtonZoomDevice() {
        if (this.buttonZoomDevice == null) {
            this.buttonZoomDevice = new ButtonZoomDevice();
            this.addMouseListener(this.buttonZoomDevice);
        }
    }

    private void removeWheelZoomDevice() {
        if (this.wheelZoomDevice != null) {
            this.removeMouseWheelListener(this.wheelZoomDevice);
            this.wheelZoomDevice = null;
        }
    }

    private void removeButtonZoomDevice() {
        if (this.buttonZoomDevice != null) {
            this.removeMouseListener(this.buttonZoomDevice);
            this.buttonZoomDevice = null;
        }
    }

    public void setZoomDevice(ZoomDevice newZoomDevice) {
        if (newZoomDevice == ZoomDevice.NONE) {
            this.removeWheelZoomDevice();
            this.removeButtonZoomDevice();
        } else if (newZoomDevice == ZoomDevice.MOUSE_BUTTON) {
            this.removeWheelZoomDevice();
            this.addButtonZoomDevice();
        } else if (newZoomDevice == ZoomDevice.MOUSE_WHEEL) {
            this.removeButtonZoomDevice();
            this.addWheelZoomDevice();
        }
    }

    public ZoomDevice getZoomDevice() {
        if (this.buttonZoomDevice != null) {
            return ZoomDevice.MOUSE_BUTTON;
        }
        if (this.wheelZoomDevice != null) {
            return ZoomDevice.MOUSE_WHEEL;
        }
        return ZoomDevice.NONE;
    }

    private void initializeParams() {
        double xScale = (double)this.getWidth() / (double)this.image.getWidth();
        double yScale = (double)this.getHeight() / (double)this.image.getHeight();
        this.scale = this.initialScale = Math.min(xScale, yScale);
        this.centerImage();
        this.createNavigationImage();
    }

    private void centerImage() {
        this.originX = (this.getWidth() - this.getScreenImageWidth()) / 2;
        this.originY = (this.getHeight() - this.getScreenImageHeight()) / 2;
    }

    private void createNavigationImage() {
        this.navImageWidth = (int)((double)this.getWidth() * 0.3);
        this.navImageHeight = this.navImageWidth * this.image.getHeight() / this.image.getWidth();
        int scrNavImageWidth = (int)((double)this.getWidth() * 0.15);
        int scrNavImageHeight = scrNavImageWidth * this.image.getHeight() / this.image.getWidth();
        this.navScale = (double)scrNavImageWidth / (double)this.navImageWidth;
        this.navigationImage = new BufferedImage(this.navImageWidth, this.navImageHeight, this.image.getType());
        Graphics g = this.navigationImage.getGraphics();
        g.drawImage(this.image, 0, 0, this.navImageWidth, this.navImageHeight, null);
    }

    public void setImage(BufferedImage image) {
        BufferedImage oldImage = this.image;
        this.image = image;
        this.scale = 0.0;
        this.firePropertyChange(IMAGE_CHANGED_PROPERTY, oldImage, image);
        this.repaint();
    }

    public static boolean isStandardRGBImage(BufferedImage bImage) {
        return bImage.getColorModel().getColorSpace().isCS_sRGB();
    }

    private Coords panelToImageCoords(Point p) {
        return new Coords((double)(p.x - this.originX) / this.scale, (double)(p.y - this.originY) / this.scale);
    }

    private Coords imageToPanelCoords(Coords p) {
        return new Coords(p.x * this.scale + (double)this.originX, p.y * this.scale + (double)this.originY);
    }

    private Point navToZoomedImageCoords(Point p) {
        int x = p.x * this.getScreenImageWidth() / this.getScreenNavImageWidth();
        int y = p.y * this.getScreenImageHeight() / this.getScreenNavImageHeight();
        return new Point(x, y);
    }

    private void displayImageAt(Point p) {
        Point scrImagePoint = this.navToZoomedImageCoords(p);
        this.originX = -(scrImagePoint.x - this.getWidth() / 2);
        this.originY = -(scrImagePoint.y - this.getHeight() / 2);
        this.repaint();
    }

    private boolean isInImage(Point p) {
        Coords coords = this.panelToImageCoords(p);
        int x = coords.getIntX();
        int y = coords.getIntY();
        return x >= 0 && x < this.image.getWidth() && y >= 0 && y < this.image.getHeight();
    }

    private boolean isInNavigationImage(Point p) {
        return this.isNavigationImageEnabled() && p.x < this.getScreenNavImageWidth() && p.y < this.getScreenNavImageHeight();
    }

    private boolean isImageEdgeInPanel() {
        if (this.previousPanelSize == null) {
            return false;
        }
        return this.originX > 0 && this.originX < this.previousPanelSize.width || this.originY > 0 && this.originY < this.previousPanelSize.height;
    }

    private boolean isFullImageInPanel() {
        return this.originX >= 0 && this.originX + this.getScreenImageWidth() < this.getWidth() && this.originY >= 0 && this.originY + this.getScreenImageHeight() < this.getHeight();
    }

    public boolean isHighQualityRenderingEnabled() {
        return this.highQualityRenderingEnabled;
    }

    public void setHighQualityRenderingEnabled(boolean enabled) {
        this.highQualityRenderingEnabled = enabled;
    }

    private boolean isHighQualityRendering() {
        return this.highQualityRenderingEnabled && this.scale > 1.0;
    }

    public boolean isNavigationImageEnabled() {
        return this.navigationImageEnabled;
    }

    public void setNavigationImageEnabled(boolean enabled) {
        this.navigationImageEnabled = enabled;
        this.repaint();
    }

    private void scaleOrigin() {
        this.originX = this.originX * this.getWidth() / this.previousPanelSize.width;
        this.originY = this.originY * this.getHeight() / this.previousPanelSize.height;
        this.repaint();
    }

    private double zoomToScale(double zoom) {
        return this.initialScale * zoom;
    }

    public double getZoom() {
        return this.scale / this.initialScale;
    }

    public void setZoom(double newZoom) {
        Point zoomingCenter = new Point(this.getWidth() / 2, this.getHeight() / 2);
        this.setZoom(newZoom, zoomingCenter);
    }

    public void setZoom(double newZoom, Point zoomingCenter) {
        Coords imageP = this.panelToImageCoords(zoomingCenter);
        if (imageP.x < 0.0) {
            imageP.x = 0.0;
        }
        if (imageP.y < 0.0) {
            imageP.y = 0.0;
        }
        if (imageP.x >= (double)this.image.getWidth()) {
            imageP.x = (double)this.image.getWidth() - 1.0;
        }
        if (imageP.y >= (double)this.image.getHeight()) {
            imageP.y = (double)this.image.getHeight() - 1.0;
        }
        Coords correctedP = this.imageToPanelCoords(imageP);
        double oldZoom = this.getZoom();
        this.scale = this.zoomToScale(newZoom);
        Coords panelP = this.imageToPanelCoords(imageP);
        this.originX += correctedP.getIntX() - (int)panelP.x;
        this.originY += correctedP.getIntY() - (int)panelP.y;
        this.firePropertyChange(ZOOM_LEVEL_CHANGED_PROPERTY, new Double(oldZoom), new Double(this.getZoom()));
        this.repaint();
    }

    public double getZoomIncrement() {
        return this.zoomIncrement;
    }

    public void setZoomIncrement(double newZoomIncrement) {
        double oldZoomIncrement = this.zoomIncrement;
        this.zoomIncrement = newZoomIncrement;
        this.firePropertyChange(ZOOM_INCREMENT_CHANGED_PROPERTY, new Double(oldZoomIncrement), new Double(this.zoomIncrement));
    }

    private void zoomImage() {
        Coords imageP = this.panelToImageCoords(this.mousePosition);
        double oldZoom = this.getZoom();
        this.scale *= this.zoomFactor;
        Coords panelP = this.imageToPanelCoords(imageP);
        this.originX += this.mousePosition.x - (int)panelP.x;
        this.originY += this.mousePosition.y - (int)panelP.y;
        this.firePropertyChange(ZOOM_LEVEL_CHANGED_PROPERTY, new Double(oldZoom), new Double(this.getZoom()));
        this.repaint();
    }

    private void zoomNavigationImage() {
        this.navScale *= this.navZoomFactor;
        this.repaint();
    }

    public Point getImageOrigin() {
        return new Point(this.originX, this.originY);
    }

    public void setImageOrigin(int x, int y) {
        this.setImageOrigin(new Point(x, y));
    }

    public void setImageOrigin(Point newOrigin) {
        this.originX = newOrigin.x;
        this.originY = newOrigin.y;
        this.repaint();
    }

    private void moveImage(Point p) {
        int xDelta = p.x - this.mousePosition.x;
        int yDelta = p.y - this.mousePosition.y;
        this.originX += xDelta;
        this.originY += yDelta;
        this.mousePosition = p;
        this.repaint();
    }

    private Rectangle getImageClipBounds() {
        Coords startCoords = this.panelToImageCoords(new Point(0, 0));
        Coords endCoords = this.panelToImageCoords(new Point(this.getWidth() - 1, this.getHeight() - 1));
        int panelX1 = startCoords.getIntX();
        int panelY1 = startCoords.getIntY();
        int panelX2 = endCoords.getIntX();
        int panelY2 = endCoords.getIntY();
        if (panelX1 >= this.image.getWidth() || panelX2 < 0 || panelY1 >= this.image.getHeight() || panelY2 < 0) {
            return null;
        }
        int x1 = panelX1 < 0 ? 0 : panelX1;
        int y1 = panelY1 < 0 ? 0 : panelY1;
        int x2 = panelX2 >= this.image.getWidth() ? this.image.getWidth() - 1 : panelX2;
        int y2 = panelY2 >= this.image.getHeight() ? this.image.getHeight() - 1 : panelY2;
        return new Rectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        if (this.scale == 0.0) {
            this.initializeParams();
        }
        if (this.isHighQualityRendering()) {
            Rectangle rect = this.getImageClipBounds();
            if (rect == null || rect.width == 0 || rect.height == 0) {
                return;
            }
            BufferedImage subimage = this.image.getSubimage(rect.x, rect.y, rect.width, rect.height);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, INTERPOLATION_TYPE);
            g2.drawImage(subimage, Math.max(0, this.originX), Math.max(0, this.originY), Math.min((int)((double)subimage.getWidth() * this.scale), this.getWidth()), Math.min((int)((double)subimage.getHeight() * this.scale), this.getHeight()), null);
        } else {
            g.drawImage(this.image, this.originX, this.originY, this.getScreenImageWidth(), this.getScreenImageHeight(), null);
        }
        if (this.isNavigationImageEnabled()) {
            g.drawImage(this.navigationImage, 0, 0, this.getScreenNavImageWidth(), this.getScreenNavImageHeight(), null);
            Color backup = g.getColor();
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, this.getScreenNavImageWidth(), this.getScreenNavImageHeight());
            g.setColor(backup);
            this.drawZoomAreaOutline(g);
        }
    }

    private void drawZoomAreaOutline(Graphics g) {
        if (this.isFullImageInPanel()) {
            return;
        }
        int x = -this.originX * this.getScreenNavImageWidth() / this.getScreenImageWidth();
        int y = -this.originY * this.getScreenNavImageHeight() / this.getScreenImageHeight();
        int width = this.getWidth() * this.getScreenNavImageWidth() / this.getScreenImageWidth();
        int height = this.getHeight() * this.getScreenNavImageHeight() / this.getScreenImageHeight();
        g.setColor(Color.RED);
        g.drawRect(x, y, width, height);
    }

    private int getScreenImageWidth() {
        return (int)(this.scale * (double)this.image.getWidth());
    }

    private int getScreenImageHeight() {
        return (int)(this.scale * (double)this.image.getHeight());
    }

    private int getScreenNavImageWidth() {
        return (int)(this.navScale * (double)this.navImageWidth);
    }

    private int getScreenNavImageHeight() {
        return (int)(this.navScale * (double)this.navImageHeight);
    }

    private static String[] getImageFormatExtensions() {
        Object[] names = ImageIO.getReaderFormatNames();
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((String)names[i]).toLowerCase();
        }
        Arrays.sort(names);
        return names;
    }

    private static boolean endsWithImageFormatExtension(String name) {
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex == -1) {
            return false;
        }
        String extension = name.substring(dotIndex + 1).toLowerCase();
        return Arrays.binarySearch(NavigableImagePanel.getImageFormatExtensions(), extension) >= 0;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java NavigableImagePanel imageFilename");
            System.exit(1);
        }
        final String filename = args[0];
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Navigable Image Panel");
                frame.setDefaultCloseOperation(3);
                NavigableImagePanel panel = new NavigableImagePanel();
                try {
                    BufferedImage image = ImageIO.read(new File(filename));
                    panel.setImage(image);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "", 0);
                    System.exit(1);
                }
                frame.getContentPane().add((Component)panel, "Center");
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Rectangle bounds = ge.getMaximumWindowBounds();
                frame.setSize(new Dimension(bounds.width, bounds.height));
                frame.setVisible(true);
            }
        });
    }

    private class ButtonZoomDevice
    extends MouseAdapter {
        private ButtonZoomDevice() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            if (SwingUtilities.isRightMouseButton(e)) {
                if (NavigableImagePanel.this.isInNavigationImage(p)) {
                    NavigableImagePanel.this.navZoomFactor = 1.0 - NavigableImagePanel.this.zoomIncrement;
                    NavigableImagePanel.this.zoomNavigationImage();
                } else if (NavigableImagePanel.this.isInImage(p)) {
                    NavigableImagePanel.this.zoomFactor = 1.0 - NavigableImagePanel.this.zoomIncrement;
                    NavigableImagePanel.this.zoomImage();
                }
            } else if (NavigableImagePanel.this.isInNavigationImage(p)) {
                NavigableImagePanel.this.navZoomFactor = 1.0 + NavigableImagePanel.this.zoomIncrement;
                NavigableImagePanel.this.zoomNavigationImage();
            } else if (NavigableImagePanel.this.isInImage(p)) {
                NavigableImagePanel.this.zoomFactor = 1.0 + NavigableImagePanel.this.zoomIncrement;
                NavigableImagePanel.this.zoomImage();
            }
        }
    }

    private class WheelZoomDevice
    implements MouseWheelListener {
        private WheelZoomDevice() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            boolean zoomIn;
            Point p = e.getPoint();
            boolean bl = zoomIn = e.getWheelRotation() < 0;
            if (NavigableImagePanel.this.isInNavigationImage(p)) {
                if (zoomIn) {
                    NavigableImagePanel.this.navZoomFactor = 1.0 + NavigableImagePanel.this.zoomIncrement;
                } else {
                    NavigableImagePanel.this.navZoomFactor = 1.0 - NavigableImagePanel.this.zoomIncrement;
                }
                NavigableImagePanel.this.zoomNavigationImage();
            } else if (NavigableImagePanel.this.isInImage(p)) {
                if (zoomIn) {
                    NavigableImagePanel.this.zoomFactor = 1.0 + NavigableImagePanel.this.zoomIncrement;
                } else {
                    NavigableImagePanel.this.zoomFactor = 1.0 - NavigableImagePanel.this.zoomIncrement;
                }
                NavigableImagePanel.this.zoomImage();
            }
        }
    }

    private class Coords {
        public double x;
        public double y;

        public Coords(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public int getIntX() {
            return (int)Math.round(this.x);
        }

        public int getIntY() {
            return (int)Math.round(this.y);
        }

        public String toString() {
            return "[Coords: x=" + this.x + ",y=" + this.y + "]";
        }
    }

    public static class ZoomDevice {
        public static final ZoomDevice NONE = new ZoomDevice("none");
        public static final ZoomDevice MOUSE_BUTTON = new ZoomDevice("mouseButton");
        public static final ZoomDevice MOUSE_WHEEL = new ZoomDevice("mouseWheel");
        private String zoomDevice;

        private ZoomDevice(String zoomDevice) {
            this.zoomDevice = zoomDevice;
        }

        public String toString() {
            return this.zoomDevice;
        }
    }
}

