/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.graphics.ShadowRenderer;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.ImagePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;
import org.jdesktop.swingx.painter.effects.InnerGlowPathEffect;
import org.jdesktop.swingx.painter.effects.ShadowPathEffect;

public class PainterCoolPanel
extends JXPanel {
    private static final Color colorDarkLine = Color.black;
    private static final int IMAGE_TYPE = 6;
    private JComponent panTitle;
    private JComponent panInter;
    private boolean changeFlag = true;
    private int oldHeight;
    private int oldPanInterHeight;
    private int oldPanTitleHeight;
    private int offset = 6;
    private ImageIcon icons;

    public PainterCoolPanel() {
        this.refreshPainter();
        this.oldHeight = this.getHeight();
        this.oldPanInterHeight = 0;
        this.oldPanTitleHeight = 0;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int changeFactor = Math.abs(this.oldHeight - this.getHeight());
        if (this.oldHeight <= 0) {
            this.oldHeight = this.getHeight();
        }
        int percent = changeFactor * 100 / this.oldHeight;
        if (this.panInter != null && this.panTitle != null && (this.oldPanInterHeight != this.panInter.getBounds().height || this.oldPanTitleHeight != this.panTitle.getBounds().height)) {
            this.oldPanInterHeight = this.panInter.getBounds().height;
            this.oldPanTitleHeight = this.panTitle.getBounds().height;
            this.changeFlag = true;
        }
        if (this.changeFlag || percent > 10) {
            this.changeFlag = false;
            this.oldHeight = this.getHeight();
            this.refreshPainter();
        }
    }

    public void setPanInter(JComponent panInter) {
        this.changeFlag = true;
        this.panInter = panInter;
    }

    public void setPanTitle(JComponent panTitle) {
        this.changeFlag = true;
        this.panTitle = panTitle;
    }

    public JComponent getPanInter() {
        return this.panInter;
    }

    public JComponent getPanTitle() {
        return this.panTitle;
    }

    public void setImageRechtsOben(ImageIcon icon) {
        if (icon != null) {
            try {
                ImageIcon newIcon;
                ShadowRenderer renderer = new ShadowRenderer(3, 0.5f, Color.BLACK);
                BufferedImage temp = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
                Graphics2D tg = temp.createGraphics();
                tg.drawImage(icon.getImage(), 0, 0, null);
                tg.dispose();
                BufferedImage shadow = renderer.createShadow(temp);
                BufferedImage result = new BufferedImage(icon.getIconWidth() + 6, icon.getIconHeight() + 6, 6);
                Graphics2D rg = result.createGraphics();
                rg.drawImage((Image)shadow, 0, 0, null);
                rg.drawImage((Image)temp, 0, 0, null);
                rg.dispose();
                shadow.flush();
                this.icons = newIcon = new ImageIcon(result);
            }
            catch (Exception e) {
                this.icons = null;
            }
        }
    }

    private void refreshPainter() {
        if (this.panInter == null || this.panTitle == null) {
            return;
        }
        float centerGradientOffset = ((float)(this.getHeight() - this.offset) - (float)this.panInter.getBounds().height * 0.8f) / (float)(this.getHeight() - this.offset);
        float[] dist = new float[]{0.0f, centerGradientOffset, 1.0f};
        Color[] colors = new Color[]{new Color(66, 66, 66), new Color(102, 102, 102), new Color(66, 66, 66)};
        LinearGradientPaint titleAndInterGradient = new LinearGradientPaint(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, this.getHeight() - this.offset), dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        RectanglePainter interAndTitle = new RectanglePainter((Paint)titleAndInterGradient, (Paint)colorDarkLine, 1.0f, null);
        interAndTitle.setPaintStretched(true);
        interAndTitle.setRoundHeight(30);
        interAndTitle.setRoundWidth(30);
        interAndTitle.setRounded(true);
        interAndTitle.setInsets(new Insets(0, this.offset, this.offset, this.offset));
        ImagePainter ip = new ImagePainter();
        if (this.icons != null) {
            BufferedImage img = (BufferedImage)this.icons.getImage();
            ip.setImage(img);
            ip.setInsets(new Insets((this.panTitle.getBounds().height - img.getHeight()) / 2 + 3, 0, 0, 2 * this.offset));
            ip.setHorizontalAlignment(AbstractLayoutPainter.HorizontalAlignment.RIGHT);
            ip.setVerticalAlignment(AbstractLayoutPainter.VerticalAlignment.TOP);
        }
        ShadowPathEffect outerShadow = new ShadowPathEffect();
        outerShadow.setOffset((Point2D)new Point2D.Float(3.0f, 3.0f));
        outerShadow.setBrushColor(Color.LIGHT_GRAY);
        outerShadow.setEffectWidth(3);
        InnerGlowPathEffect titleGlow = new InnerGlowPathEffect();
        titleGlow.setBrushColor(Color.white);
        titleGlow.setBrushSteps(2);
        titleGlow.setOffset((Point2D)new Point2D.Double(0.0, 1.0));
        titleGlow.setEffectWidth(3);
        interAndTitle.setAreaEffects(new AreaEffect[]{outerShadow, titleGlow});
        CompoundPainter interAndTitleCompound = new CompoundPainter(new Painter[]{interAndTitle, ip});
        int upperInset = this.panTitle.getBounds().height;
        int lowerInset = this.panInter.getBounds().height;
        RectanglePainter center = new RectanglePainter((Paint)new Color(226, 226, 226), (Paint)new Color(226, 226, 226), 1.0f, AbstractAreaPainter.Style.BOTH);
        center.setInsets(new Insets(upperInset, this.offset + 1, lowerInset, this.offset + 1));
        RectanglePainter upperWhiteLine = new RectanglePainter((Paint)new Color(220, 220, 220), (Paint)new Color(46, 46, 46), 1.0f, AbstractAreaPainter.Style.OUTLINE);
        upperWhiteLine.setInsets(new Insets(upperInset, this.offset, lowerInset + 1, this.offset));
        GradientPaint centerGradientPaint = new GradientPaint(0.0f, upperInset + 2, new Color(150, 150, 150), 0.0f, this.getHeight() - lowerInset, new Color(231, 231, 231));
        RectanglePainter centerGradient = new RectanglePainter((Paint)centerGradientPaint, null, 0.0f, AbstractAreaPainter.Style.FILLED);
        centerGradient.setPaintStretched(true);
        centerGradient.setInsets(new Insets(upperInset + 2, this.offset + 1, lowerInset + 2, this.offset + 1));
        CompoundPainter centerFill = new CompoundPainter(new Painter[]{upperWhiteLine, centerGradient});
        CompoundPainter centerCompoundPainter = new CompoundPainter(new Painter[]{center, centerFill});
        CompoundPainter compound = new CompoundPainter(new Painter[]{interAndTitleCompound, centerCompoundPainter});
        this.setBackgroundPainter((Painter)compound);
    }
}

