/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import de.cismet.tools.gui.FuseLoader;
import de.cismet.tools.gui.PainterCoolPanel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jdesktop.fuse.InjectedResource;
import org.jdesktop.fuse.ResourceInjector;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.graphics.ShadowRenderer;

public class PureCoolPanel
extends PainterCoolPanel {
    private static final Logger log = Logger.getLogger(PureCoolPanel.class);
    private static final int IMAGE_TYPE = 6;
    private static final Stroke STROKE = new BasicStroke(1.0f);
    @InjectedResource
    public int offset;
    @InjectedResource
    public int offsetRight;
    @InjectedResource
    public int offsetTop;
    @InjectedResource
    public int offsetBetween;
    @InjectedResource
    public int arcSize;
    @InjectedResource
    public int shadowLength;
    @InjectedResource
    public int blurFactor;
    @InjectedResource
    public float borderWidth;
    @InjectedResource
    public float shadowIntensity;
    @InjectedResource
    public float titlePanelOpacity;
    @InjectedResource
    public float titleLinesOpacity;
    @InjectedResource
    public float interPanelOpacity;
    @InjectedResource
    public float interLinesOpacity;
    @InjectedResource
    public float blurredMapOpacity;
    @InjectedResource
    public float cutOutMapOpacity;
    @InjectedResource
    public float glossyOpacity;
    @InjectedResource
    public Color shadowColor;
    @InjectedResource
    public Color colorBorder;
    @InjectedResource
    public Color colorMapBorder;
    @InjectedResource
    public Color colorTitle;
    @InjectedResource
    public Color colorInter;
    @InjectedResource
    public Color colorDarkLine;
    @InjectedResource
    public Color colorBrightLine;
    @InjectedResource
    public Color colorGlossy;
    @InjectedResource
    public Color gradientColorTop;
    @InjectedResource
    public Color gradientColorBottom;
    @InjectedResource
    public boolean usePainterCoolPanel;
    private JPanel spinner;
    private JComponent panMap;
    private JComponent panContent;
    private ImageIcon icons;
    private BufferedImage cacheImage;
    private BufferedImage gradientImage;
    private JComponent panTitle;
    private JComponent panInter;
    private final Composite composite;
    private final ShadowRenderer shadowRenderer;
    private Dimension lastPaintSize;

    public PureCoolPanel() {
        FuseLoader.load();
        ResourceInjector.get((Object)"purecoolpanel.style").inject(true, new Object[]{this});
        this.gradientColorTop = UIManager.getDefaults().getColor("Button.shadow");
        this.gradientColorBottom = UIManager.getDefaults().getColor("Button.background");
        this.composite = AlphaComposite.SrcAtop.derive(this.titleLinesOpacity);
        this.shadowRenderer = new ShadowRenderer(this.shadowLength, this.shadowIntensity, this.shadowColor);
        this.cacheImage = null;
        this.gradientImage = null;
        this.lastPaintSize = this.getSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.usePainterCoolPanel) {
            super.paintComponent(g);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            if (this.cacheImage == null || !this.getSize().equals(this.lastPaintSize)) {
                Rectangle bounds;
                this.lastPaintSize = this.getSize();
                BufferedImage box = new BufferedImage(this.getWidth() - this.offset, this.getHeight() - this.offset, 6);
                Graphics2D boxGraphics = box.createGraphics();
                Composite originalComposite = boxGraphics.getComposite();
                if (this.gradientImage == null || this.gradientImage.getHeight() != box.getHeight()) {
                    this.gradientImage = GraphicsUtilities.createCompatibleImage((int)1, (int)box.getHeight());
                    Graphics2D gradientGraphics2d = this.gradientImage.createGraphics();
                    gradientGraphics2d.setPaint(new GradientPaint(0.0f, 0.0f, this.gradientColorTop, 0.0f, box.getHeight(), this.gradientColorBottom));
                    gradientGraphics2d.fillRect(0, 0, 1, box.getHeight());
                }
                boxGraphics.setColor(Color.BLACK);
                boxGraphics.fillRoundRect(this.offset, 0, box.getWidth() - this.offset, box.getHeight(), this.arcSize, this.arcSize);
                boxGraphics.setComposite(AlphaComposite.SrcAtop);
                boxGraphics.drawImage(this.gradientImage, 0, 0, box.getWidth(), box.getHeight(), null);
                boxGraphics.setComposite(originalComposite);
                boxGraphics.setStroke(STROKE);
                if (this.getPanTitle() != null) {
                    bounds = this.getPanTitle().getBounds();
                    boxGraphics.setComposite(AlphaComposite.SrcAtop.derive(this.titlePanelOpacity));
                    boxGraphics.setColor(this.colorTitle);
                    boxGraphics.fillRect(0, bounds.y, bounds.width + this.offset, bounds.height);
                    boxGraphics.setComposite(this.composite);
                    boxGraphics.setColor(this.colorDarkLine);
                    boxGraphics.drawLine(this.offset, bounds.height - 1, bounds.width + 3 * this.offset, bounds.height - 1);
                    boxGraphics.setColor(this.colorBrightLine);
                    boxGraphics.drawLine(this.offset, bounds.height, bounds.width + 3 * this.offset, bounds.height);
                }
                if (this.getPanInter() != null) {
                    bounds = this.getPanInter().getBounds();
                    boxGraphics.setComposite(AlphaComposite.SrcAtop.derive(this.interPanelOpacity));
                    boxGraphics.setPaint(new GradientPaint(0.0f, bounds.y, new Color(0, 0, 0, 160), 0.0f, bounds.y + bounds.height, Color.BLACK));
                    boxGraphics.fillRect(0, bounds.y, bounds.width + this.offset, bounds.height);
                    boxGraphics.setComposite(AlphaComposite.SrcAtop.derive(this.interLinesOpacity));
                    boxGraphics.setColor(this.colorDarkLine);
                    boxGraphics.drawLine(this.offset, bounds.y - 1, bounds.width + 3 * this.offset, bounds.y - 1);
                    boxGraphics.setColor(this.colorBrightLine);
                    boxGraphics.drawLine(this.offset, bounds.y, bounds.width + 3 * this.offset, bounds.y);
                }
                boxGraphics.setComposite(AlphaComposite.SrcOver.derive(0.7f));
                boxGraphics.setColor(this.colorBorder);
                boxGraphics.drawRoundRect(this.offset, 0, box.getWidth() - (this.offset + 1), box.getHeight() - 1, this.arcSize, this.arcSize);
                BufferedImage glossy = new BufferedImage(box.getWidth(), box.getHeight(), 6);
                Graphics2D glossyGraphics2D = glossy.createGraphics();
                glossyGraphics2D.setStroke(STROKE);
                glossyGraphics2D.setColor(this.colorGlossy);
                glossyGraphics2D.drawRoundRect(this.offset + 1, 1, box.getWidth() - (this.offset + 3), 2 * this.arcSize, this.arcSize, this.arcSize);
                glossyGraphics2D.setComposite(AlphaComposite.DstIn);
                glossyGraphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 255), 0.0f, this.arcSize / 2, new Color(255, 255, 255, 0)));
                glossyGraphics2D.fillRect(0, 0, box.getWidth(), this.arcSize);
                glossyGraphics2D.setPaint(new Color(255, 255, 255, 0));
                glossyGraphics2D.fillRect(0, this.arcSize / 2, box.getWidth(), 2 * this.arcSize);
                BufferedImage shadow = this.shadowRenderer.createShadow(box);
                this.cacheImage = new BufferedImage(shadow.getWidth(), shadow.getHeight(), 6);
                Graphics2D resultGraphics2D = this.cacheImage.createGraphics();
                resultGraphics2D.drawImage((Image)shadow, 0, 0, null);
                resultGraphics2D.drawImage((Image)box, 0, 0, null);
                resultGraphics2D.setComposite(AlphaComposite.SrcOver.derive(this.glossyOpacity));
                resultGraphics2D.drawImage((Image)glossy, 0, 0, null);
                resultGraphics2D.setComposite(originalComposite);
                if (this.icons != null) {
                    resultGraphics2D.drawImage(this.icons.getImage(), box.getWidth() - this.icons.getIconWidth() - this.offsetRight, this.panTitle.getHeight() / 2 + 3 - this.icons.getIconHeight() / 2, null);
                }
                boxGraphics.dispose();
                glossyGraphics2D.dispose();
                resultGraphics2D.dispose();
                box.flush();
                glossy.flush();
                shadow.flush();
            }
            g2d.drawImage((Image)this.cacheImage, 0, 0, null);
        }
    }

    public JComponent getPanMap() {
        return this.panMap;
    }

    public void setPanMap(JComponent panMap) {
        this.panMap = panMap;
    }

    public JComponent getPanContent() {
        return this.panContent;
    }

    public void setPanContent(JComponent panContent) {
        this.panContent = panContent;
    }

    public JPanel getSpinner() {
        return this.spinner;
    }

    public void setSpinner(JPanel spinner) {
        this.spinner = spinner;
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(200, 200));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

