/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class RichJLabel
extends JLabel {
    private int tracking;
    private int left_x;
    private int left_y;
    private int right_x;
    private int right_y;
    private Color left_color;
    private Color right_color;

    public RichJLabel(String text, int tracking) {
        super(text);
        this.tracking = tracking;
    }

    public void setLeftShadow(int x, int y, Color color) {
        this.left_x = x;
        this.left_y = y;
        this.left_color = color;
    }

    public void setRightShadow(int x, int y, Color color) {
        this.right_x = x;
        this.right_y = y;
        this.right_color = color;
    }

    @Override
    public Dimension getPreferredSize() {
        String text = this.getText();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int w = fm.stringWidth(text);
        w += (text.length() - 1) * this.tracking;
        int h = fm.getHeight();
        return new Dimension(w += this.left_x + this.right_x, h += this.left_y + this.right_y);
    }

    @Override
    public void paintComponent(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        char[] chars = this.getText().toCharArray();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int h = fm.getAscent();
        LineMetrics lm = fm.getLineMetrics(this.getText(), g);
        g.setFont(this.getFont());
        int x = 0;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            int w = fm.charWidth(ch) + this.tracking;
            g.setColor(this.left_color);
            g.drawString("" + chars[i], x - this.left_x, h - this.left_y);
            g.setColor(this.right_color);
            g.drawString("" + chars[i], x + this.right_x, h + this.right_y);
            g.setColor(this.getForeground());
            g.drawString("" + chars[i], x, h);
            x += w;
        }
    }

    public static void main(String[] args) {
        RichJLabel label = new RichJLabel("76", 0);
        label.setLeftShadow(1, 1, Color.white);
        label.setRightShadow(1, 1, Color.white);
        label.setForeground(Color.BLACK);
        label.setFont(label.getFont().deriveFont(26.0f));
        JFrame frame = new JFrame("RichJLabel hack");
        frame.getContentPane().add(label);
        frame.pack();
        frame.setVisible(true);
    }

    public static void p(String str) {
        System.out.println(str);
    }
}

