/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class WaitDialog
extends JDialog {
    private final Cancellable cancellable;
    private JButton btnCancel;
    private JProgressBar jProgressBar2;
    private JLabel labIcon;
    private JLabel labText;

    public WaitDialog(Frame parent, boolean modal, String text, Icon icon) {
        this(parent, modal, text, icon, null);
    }

    public WaitDialog(Frame parent, boolean modal, String text, Icon icon, Cancellable cancellable) {
        super(parent, modal);
        this.initComponents();
        if (cancellable == null) {
            this.btnCancel.setVisible(false);
        }
        if (icon != null) {
            this.labIcon.setIcon(icon);
        }
        if (text != null) {
            this.labText.setText(text);
        }
        this.cancellable = cancellable;
        this.pack();
        this.setAlwaysOnTop(true);
    }

    public void setProgress(int n) {
        this.jProgressBar2.setValue(n);
        this.jProgressBar2.repaint();
    }

    public int getProgress() {
        return this.jProgressBar2.getValue();
    }

    public void increaseProgress(int steps) {
        this.setProgress(this.getProgress() + steps);
    }

    public void setMax(int n) {
        this.jProgressBar2.setIndeterminate(false);
        this.jProgressBar2.setStringPainted(true);
        this.jProgressBar2.setMinimum(0);
        this.jProgressBar2.setMaximum(n);
    }

    public void setText(String text) {
        this.labText.setText(text);
    }

    private void initComponents() {
        this.labIcon = new JLabel();
        this.labText = new JLabel();
        this.jProgressBar2 = new JProgressBar();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setCursor(new Cursor(0));
        this.setUndecorated(true);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.getContentPane().add((Component)this.labIcon, gridBagConstraints);
        this.labText.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.labText, gridBagConstraints);
        this.jProgressBar2.setBorderPainted(false);
        this.jProgressBar2.setIndeterminate(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jProgressBar2, gridBagConstraints);
        this.btnCancel.setText(NbBundle.getMessage(WaitDialog.class, (String)"WaitDialog.btnCancel.text", (Object[])new Object[0]));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaitDialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.btnCancel, gridBagConstraints);
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        if (this.cancellable != null && this.cancellable.cancel()) {
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new WaitDialog((Frame)new JFrame(), true, "Change CRS", null).setVisible(true);
            }
        });
    }
}

