/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitDialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.openide.util.Cancellable;

public abstract class WaitingDialogThread<T>
implements Runnable,
Cancellable {
    private static final Logger LOG = Logger.getLogger(WaitingDialogThread.class);
    protected WaitDialog wd;
    protected boolean canceled = false;
    private int delay = 0;
    private volatile boolean isAlive = true;
    private volatile boolean shouldBeSetVisible = false;
    private final Frame parent;
    private final boolean modal;
    private final String text;
    private final Icon icon;
    private T backgroundResult;
    private Exception thrownException;
    private final boolean cancellable;
    private Thread worker = null;

    public WaitingDialogThread(Frame parent, boolean modal, String text, Icon icon, int delay) {
        this(parent, modal, text, icon, delay, false);
    }

    public WaitingDialogThread(Frame parent, boolean modal, String text, Icon icon, int delay, boolean cancellable) {
        this.parent = parent;
        this.modal = modal;
        this.text = text;
        this.icon = icon;
        this.delay = delay;
        this.cancellable = cancellable;
    }

    @Override
    public final void run() {
        try {
            this.backgroundResult = this.doInBackground();
        }
        catch (Exception e) {
            this.thrownException = e;
        }
    }

    protected abstract T doInBackground() throws Exception;

    protected void done() {
    }

    protected T get() throws Exception {
        if (this.thrownException != null) {
            throw this.thrownException;
        }
        return this.backgroundResult;
    }

    public boolean cancel() {
        this.canceled = true;
        try {
            this.worker.interrupt();
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!EventQueue.isDispatchThread()) {
            LOG.error((Object)"The start method of the WaitingDialogThread must be invoked in the Edt.");
            return;
        }
        this.isAlive = true;
        this.shouldBeSetVisible = false;
        this.thrownException = null;
        final ReentrantLock lock = new ReentrantLock();
        this.wd = this.cancellable ? new WaitDialog(this.parent, this.modal, this.text, this.icon, this) : new WaitDialog(this.parent, this.modal, this.text, this.icon);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WaitingDialogThread.this.worker = new Thread(WaitingDialogThread.this);
                    WaitingDialogThread.this.worker.start();
                    try {
                        WaitingDialogThread.this.worker.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                finally {
                    if (WaitingDialogThread.this.shouldBeSetVisible) {
                        try {
                            lock.lock();
                            WaitingDialogThread.this.isAlive = false;
                            while (!WaitingDialogThread.this.wd.isVisible()) {
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            WaitingDialogThread.this.wd.setVisible(false);
                            WaitingDialogThread.this.wd.dispose();
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
            }
        });
        t.start();
        if (this.delay > 0) {
            try {
                t.join(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            lock.lock();
            if (t.isAlive() && this.isAlive) {
                this.shouldBeSetVisible = true;
            }
        }
        finally {
            lock.unlock();
        }
        if (this.shouldBeSetVisible) {
            try {
                StaticSwingTools.showDialog(this.wd);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while showing waiting dialog. Try again", (Throwable)e);
                try {
                    StaticSwingTools.showDialog(this.wd);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while showing waiting dialog", (Throwable)ex);
                }
            }
        }
        if (!this.canceled) {
            this.done();
        }
    }
}

