/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.actiongroup;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;

public final class ComponentFactory {
    private ComponentFactory() {
    }

    public static AbstractButton getRadioButton(Action action) {
        JRadioButton button = new JRadioButton(action);
        ComponentFactory.connectActionAndButton(action, button);
        return button;
    }

    public static AbstractButton getToggleButton(Action action) {
        JToggleButton button = new JToggleButton(action);
        ComponentFactory.connectActionAndButton(action, button);
        return button;
    }

    public static JMenuItem getRadioMenuItem(Action action) {
        JRadioButtonMenuItem menu = new JRadioButtonMenuItem(action);
        ComponentFactory.connectActionAndButton(action, menu);
        return menu;
    }

    private static void connectActionAndButton(Action action, AbstractButton button) {
        SelectionStateAdapter adapter = new SelectionStateAdapter(action, button);
        adapter.configure();
    }

    private static class SelectionStateAdapter
    implements PropertyChangeListener,
    ItemListener {
        private Action action;
        private AbstractButton button;

        public SelectionStateAdapter(Action theAction, AbstractButton theButton) {
            this.action = theAction;
            this.button = theButton;
        }

        protected void configure() {
            this.action.addPropertyChangeListener(this);
            this.button.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean value = e.getStateChange() == 1;
            Boolean valueObj = value;
            this.action.putValue("actionConstants.selected", valueObj);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("actionConstants.selected")) {
                Boolean newSelectedState = (Boolean)evt.getNewValue();
                this.button.setSelected(newSelectedState);
            }
        }
    }
}

