/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.autocomplete;

import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.apache.log4j.Logger;

public abstract class AbstractCompleterFilter
extends DocumentFilter {
    static final Logger log = Logger.getLogger(AbstractCompleterFilter.class);
    private static final String NULL_REPRESENTATION = "null";
    protected String preText;
    protected boolean caseSensitive = false;
    protected boolean corrective = true;
    protected boolean strict = false;
    protected int firstSelectedIndex = -1;

    public abstract int getCompleterListSize();

    public abstract Object getCompleterObjectAt(int var1);

    public abstract JTextField getTextField();

    @Override
    public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String string, AttributeSet attributeSet) throws BadLocationException {
        boolean found = false;
        try {
            super.replace(filterBypass, offset, length, string, attributeSet);
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
        }
        Document doc = filterBypass.getDocument();
        this.preText = doc.getText(0, doc.getLength());
        this.firstSelectedIndex = -1;
        for (int i = 0; i < this.getCompleterListSize(); ++i) {
            String objString = this.objectToStringAndHandleNullValue(this.getCompleterObjectAt(i));
            if (this.caseSensitive ? objString.equals(this.preText) : objString.equalsIgnoreCase(this.preText)) {
                this.firstSelectedIndex = i;
                if (this.corrective) {
                    filterBypass.replace(0, this.preText.length(), objString, attributeSet);
                }
                found = true;
                break;
            }
            if (objString.length() <= this.preText.length()) continue;
            String objStringStart = objString.substring(0, this.preText.length());
            if (!(this.caseSensitive ? objStringStart.equals(this.preText) : objStringStart.equalsIgnoreCase(this.preText))) continue;
            String objStringEnd = objString.substring(this.preText.length());
            if (this.corrective) {
                filterBypass.replace(0, this.preText.length(), objString, attributeSet);
            } else {
                filterBypass.insertString(this.preText.length(), objStringEnd, attributeSet);
            }
            this.getTextField().select(this.preText.length(), doc.getLength());
            this.firstSelectedIndex = i;
            found = true;
            break;
        }
        if (!found) {
            this.firstSelectedIndex = -1;
            if (this.strict) {
                this.preText = this.preText.substring(0, this.preText.length() - 1);
                UIManager.getLookAndFeel().provideErrorFeedback(this.getTextField());
                if (this.preText.length() == 0) {
                    if (this.getCompleterListSize() > -1) {
                        String objStr = this.objectToStringAndHandleNullValue(this.getCompleterObjectAt(0));
                        JTextField tf = this.getTextField();
                        tf.setText(objStr);
                        int end = tf.getText().length();
                        tf.setCaretPosition(end);
                        tf.moveCaretPosition(Math.min(end, 1));
                    }
                } else {
                    filterBypass.replace(0, this.preText.length() + 1, this.preText, attributeSet);
                    if (this.preText.length() > 0) {
                        this.replace(filterBypass, 0, this.preText.length(), this.preText, attributeSet);
                    }
                }
            }
        }
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String string, AttributeSet attributeSet) throws BadLocationException {
        if (!this.strict) {
            super.insertString(filterBypass, offset, string, attributeSet);
        }
    }

    private String objectToStringAndHandleNullValue(Object o) {
        return o != null ? o.toString() : NULL_REPRESENTATION;
    }

    @Override
    public void remove(DocumentFilter.FilterBypass filterBypass, int offset, int length) throws BadLocationException {
        if (!this.strict) {
            super.remove(filterBypass, offset, length);
            String comp = this.getTextField().getText();
            for (int i = 0; i < this.getCompleterListSize(); ++i) {
                String comp2 = this.objectToStringAndHandleNullValue(this.getCompleterObjectAt(i));
                if (this.caseSensitive && comp.equals(comp2)) {
                    this.firstSelectedIndex = i;
                    return;
                }
                if (this.caseSensitive || !comp.equalsIgnoreCase(comp2)) continue;
                this.firstSelectedIndex = i;
                return;
            }
            this.firstSelectedIndex = -1;
        } else {
            JTextField tf = this.getTextField();
            int newSelStart = Math.min(tf.getSelectionStart(), tf.getCaretPosition()) - 1;
            if (newSelStart > -1) {
                tf.setCaretPosition(tf.getText().length());
                tf.moveCaretPosition(newSelStart);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.getTextField());
            }
        }
    }

    public void setCaseSensitive(boolean correctCaseSensitive) {
        this.caseSensitive = correctCaseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCorrectCase(boolean correctCase) {
        this.corrective = correctCase;
    }

    public boolean isCorrectingCase() {
        return this.corrective;
    }

    public int getLeadingSelectedIndex() {
        return this.firstSelectedIndex;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

