/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.autocomplete;

import de.cismet.tools.gui.autocomplete.CompleterFilter;
import de.cismet.tools.gui.autocomplete.FilterListModel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class CompleterFilterWithWindow
extends CompleterFilter {
    public static int MAX_VISIBLE_ROWS = 8;
    private FilterWindowListener fwl;
    private JWindow win;
    private TextFieldKeyListener tfkl;
    private ListSelListener lsl;
    private ListMouseListener lml;
    private JList list;
    private JScrollPane sp;
    private FilterListModel lm;
    private boolean isAdjusting = false;

    public CompleterFilterWithWindow(Object[] completerObjs, JTextField textField) {
        super(completerObjs, textField);
        this._init();
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String string, AttributeSet attributeSet) throws BadLocationException {
        this.setFilterWindowVisible(false);
        super.insertString(filterBypass, offset, string, attributeSet);
    }

    @Override
    public void remove(DocumentFilter.FilterBypass filterBypass, int offset, int length) throws BadLocationException {
        this.setFilterWindowVisible(false);
        super.remove(filterBypass, offset, length);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.isAdjusting) {
            filterBypass.replace(offset, length, string, attributeSet);
            return;
        }
        super.replace(filterBypass, offset, length, string, attributeSet);
        if (this.getLeadingSelectedIndex() == -1) {
            if (this.isFilterWindowVisible()) {
                this.setFilterWindowVisible(false);
            }
            return;
        }
        this.lm.setFilter(this.preText);
        if (!this.isFilterWindowVisible()) {
            this.setFilterWindowVisible(true);
        } else {
            this._setWindowHeight();
        }
        this.list.setSelectedValue(this.textField.getText(), true);
    }

    private void _init() {
        this.fwl = new FilterWindowListener();
        this.lm = new FilterListModel(this.objectList);
        this.tfkl = new TextFieldKeyListener();
        this.textField.addKeyListener(this.tfkl);
        EscapeAction escape = new EscapeAction();
        this.textField.registerKeyboardAction(escape, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public boolean isFilterWindowVisible() {
        return this.win != null && this.win.isVisible();
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        super.setCaseSensitive(caseSensitive);
        this.lm.setCaseSensitive(caseSensitive);
    }

    public void setFilterWindowVisible(boolean visible) {
        if (visible) {
            this._initWindow();
            this.list.setModel(this.lm);
            this.win.setVisible(true);
            this.textField.requestFocus();
            this.textField.addFocusListener(this.fwl);
        } else {
            if (this.win == null) {
                return;
            }
            this.win.setVisible(false);
            this.win.removeFocusListener(this.fwl);
            Window ancestor = SwingUtilities.getWindowAncestor(this.textField);
            ancestor.removeMouseListener(this.fwl);
            this.textField.removeFocusListener(this.fwl);
            this.textField.removeAncestorListener(this.fwl);
            this.list.removeMouseListener(this.lml);
            this.list.removeListSelectionListener(this.lsl);
            this.lsl = null;
            this.lml = null;
            this.win.dispose();
            this.win = null;
            this.list = null;
        }
    }

    private void _initWindow() {
        Window ancestor = SwingUtilities.getWindowAncestor(this.textField);
        this.win = new JWindow(ancestor);
        this.win.addWindowFocusListener(this.fwl);
        this.textField.addAncestorListener(this.fwl);
        ancestor.addMouseListener(this.fwl);
        this.lsl = new ListSelListener();
        this.lml = new ListMouseListener();
        this.list = new JList(this.lm);
        this.list.setSelectionMode(0);
        this.list.setFocusable(false);
        this.list.setPrototypeCellValue("Prototype");
        this.list.addListSelectionListener(this.lsl);
        this.list.addMouseListener(this.lml);
        this.sp = new JScrollPane(this.list, 20, 31);
        this.sp.setFocusable(false);
        this.sp.getVerticalScrollBar().setFocusable(false);
        this._setWindowHeight();
        this.win.setLocation(this.textField.getLocationOnScreen().x, this.textField.getLocationOnScreen().y + this.textField.getHeight());
        this.win.getContentPane().add(this.sp);
    }

    private void _setWindowHeight() {
        int height = this.list.getFixedCellHeight() * Math.min(MAX_VISIBLE_ROWS, this.lm.getSize());
        height += this.list.getInsets().top + this.list.getInsets().bottom;
        this.win.setSize(this.textField.getWidth(), height += this.sp.getInsets().top + this.sp.getInsets().bottom);
        this.sp.setSize(this.textField.getWidth(), height);
    }

    @Override
    public void setCompleterMatches(Object[] objectsToMatch) {
        if (this.isFilterWindowVisible()) {
            this.setFilterWindowVisible(false);
        }
        super.setCompleterMatches(objectsToMatch);
        this.lm.setCompleterMatches(objectsToMatch);
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                CompleterFilterWithWindow.this.setFilterWindowVisible(false);
            }
        }
    }

    private class ListSelListener
    implements ListSelectionListener {
        private ListSelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CompleterFilterWithWindow.this.isAdjusting = true;
            CompleterFilterWithWindow.this.textField.setText(CompleterFilterWithWindow.this.list.getSelectedValue().toString());
            CompleterFilterWithWindow.this.isAdjusting = false;
            CompleterFilterWithWindow.this.textField.select(CompleterFilterWithWindow.this.preText.length(), CompleterFilterWithWindow.this.textField.getText().length());
        }
    }

    private class TextFieldKeyListener
    extends KeyAdapter {
        private TextFieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!(e.getKeyCode() == 40 || e.getKeyCode() == 38 || e.getKeyCode() == 34 && CompleterFilterWithWindow.this.isFilterWindowVisible() || e.getKeyCode() == 33 && CompleterFilterWithWindow.this.isFilterWindowVisible() || e.getKeyCode() == 10)) {
                return;
            }
            if (e.getKeyCode() == 40 && !CompleterFilterWithWindow.this.isFilterWindowVisible()) {
                CompleterFilterWithWindow.this.preText = CompleterFilterWithWindow.this.textField.getText();
                CompleterFilterWithWindow.this.lm.setFilter(CompleterFilterWithWindow.this.preText);
                if (CompleterFilterWithWindow.this.lm.getSize() > 0) {
                    CompleterFilterWithWindow.this.setFilterWindowVisible(true);
                } else {
                    return;
                }
            }
            if (e.getKeyCode() == 10) {
                if (CompleterFilterWithWindow.this.isFilterWindowVisible()) {
                    CompleterFilterWithWindow.this.setFilterWindowVisible(false);
                }
                CompleterFilterWithWindow.this.textField.setCaretPosition(CompleterFilterWithWindow.this.textField.getText().length());
                return;
            }
            int index = -1;
            if (e.getKeyCode() == 40) {
                index = Math.min(CompleterFilterWithWindow.this.list.getSelectedIndex() + 1, CompleterFilterWithWindow.this.list.getModel().getSize() - 1);
            } else if (e.getKeyCode() == 38) {
                index = Math.max(CompleterFilterWithWindow.this.list.getSelectedIndex() - 1, 0);
            } else if (e.getKeyCode() == 33) {
                index = Math.max(CompleterFilterWithWindow.this.list.getSelectedIndex() - MAX_VISIBLE_ROWS, 0);
            } else if (e.getKeyCode() == 34) {
                index = Math.min(CompleterFilterWithWindow.this.list.getSelectedIndex() + MAX_VISIBLE_ROWS, CompleterFilterWithWindow.this.list.getModel().getSize() - 1);
            }
            if (index == -1) {
                return;
            }
            CompleterFilterWithWindow.this.list.setSelectedIndex(index);
            CompleterFilterWithWindow.this.list.scrollRectToVisible(CompleterFilterWithWindow.this.list.getCellBounds(index, index));
        }
    }

    private class FilterWindowListener
    extends MouseAdapter
    implements AncestorListener,
    FocusListener,
    WindowFocusListener {
        private FilterWindowListener() {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            CompleterFilterWithWindow.this.setFilterWindowVisible(false);
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            CompleterFilterWithWindow.this.setFilterWindowVisible(false);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            CompleterFilterWithWindow.this.setFilterWindowVisible(false);
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getOppositeComponent() != CompleterFilterWithWindow.this.win) {
                CompleterFilterWithWindow.this.setFilterWindowVisible(false);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            Window w = e.getOppositeWindow();
            if (w.getFocusOwner() != CompleterFilterWithWindow.this.textField) {
                CompleterFilterWithWindow.this.setFilterWindowVisible(false);
            }
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            CompleterFilterWithWindow.this.setFilterWindowVisible(false);
        }
    }

    class EscapeAction
    extends AbstractAction {
        EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CompleterFilterWithWindow.this.isFilterWindowVisible()) {
                CompleterFilterWithWindow.this.setFilterWindowVisible(false);
            }
        }
    }
}

