/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.breadcrumb;

import de.cismet.tools.gui.breadcrumb.AbstractBreadCrumbModelListener;
import de.cismet.tools.gui.breadcrumb.BreadCrumb;
import de.cismet.tools.gui.breadcrumb.BreadCrumbEvent;
import de.cismet.tools.gui.breadcrumb.BreadCrumbModel;
import de.cismet.tools.gui.breadcrumb.DefaultBreadCrumbModel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXHyperlink;

public final class LinkStyleBreadCrumbGui
extends JPanel {
    private final transient ImageIcon arrow;
    private transient JXHyperlink first;
    private transient BreadCrumbModel breadCrumbModel;
    private transient boolean showFirstCrumbAlone;

    public LinkStyleBreadCrumbGui() {
        this(new DefaultBreadCrumbModel());
    }

    public LinkStyleBreadCrumbGui(BreadCrumbModel breadCrumbModel) {
        this.initComponents();
        this.arrow = new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/res/arrowRight.png"));
        this.showFirstCrumbAlone = false;
        this.first = null;
        this.setBreadCrumbModel(breadCrumbModel);
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout(new FlowLayout(0));
    }

    public BreadCrumbModel getBreadCrumbModel() {
        return this.breadCrumbModel;
    }

    public void setBreadCrumbModel(BreadCrumbModel breadCrumbModel) {
        this.breadCrumbModel = breadCrumbModel;
        breadCrumbModel.addBreadCrumbModelListener(new AbstractBreadCrumbModelListener(){

            @Override
            public void breadCrumbModelChanged(BreadCrumbEvent bce) {
                LinkStyleBreadCrumbGui.this.removeAll();
                LinkStyleBreadCrumbGui.this.revalidate();
                BreadCrumbModel m = bce.getSource();
                List<BreadCrumb> l = m.getAllCrumbs();
                for (BreadCrumb bc : l) {
                    LinkStyleBreadCrumbGui.this.addToGui(bc);
                }
            }

            @Override
            public void breadCrumbAdded(BreadCrumbEvent bce) {
                BreadCrumb bc = bce.getBreadCrumb();
                LinkStyleBreadCrumbGui.this.addToGui(bc);
            }
        });
    }

    public boolean isShowFirstCrumbAlone() {
        return this.showFirstCrumbAlone;
    }

    public void setShowFirstCrumbAlone(boolean showFirstCrumbAlone) {
        this.showFirstCrumbAlone = showFirstCrumbAlone;
    }

    private void addToGui(BreadCrumb bc) {
        if (this.breadCrumbModel.getSize() > 0 && this.breadCrumbModel.getFirstCrumb() != bc) {
            JLabel arrowL = new JLabel(this.arrow);
            this.add(arrowL);
        }
        JXHyperlink bcLink = new JXHyperlink((Action)bc);
        bcLink.setClickedColor(bcLink.getUnclickedColor());
        bcLink.setFocusPainted(false);
        this.add((Component)bcLink);
        if (!this.showFirstCrumbAlone) {
            if (this.breadCrumbModel.getSize() == 1) {
                this.first = bcLink;
                this.first.setVisible(false);
            } else {
                this.first.setVisible(true);
            }
        }
    }
}

