/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class AbstractDownload
extends Observable
implements Download,
Runnable,
Comparable {
    private static final ExecutorService downloadThreadPool;
    protected static final Logger log;
    protected String directory;
    protected File fileToSaveTo;
    protected Download.State status;
    protected String title;
    protected Future downloadFuture;
    protected boolean started = false;
    protected Exception caughtException;

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public File getFileToSaveTo() {
        return this.fileToSaveTo;
    }

    @Override
    public Download.State getStatus() {
        return this.status;
    }

    @Override
    public Exception getCaughtException() {
        return this.caughtException;
    }

    @Override
    public int getDownloadsTotal() {
        return 1;
    }

    @Override
    public int getDownloadsCompleted() {
        if (this.status == Download.State.RUNNING) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getDownloadsErroneous() {
        if (this.status == Download.State.COMPLETED_WITH_ERROR) {
            return 1;
        }
        return 0;
    }

    protected void error(Exception exception) {
        if (this.fileToSaveTo != null) {
            log.error((Object)("Exception occurred while downloading '" + this.fileToSaveTo + "'."), (Throwable)exception);
            this.fileToSaveTo.deleteOnExit();
        } else {
            log.error((Object)"Exception occurred while download.", (Throwable)exception);
        }
        this.caughtException = exception;
        this.status = Download.State.COMPLETED_WITH_ERROR;
        this.stateChanged();
    }

    @Override
    public void startDownload() {
        if (!this.started) {
            this.started = true;
            if (downloadThreadPool != null) {
                this.downloadFuture = downloadThreadPool.submit(this);
            } else {
                log.error((Object)"Download Thread Pool is null. Downlaod can not be started");
                this.error(new IllegalStateException("downloadThread is null. Can not start Download"));
            }
        }
    }

    @Override
    public JPanel getExceptionPanel(Exception exception) {
        return null;
    }

    @Override
    public abstract void run();

    protected void determineDestinationFile(String filename, String extension) {
        File directoryToSaveTo = this.isAbsolute(this.directory) ? new File(this.directory) : (this.directory != null && this.directory.trim().length() > 0 ? new File(DownloadManager.instance().getDestinationDirectory(), this.directory) : DownloadManager.instance().getDestinationDirectory());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Determined path '" + directoryToSaveTo + "' for file '" + filename + extension + "'."));
        }
        if (!directoryToSaveTo.exists() && !directoryToSaveTo.mkdirs()) {
            log.error((Object)("Couldn't create destination directory '" + directoryToSaveTo.getAbsolutePath() + "'. Cancelling download."));
            this.error(new Exception("Couldn't create destination directory '" + directoryToSaveTo.getAbsolutePath() + "'. Cancelling download."));
            return;
        }
        if (!directoryToSaveTo.canWrite()) {
            log.error((Object)("Can not write to " + directoryToSaveTo.getAbsolutePath() + ". Probably write permissions are missing."));
            String errorMessage = NbBundle.getMessage(AbstractDownload.class, (String)"AbstractDownload.determineDestinationFile().canNotWriteToDirectory");
            Exception ex = new Exception();
            ex.getLocalizedMessage();
            this.error(new Exception(MessageFormat.format(errorMessage, directoryToSaveTo.getAbsolutePath())));
            return;
        }
        this.fileToSaveTo = new File(directoryToSaveTo, filename + extension);
        boolean fileFound = false;
        int counter = 2;
        while (!fileFound) {
            while (this.fileToSaveTo.exists() && counter < 1000) {
                this.fileToSaveTo = new File(directoryToSaveTo, filename + "(" + counter + ")" + extension);
                ++counter;
            }
            try {
                if (!this.fileToSaveTo.getParentFile().exists()) {
                    this.fileToSaveTo.getParentFile().mkdirs();
                }
                this.fileToSaveTo.createNewFile();
                if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile() && this.fileToSaveTo.canWrite()) {
                    fileFound = true;
                }
            }
            catch (IOException ex) {
                log.warn((Object)("IOEXception while trying to create destination file '" + this.fileToSaveTo.getAbsolutePath() + "'."), (Throwable)ex);
                this.fileToSaveTo.deleteOnExit();
            }
            if (counter < 1000 || fileFound) continue;
            log.error((Object)("Could not create a file for the download. The tested path is '" + directoryToSaveTo.getAbsolutePath() + File.separatorChar + filename + "<1.." + 999 + ">." + extension + "."));
            this.error(new FileNotFoundException("Could not create a file for the download. The tested path is '" + directoryToSaveTo.getAbsolutePath() + File.separatorChar + filename + "<1.." + 999 + ">." + extension + "."));
            return;
        }
    }

    private boolean isAbsolute(String directory) {
        if (directory != null && directory.trim().length() > 1) {
            File path = new File(directory);
            return path.isAbsolute();
        }
        return false;
    }

    protected void stateChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    protected void titleChanged() {
        this.setChanged();
        this.notifyObservers(this.getTitle());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractDownload)) {
            return false;
        }
        return this == obj;
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.fileToSaveTo != null ? this.fileToSaveTo.hashCode() : 0);
        return hash;
    }

    public int compareTo(Object o) {
        if (!(o instanceof AbstractDownload)) {
            return 1;
        }
        AbstractDownload other = (AbstractDownload)o;
        return this.title.compareTo(other.title);
    }

    public static void setParallelDownloads(int parallelDownloads) {
        if (downloadThreadPool == null) {
            log.error((Object)"Thread pool for downloads is null. Currently it is not possible to start downloads");
        }
        if (downloadThreadPool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)downloadThreadPool).setMaximumPoolSize(parallelDownloads);
        }
    }

    static {
        SecurityManager s = System.getSecurityManager();
        ThreadGroup parent = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        int initialParallelDownloads = DownloadManager.instance().getParallelDownloads() == 0 ? 10 : DownloadManager.instance().getParallelDownloads();
        ThreadGroup threadGroup = new ThreadGroup(parent, "DownloadThreadPool");
        downloadThreadPool = CismetExecutors.newCachedThreadPool((ThreadFactory)new CismetConcurrency.CismetThreadFactory(threadGroup, "DownloadThreadPool", null));
        log = Logger.getLogger(AbstractDownload.class);
    }

    private static final class DownloadRejectExecutionHandler
    implements RejectedExecutionHandler {
        private DownloadRejectExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            log.error((Object)"Execution of Downlaod Thread was rejected.");
            if (r instanceof AbstractDownload) {
                AbstractDownload download = (AbstractDownload)r;
                download.error(new RejectedExecutionException(" Downlaod konnte nicht gestartet werden. Es stehen nicht gen\u00fcgend DownlaodThreads bereit."));
            }
        }
    }
}

