/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import java.util.Collection;
import javax.swing.SwingWorker;

public class BackgroundTaskMultipleDownload
extends MultipleDownload {
    private FetchDownloadsTask fetchDownloadTask;
    private SwingWorker<Collection<? extends Download>, Void> worker;
    private Exception caughtException;

    public BackgroundTaskMultipleDownload(Collection<? extends Download> downloads, String title, FetchDownloadsTask fetchDownloadsTask) {
        super(downloads, title);
        this.fetchDownloadTask = fetchDownloadsTask;
    }

    @Override
    public void startDownload() {
        this.worker = new SwingWorker<Collection<? extends Download>, Void>(){

            @Override
            protected Collection<? extends Download> doInBackground() throws Exception {
                return BackgroundTaskMultipleDownload.this.fetchDownloadTask.fetchDownloads();
            }

            @Override
            protected void done() {
                try {
                    BackgroundTaskMultipleDownload.this.addDownloadsSubsequently((Collection)this.get());
                    BackgroundTaskMultipleDownload.this.setStatus(Download.State.RUNNING);
                }
                catch (Exception ex) {
                    BackgroundTaskMultipleDownload.this.caughtException = ex;
                    BackgroundTaskMultipleDownload.this.setStatus(Download.State.COMPLETED_WITH_ERROR);
                }
            }
        };
        this.worker.execute();
    }

    @Override
    public Exception getCaughtException() {
        return this.caughtException;
    }

    private <D extends Download> void addDownloadsSubsequently(Collection<D> newDownloads) {
        Collection<? extends Download> existentDownloads = this.getDownloads();
        for (Download download : newDownloads) {
            existentDownloads.add(download);
        }
        DownloadManager.instance().addDownloadsSubsequently(this);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this.fetchDownloadTask != null ? this.fetchDownloadTask.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackgroundTaskMultipleDownload other = (BackgroundTaskMultipleDownload)obj;
        return this.fetchDownloadTask == other.fetchDownloadTask || this.fetchDownloadTask != null && this.fetchDownloadTask.equals(other.fetchDownloadTask);
    }

    public static interface FetchDownloadsTask {
        public Collection<? extends Download> fetchDownloads() throws Exception;
    }
}

