/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.FileOutputStream;
import java.io.IOException;

public class ByteArrayDownload
extends AbstractDownload {
    private transient byte[] content;

    public ByteArrayDownload(byte[] content, String title, String directory, String filename, String extension) {
        this.content = content;
        this.title = title;
        this.directory = directory;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        if (this.content == null || this.content.length <= 0) {
            log.info((Object)"Downloaded content seems to be empty..");
            if (this.status == Download.State.RUNNING) {
                this.status = Download.State.COMPLETED;
                this.stateChanged();
            }
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.fileToSaveTo);
            out.write(this.content);
        }
        catch (IOException ex) {
            log.warn((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)ex);
            this.error(ex);
            return;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        this.cleanup();
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    private void cleanup() {
        this.content = null;
    }
}

