/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.downloadmanager.BackgroundTaskMultipleDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadListChangedEvent;
import de.cismet.tools.gui.downloadmanager.DownloadListChangedListener;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class DownloadManager
implements Observer,
Configurable {
    private static final Logger LOG = Logger.getLogger(DownloadManager.class);
    private static final String XML_CONF_ROOT = "downloads";
    private static final String XML_CONF_DIRECTORY = "directory";
    private static final String XML_CONF_PARALLEL_DOWNLOADS = "parallelDownloads";
    private static final String XML_CONF_NOTIFICATION_DISPLAY_TIME = "notificationDisplayTime";
    private static final String XML_CONF_DIALOG = "dialog";
    private static final String XML_CONF_DIALOG_AKSFORTITLE = "askForTitle";
    private static final String XML_CONF_DIALOG_OPENAUTOMATICALLY = "openAutomatically";
    private static final String XML_CONF_DIALOG_CLOSEAUTOMATICALLY = "closeAutomatically";
    private static final String XML_CONF_DIALOG_USERTITLE = "userTitle";
    private static DownloadManager instance = null;
    private File destinationDirectory = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "cidsDownload");
    private int parallelDownloads = 2;
    private int notificationDisplayTime = 3;
    private LinkedList<Download> downloads = new LinkedList();
    private List<Download> downloadsToStart = new LinkedList<Download>();
    private EventListenerList listeners = new EventListenerList();
    private int countDownloadsTotal = 0;
    private volatile int countDownloadsRunning = 0;
    private int countDownloadsErroneous = 0;
    private int countDownloadsCompleted = 0;
    private int countDownloadsCancelled = 0;

    private DownloadManager() {
    }

    public static DownloadManager instance() {
        if (instance == null) {
            instance = new DownloadManager();
        }
        return instance;
    }

    public synchronized void add(Download download) {
        if (download == null || this.downloads.contains(download)) {
            return;
        }
        this.downloads.add(download);
        ++this.countDownloadsTotal;
        download.addObserver(this);
        if (download instanceof MultipleDownload) {
            MultipleDownload multipleDownload = (MultipleDownload)download;
            this.downloadsToStart.add(multipleDownload);
            for (Download download2 : multipleDownload.getDownloads()) {
                download2.addObserver(this);
                download2.addObserver(multipleDownload);
                this.downloadsToStart.add(download2);
            }
        } else {
            this.downloadsToStart.add(download);
        }
        this.notifyDownloadListChanged(new DownloadListChangedEvent((Object)this, download, DownloadListChangedEvent.Action.ADDED));
        this.notifyDownloadListChanged(new DownloadListChangedEvent((Object)this, download, DownloadListChangedEvent.Action.CHANGED_COUNTERS));
        this.startDownloads();
    }

    public synchronized void addDownloadsSubsequently(BackgroundTaskMultipleDownload backgroundTaskMultipleDownload) {
        if (backgroundTaskMultipleDownload == null || !this.downloads.contains(backgroundTaskMultipleDownload)) {
            return;
        }
        boolean downloadsWereAdded = false;
        for (Download download : backgroundTaskMultipleDownload.getDownloads()) {
            if (this.downloads.contains(download)) continue;
            download.addObserver(this);
            download.addObserver(backgroundTaskMultipleDownload);
            this.downloadsToStart.add(download);
            downloadsWereAdded = true;
        }
        if (downloadsWereAdded) {
            this.notifyDownloadListChanged(new DownloadListChangedEvent((Object)this, backgroundTaskMultipleDownload, DownloadListChangedEvent.Action.ADDED_DOWNLOADS_SUBSEQUENTLY));
            this.notifyDownloadListChanged(new DownloadListChangedEvent((Object)this, backgroundTaskMultipleDownload, DownloadListChangedEvent.Action.CHANGED_COUNTERS));
            this.startDownloads();
        }
    }

    public synchronized void removeObsoleteDownloads() {
        LinkedList<Download> downloadsRemoved = new LinkedList<Download>();
        for (Download download : this.downloads) {
            if (download.getStatus() != Download.State.COMPLETED && download.getStatus() != Download.State.COMPLETED_WITH_ERROR && download.getStatus() != Download.State.ABORTED) continue;
            downloadsRemoved.add(download);
        }
        if (downloadsRemoved.size() <= 0) {
            return;
        }
        for (Download download : downloadsRemoved) {
            this.downloads.remove(download);
            --this.countDownloadsTotal;
            switch (download.getStatus()) {
                case COMPLETED_WITH_ERROR: {
                    --this.countDownloadsErroneous;
                    break;
                }
                case COMPLETED: {
                    --this.countDownloadsCompleted;
                    break;
                }
                case ABORTED: {
                    --this.countDownloadsCancelled;
                }
            }
            download.deleteObserver(this);
            if (!(download instanceof MultipleDownload)) continue;
            MultipleDownload multipleDownload = (MultipleDownload)download;
            for (Download download2 : multipleDownload.getDownloads()) {
                download2.deleteObserver(this);
                download2.deleteObserver(multipleDownload);
            }
        }
        this.notifyDownloadListChanged(new DownloadListChangedEvent((Object)this, downloadsRemoved, DownloadListChangedEvent.Action.REMOVED));
        this.notifyDownloadListChanged(new DownloadListChangedEvent((Object)this, downloadsRemoved, DownloadListChangedEvent.Action.CHANGED_COUNTERS));
    }

    public synchronized void removeDownload(Download download) {
        this.downloads.remove(download);
        download.deleteObserver(this);
        if (download instanceof MultipleDownload) {
            MultipleDownload multipleDownload = (MultipleDownload)download;
            for (Download download2 : multipleDownload.getDownloads()) {
                download2.deleteObserver(this);
                download2.deleteObserver(multipleDownload);
                this.downloadsToStart.remove(download2);
            }
        } else {
            this.downloadsToStart.remove(download);
        }
        --this.countDownloadsTotal;
        switch (download.getStatus()) {
            case COMPLETED_WITH_ERROR: {
                --this.countDownloadsErroneous;
                break;
            }
            case COMPLETED: {
                --this.countDownloadsCompleted;
                break;
            }
            case ABORTED: {
                --this.countDownloadsCancelled;
            }
        }
        this.notifyDownloadListChanged(new DownloadListChangedEvent((Object)this, download, DownloadListChangedEvent.Action.REMOVED));
        this.notifyDownloadListChanged(new DownloadListChangedEvent((Object)this, download, DownloadListChangedEvent.Action.CHANGED_COUNTERS));
    }

    private synchronized void startDownloads() {
        int downloadsRunning = this.countDownloadsRunning;
        Iterator<Download> downloadToStartIter = this.downloadsToStart.iterator();
        LinkedList<Download> startableDownloads = new LinkedList<Download>();
        while (downloadToStartIter.hasNext() && downloadsRunning < this.parallelDownloads) {
            Download downloadToStart = downloadToStartIter.next();
            if (!downloadToStart.getStatus().equals((Object)Download.State.WAITING)) continue;
            startableDownloads.add(downloadToStart);
            ++downloadsRunning;
            downloadToStartIter.remove();
        }
        for (Download downloadToStart : startableDownloads) {
            downloadToStart.startDownload();
        }
    }

    public Collection<Download> getDownloads() {
        return this.downloads;
    }

    public int getCountDownloadsErroneous() {
        return this.countDownloadsErroneous;
    }

    public int getCountDownloadsCompleted() {
        return this.countDownloadsCompleted;
    }

    public int getCountDownloadsTotal() {
        return this.countDownloadsTotal;
    }

    public int getCountDownloadsCancelled() {
        return this.countDownloadsCancelled;
    }

    public int getParallelDownloads() {
        return this.parallelDownloads;
    }

    public void setParallelDownloads(int parallelDownloads) {
        this.parallelDownloads = parallelDownloads;
    }

    public int getNotificationDisplayTime() {
        return this.notificationDisplayTime;
    }

    public void setNotificationDisplayTime(int notificationDisplayTime) {
        this.notificationDisplayTime = notificationDisplayTime;
    }

    public File getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public void setDestinationDirectory(File destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
        DownloadManagerDialog.getInstance().destinationDirectoryChanged();
        if (!destinationDirectory.isDirectory() || !destinationDirectory.canWrite()) {
            LOG.error((Object)("The download manager can't use the directory '" + destinationDirectory.getAbsolutePath() + "'."));
        }
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        if (arg != null) {
            return;
        }
        if (!(o instanceof Download)) {
            return;
        }
        Download download = (Download)((Object)o);
        switch (download.getStatus()) {
            case COMPLETED: {
                if (!(download instanceof MultipleDownload)) {
                    --this.countDownloadsRunning;
                }
                if (this.downloads.contains(download)) {
                    ++this.countDownloadsCompleted;
                }
                this.startDownloads();
                break;
            }
            case COMPLETED_WITH_ERROR: {
                if (!(download instanceof MultipleDownload)) {
                    --this.countDownloadsRunning;
                }
                if (this.downloads.contains(download)) {
                    ++this.countDownloadsErroneous;
                }
                this.startDownloads();
                break;
            }
            case RUNNING: {
                if (download instanceof MultipleDownload) break;
                ++this.countDownloadsRunning;
                break;
            }
            case ABORTED: {
                if (!(download instanceof MultipleDownload)) {
                    --this.countDownloadsRunning;
                }
                if (this.downloads.contains(download)) {
                    ++this.countDownloadsCancelled;
                }
                this.startDownloads();
            }
        }
        this.notifyDownloadListChanged(new DownloadListChangedEvent((Object)this, download, DownloadListChangedEvent.Action.CHANGED_COUNTERS));
    }

    public void addDownloadListChangedListener(DownloadListChangedListener listener) {
        this.listeners.add(DownloadListChangedListener.class, listener);
    }

    public void removeDownloadListChangedListener(DownloadListChangedListener listener) {
        this.listeners.remove(DownloadListChangedListener.class, listener);
    }

    protected synchronized void notifyDownloadListChanged(DownloadListChangedEvent event) {
        for (DownloadListChangedListener listener : (DownloadListChangedListener[])this.listeners.getListeners(DownloadListChangedListener.class)) {
            listener.downloadListChanged(event);
        }
    }

    public void configure(Element parent) {
        Element parallelDownloads;
        DownloadManagerDialog.getInstance().setAskForJobNameEnabled(true);
        DownloadManagerDialog.getInstance().setJobName("");
        DownloadManagerDialog.getInstance().setOpenAutomaticallyEnabled(true);
        this.destinationDirectory = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "cidsDownload");
        Element downloads = null;
        if (parent == null) {
            LOG.warn((Object)"The download manager isn't configured. Using default values.");
        } else {
            downloads = parent.getChild(XML_CONF_ROOT);
        }
        if (downloads == null) {
            LOG.warn((Object)"The download manager isn't configured. Using default values.");
            if (!this.destinationDirectory.isDirectory() || !this.destinationDirectory.canWrite()) {
                LOG.error((Object)("The download manager can't use the directory '" + this.destinationDirectory.getAbsolutePath() + "'."));
            }
            return;
        }
        Element directory = downloads.getChild(XML_CONF_DIRECTORY);
        if (directory == null || directory.getTextTrim() == null) {
            LOG.warn((Object)("There is no destination directory configured for downloads. Using default destination directory '" + System.getProperty("user.home") + System.getProperty("file.separator") + "cidsDownload'."));
        } else {
            this.destinationDirectory = new File(directory.getTextTrim());
        }
        if (!this.destinationDirectory.isDirectory() || !this.destinationDirectory.canWrite()) {
            LOG.error((Object)("The download manager can't use the directory '" + this.destinationDirectory.getAbsolutePath() + "'."));
        }
        if ((parallelDownloads = downloads.getChild(XML_CONF_PARALLEL_DOWNLOADS)) == null || parallelDownloads.getTextTrim() == null) {
            LOG.warn((Object)"There is no limit for parallel downloads configured. Using default limit '2'.");
        } else {
            try {
                this.parallelDownloads = Integer.parseInt(parallelDownloads.getText());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)"Configuration for limit of parallel downloads is invalid. Using default value of '2'", (Throwable)e);
                this.parallelDownloads = 2;
            }
        }
        Element notificationDisplayTime = downloads.getChild(XML_CONF_NOTIFICATION_DISPLAY_TIME);
        if (notificationDisplayTime == null || notificationDisplayTime.getTextTrim() == null) {
            LOG.warn((Object)"There is no display time for download notifications configured. Using default time '3' sec.");
        } else {
            try {
                this.notificationDisplayTime = Integer.parseInt(notificationDisplayTime.getText());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)"Configuration for display time of download notification is invalid. Using default value of '3' sec", (Throwable)e);
                this.notificationDisplayTime = 3;
            }
        }
        Element dialog = downloads.getChild(XML_CONF_DIALOG);
        if (dialog == null) {
            LOG.warn((Object)"The download dialog isn't configured. Using default values.");
            return;
        }
        Element askForTitle = dialog.getChild(XML_CONF_DIALOG_AKSFORTITLE);
        if (askForTitle == null || askForTitle.getTextTrim() == null) {
            LOG.warn((Object)"There is no configuration whether to ask for download titles or not. Using default value 'true'.");
        } else {
            String value = askForTitle.getTextTrim();
            DownloadManagerDialog.getInstance().setAskForJobNameEnabled("1".equals(value) || "true".equalsIgnoreCase(value));
        }
        Element openAutomatically = dialog.getChild(XML_CONF_DIALOG_OPENAUTOMATICALLY);
        if (openAutomatically == null || openAutomatically.getTextTrim() == null) {
            LOG.warn((Object)"There is no configuration whether to open downloads automatically or not. Using default value 'true'.");
        } else {
            String value = openAutomatically.getTextTrim();
            DownloadManagerDialog.getInstance().setOpenAutomaticallyEnabled("1".equals(value) || "true".equalsIgnoreCase(value));
        }
        Element closeAutomatically = dialog.getChild(XML_CONF_DIALOG_CLOSEAUTOMATICALLY);
        if (closeAutomatically == null || closeAutomatically.getTextTrim() == null) {
            LOG.warn((Object)"There is no configuration whether to close the download manager dialog automatically or not. Using default value 'true'.");
        } else {
            String value = closeAutomatically.getTextTrim();
            DownloadManagerDialog.getInstance().setCloseAutomaticallyEnabled("1".equals(value) || "true".equalsIgnoreCase(value));
        }
        Element userTitle = dialog.getChild(XML_CONF_DIALOG_USERTITLE);
        if (userTitle == null || userTitle.getTextTrim() == null) {
            LOG.warn((Object)"There is no user title for downloads configured. Using default value 'cidsDownload'.");
        } else {
            DownloadManagerDialog.getInstance().setJobName(userTitle.getTextTrim());
        }
        DownloadManagerDialog.getInstance().destinationDirectoryChanged();
    }

    public void masterConfigure(Element parent) {
    }

    public Element getConfiguration() throws NoWriteError {
        Element root = new Element(XML_CONF_ROOT);
        Element directory = new Element(XML_CONF_DIRECTORY);
        directory.addContent(this.destinationDirectory.getAbsolutePath());
        Element dialog = new Element(XML_CONF_DIALOG);
        Element parallelDownloads = new Element(XML_CONF_PARALLEL_DOWNLOADS);
        parallelDownloads.addContent(String.valueOf(this.parallelDownloads));
        Element askForTitle = new Element(XML_CONF_DIALOG_AKSFORTITLE);
        askForTitle.addContent(DownloadManagerDialog.getInstance().isAskForJobNameEnabled() ? "true" : "false");
        Element openAutomatically = new Element(XML_CONF_DIALOG_OPENAUTOMATICALLY);
        openAutomatically.addContent(DownloadManagerDialog.getInstance().isOpenAutomaticallyEnabled() ? "true" : "false");
        Element closeAutomatically = new Element(XML_CONF_DIALOG_CLOSEAUTOMATICALLY);
        closeAutomatically.addContent(DownloadManagerDialog.getInstance().isCloseAutomaticallyEnabled() ? "true" : "false");
        Element userTitle = new Element(XML_CONF_DIALOG_USERTITLE);
        userTitle.addContent(DownloadManagerDialog.getInstance().getJobName());
        dialog.addContent((Content)askForTitle);
        dialog.addContent((Content)openAutomatically);
        dialog.addContent((Content)closeAutomatically);
        dialog.addContent((Content)userTitle);
        root.addContent((Content)directory);
        root.addContent((Content)parallelDownloads);
        root.addContent((Content)dialog);
        return root;
    }
}

