/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.DownloadManagerOptionsCategory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class DownloadManagerOptionsPanel
extends AbstractOptionsPanel
implements OptionsPanelController {
    private static final Logger LOG = Logger.getLogger(DownloadManagerOptionsPanel.class);
    private static final String OPTION_NAME = NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.OPTION_NAME");
    private File downloadDestination;
    private boolean downloadDestinationChanged = false;
    private String jobname = "";
    private boolean askForJobtitle = true;
    private boolean openAutomatically = true;
    private boolean closeAutomatically = true;
    private int parallelDownloads = 2;
    private int notificationDisplayTime = 3;
    private JButton btnChangeDownloadDestination;
    private JCheckBox chkAskForJobname;
    private JFileChooser fileChooser;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JXHyperlink jhlDownloadDestination;
    private JLabel lblCloseAutomatically;
    private JLabel lblDestinationDirectory;
    private JLabel lblJobname;
    private JLabel lblNotificationDisplayTime;
    private JLabel lblOpenAutomatically;
    private JLabel lblParallelDownloads;
    private JPanel pnlCloseAutomatically;
    private JPanel pnlOpenAutomatically;
    private JRadioButton rdoCloseAutomatically;
    private JRadioButton rdoDontCloseAutomatically;
    private JRadioButton rdoDontOpenAutomatically;
    private JRadioButton rdoOpenAutomatically;
    private ButtonGroup rgrCloseAutomatically;
    private ButtonGroup rgrOpenAutomatically;
    private JSpinner spnNotificationDisplayTime;
    private JSpinner spnParallelDownloads;

    public DownloadManagerOptionsPanel() {
        super(OPTION_NAME, DownloadManagerOptionsCategory.class);
        this.initComponents();
    }

    private void initComponents() {
        this.rgrOpenAutomatically = new ButtonGroup();
        this.fileChooser = new JFileChooser();
        this.rgrCloseAutomatically = new ButtonGroup();
        this.lblDestinationDirectory = new JLabel();
        this.jhlDownloadDestination = new JXHyperlink();
        this.btnChangeDownloadDestination = new JButton();
        this.lblJobname = new JLabel();
        this.chkAskForJobname = new JCheckBox();
        this.lblOpenAutomatically = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.pnlOpenAutomatically = new JPanel();
        this.rdoDontOpenAutomatically = new JRadioButton();
        this.rdoOpenAutomatically = new JRadioButton();
        this.lblCloseAutomatically = new JLabel();
        this.lblParallelDownloads = new JLabel();
        this.spnParallelDownloads = new JSpinner();
        this.pnlCloseAutomatically = new JPanel();
        this.rdoDontCloseAutomatically = new JRadioButton();
        this.rdoCloseAutomatically = new JRadioButton();
        this.spnNotificationDisplayTime = new JSpinner();
        this.lblNotificationDisplayTime = new JLabel();
        this.fileChooser.setDialogTitle(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.fileChooser.dialogTitle"));
        this.fileChooser.setFileSelectionMode(1);
        this.setLayout(new GridBagLayout());
        this.lblDestinationDirectory.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.lblDestinationDirectory.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(8, 5, 3, 10);
        this.add((Component)this.lblDestinationDirectory, gridBagConstraints);
        this.jhlDownloadDestination.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.jhlDownloadDestination.text"));
        this.jhlDownloadDestination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManagerOptionsPanel.this.jhlDownloadDestinationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 3, 3, 5);
        this.add((Component)this.jhlDownloadDestination, gridBagConstraints);
        this.btnChangeDownloadDestination.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.btnChangeDownloadDestination.text"));
        this.btnChangeDownloadDestination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManagerOptionsPanel.this.btnChangeDownloadDestinationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(8, 0, 3, 5);
        this.add((Component)this.btnChangeDownloadDestination, gridBagConstraints);
        this.lblJobname.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.lblJobname.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 3, 10);
        this.add((Component)this.lblJobname, gridBagConstraints);
        this.chkAskForJobname.setSelected(true);
        this.chkAskForJobname.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.chkAskForJobname.text"));
        this.chkAskForJobname.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.chkAskForJobname, gridBagConstraints);
        this.lblOpenAutomatically.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.lblOpenAutomatically.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 3, 10);
        this.add((Component)this.lblOpenAutomatically, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler2, gridBagConstraints);
        this.pnlOpenAutomatically.setLayout(new GridBagLayout());
        this.rgrOpenAutomatically.add(this.rdoDontOpenAutomatically);
        this.rdoDontOpenAutomatically.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.rdoDontOpenAutomatically.text"));
        this.rdoDontOpenAutomatically.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.pnlOpenAutomatically.add((Component)this.rdoDontOpenAutomatically, gridBagConstraints);
        this.rgrOpenAutomatically.add(this.rdoOpenAutomatically);
        this.rdoOpenAutomatically.setSelected(true);
        this.rdoOpenAutomatically.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.rdoOpenAutomatically.text"));
        this.rdoOpenAutomatically.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.pnlOpenAutomatically.add((Component)this.rdoOpenAutomatically, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.pnlOpenAutomatically, gridBagConstraints);
        this.lblCloseAutomatically.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.lblCloseAutomatically.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 3, 10);
        this.add((Component)this.lblCloseAutomatically, gridBagConstraints);
        this.lblParallelDownloads.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.lblParallelDownloads.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 3, 10);
        this.add((Component)this.lblParallelDownloads, gridBagConstraints);
        this.spnParallelDownloads.setModel(new SpinnerNumberModel(2, 1, 50, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.spnParallelDownloads, gridBagConstraints);
        this.pnlCloseAutomatically.setLayout(new GridBagLayout());
        this.rgrCloseAutomatically.add(this.rdoDontCloseAutomatically);
        this.rdoDontCloseAutomatically.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.rdoDontCloseAutomatically.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.pnlCloseAutomatically.add((Component)this.rdoDontCloseAutomatically, gridBagConstraints);
        this.rgrCloseAutomatically.add(this.rdoCloseAutomatically);
        this.rdoCloseAutomatically.setSelected(true);
        this.rdoCloseAutomatically.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.rdoCloseAutomatically.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.pnlCloseAutomatically.add((Component)this.rdoCloseAutomatically, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.pnlCloseAutomatically, gridBagConstraints);
        this.spnNotificationDisplayTime.setModel(new SpinnerNumberModel(3, 1, 50, 1));
        this.spnNotificationDisplayTime.setMinimumSize(new Dimension(52, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.spnNotificationDisplayTime, gridBagConstraints);
        this.lblNotificationDisplayTime.setText(NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.lblNotificationDisplayTime.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 3, 10);
        this.add((Component)this.lblNotificationDisplayTime, gridBagConstraints);
    }

    private void btnChangeDownloadDestinationActionPerformed(ActionEvent evt) {
        int returnValue = this.fileChooser.showOpenDialog(this);
        if (returnValue == 0) {
            File tmp_downloadDestination = this.fileChooser.getSelectedFile();
            if (!tmp_downloadDestination.isDirectory() || !tmp_downloadDestination.canWrite()) {
                LOG.error((Object)("The download manager can't use the directory '" + tmp_downloadDestination.getAbsolutePath() + "'."));
                String errorMessage = NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.btnChangeDownloadDestinationActionPerformed().folder.dialog.message");
                String errorTitle = NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.btnChangeDownloadDestinationActionPerformed().folder.dialog.title");
                JOptionPane.showMessageDialog(this, errorMessage, errorTitle, 0);
            } else {
                this.downloadDestination = tmp_downloadDestination;
                this.downloadDestinationChanged = true;
                this.jhlDownloadDestination.setText(this.downloadDestination.getAbsolutePath());
            }
        }
    }

    private void jhlDownloadDestinationActionPerformed(ActionEvent evt) {
        File directory = new File(this.jhlDownloadDestination.getText());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        BrowserLauncher.openURLorFile((String)this.jhlDownloadDestination.getText());
    }

    @Override
    public void update() {
        this.downloadDestination = DownloadManager.instance().getDestinationDirectory();
        this.downloadDestinationChanged = false;
        this.jobname = DownloadManagerDialog.getInstance().getJobName();
        this.askForJobtitle = DownloadManagerDialog.getInstance().isAskForJobNameEnabled();
        this.openAutomatically = DownloadManagerDialog.getInstance().isOpenAutomaticallyEnabled();
        this.closeAutomatically = DownloadManagerDialog.getInstance().isCloseAutomaticallyEnabled();
        this.parallelDownloads = DownloadManager.instance().getParallelDownloads();
        this.notificationDisplayTime = DownloadManager.instance().getNotificationDisplayTime();
        this.jhlDownloadDestination.setText(this.downloadDestination.getAbsolutePath());
        this.chkAskForJobname.setSelected(this.askForJobtitle);
        this.rdoCloseAutomatically.setSelected(this.closeAutomatically);
        this.rdoDontCloseAutomatically.setSelected(!this.closeAutomatically);
        this.rdoOpenAutomatically.setSelected(this.openAutomatically);
        this.rdoDontOpenAutomatically.setSelected(!this.openAutomatically);
        this.spnParallelDownloads.setValue(this.parallelDownloads);
        this.spnNotificationDisplayTime.setValue(this.notificationDisplayTime);
    }

    @Override
    public void applyChanges() {
        this.downloadDestinationChanged = false;
        this.askForJobtitle = this.chkAskForJobname.isSelected();
        this.openAutomatically = this.rdoOpenAutomatically.isSelected();
        this.closeAutomatically = this.rdoCloseAutomatically.isSelected();
        this.parallelDownloads = (Integer)this.spnParallelDownloads.getValue();
        this.notificationDisplayTime = (Integer)this.spnNotificationDisplayTime.getValue();
        if (!this.askForJobtitle) {
            this.jobname = "";
        }
        DownloadManager.instance().setDestinationDirectory(this.downloadDestination);
        DownloadManagerDialog.getInstance().setJobName(this.jobname);
        DownloadManagerDialog.getInstance().setAskForJobNameEnabled(this.askForJobtitle);
        DownloadManagerDialog.getInstance().setOpenAutomaticallyEnabled(this.openAutomatically);
        DownloadManagerDialog.getInstance().setCloseAutomaticallyEnabled(this.closeAutomatically);
        DownloadManager.instance().setParallelDownloads(this.parallelDownloads);
        AbstractDownload.setParallelDownloads(this.parallelDownloads);
        DownloadManager.instance().setNotificationDisplayTime(this.notificationDisplayTime);
    }

    @Override
    public boolean isChanged() {
        boolean result = false;
        if (this.jobname != null) {
            result = this.downloadDestinationChanged || !this.askForJobtitle == this.chkAskForJobname.isSelected() || !this.openAutomatically == this.rdoOpenAutomatically.isSelected() || !this.closeAutomatically == this.rdoCloseAutomatically.isSelected() || this.parallelDownloads != (Integer)this.spnParallelDownloads.getValue() || this.notificationDisplayTime != (Integer)this.spnNotificationDisplayTime.getValue();
        }
        return result;
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(DownloadManagerOptionsPanel.class, (String)"DownloadManagerOptionsPanel.tooltip");
    }

    @Override
    public Element getConfiguration() throws NoWriteError {
        return DownloadManager.instance().getConfiguration();
    }

    @Override
    public void configure(Element parent) {
        DownloadManager.instance().configure(parent);
    }

    @Override
    public void masterConfigure(Element parent) {
        DownloadManager.instance().masterConfigure(parent);
    }
}

