/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadListChangedEvent;
import de.cismet.tools.gui.downloadmanager.DownloadListChangedListener;
import de.cismet.tools.gui.downloadmanager.DownloadPanel;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import de.cismet.tools.gui.downloadmanager.MultipleDownloadPanel;
import java.awt.Component;
import java.awt.SystemColor;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class DownloadManagerPanel
extends JPanel
implements DownloadListChangedListener {
    private static final Logger LOG = Logger.getLogger(DownloadManagerPanel.class);
    private Map<Download, JPanel> panels = new HashMap<Download, JPanel>();
    private Component verticalGlue = Box.createVerticalGlue();

    public DownloadManagerPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(SystemColor.window);
        this.setLayout(new BoxLayout(this, 3));
    }

    public synchronized void add(Collection<Download> downloads) {
        if (downloads == null || downloads.size() <= 0) {
            return;
        }
        LinkedList<JPanel> oldPanels = new LinkedList<JPanel>();
        for (Component component : this.getComponents()) {
            if (!(component instanceof DownloadPanel) && !(component instanceof MultipleDownloadPanel)) continue;
            oldPanels.add((JPanel)component);
        }
        this.removeAll();
        for (Download download : downloads) {
            JPanel pnlDownload;
            if (download instanceof MultipleDownload) {
                pnlDownload = new MultipleDownloadPanel((MultipleDownload)download);
                download.addObserver((Observer)((Object)pnlDownload));
                this.add(pnlDownload);
                this.panels.put(download, pnlDownload);
                continue;
            }
            pnlDownload = new DownloadPanel(download);
            download.addObserver((Observer)((Object)pnlDownload));
            this.add(pnlDownload);
            this.panels.put(download, pnlDownload);
        }
        for (JPanel pnlDownload : oldPanels) {
            this.add(pnlDownload);
        }
        this.add(this.verticalGlue);
        this.revalidate();
        this.repaint();
    }

    protected synchronized void remove(Collection<Download> downloads) {
        if (downloads == null || downloads.size() <= 0) {
            return;
        }
        this.remove(this.verticalGlue);
        for (Download download : downloads) {
            JPanel pnlDownload = this.panels.get(download);
            if (pnlDownload instanceof Observer) {
                download.deleteObserver((Observer)((Object)pnlDownload));
            }
            this.remove(pnlDownload);
            this.panels.remove(download);
        }
        this.add(this.verticalGlue);
        this.revalidate();
        this.repaint();
    }

    protected synchronized void addSubsequentDownloads(Collection<Download> downloads) {
        if (downloads == null) {
            return;
        }
        for (Download download : downloads) {
            JPanel pnlDownload = this.panels.get(download);
            if (!(pnlDownload instanceof MultipleDownloadPanel)) continue;
            MultipleDownloadPanel mpnlDownload = (MultipleDownloadPanel)pnlDownload;
            mpnlDownload.redrawEncapsulatedDownloads();
        }
    }

    @Override
    public synchronized void downloadListChanged(DownloadListChangedEvent event) {
        Collection<Download> downloads = event.getDownloads();
        switch (event.getAction()) {
            case ADDED: {
                this.add(downloads);
                break;
            }
            case REMOVED: {
                this.remove(downloads);
                break;
            }
            case ADDED_DOWNLOADS_SUBSEQUENTLY: {
                this.addSubsequentDownloads(downloads);
            }
        }
    }
}

